function [declarations,assignments] = make_declarations(obj)
%MAKE_DECLARATIONS Assemble declarations and assignments
%
% [declarations,assignments] = poly_sys.make_declarations returns
% cell arrays containing the names of the properties that contain
% declarations and assignments for a Bertini input file.

% Allow variable case for name of configuration setting (e.g.,
% 'UserHomotopy' and 'USERHOMOTOPY' are equivalent).
configFields = fields(obj.config);
iUser = strcmpi('UserHomotopy',configFields);
iParamotopy = strcmpi('ParameterHomotopy',configFields);

variables = {'variable_group','hom_variable_group'};
declarations = {'random','random_real','definedSubfunction'};
assignments = {'constant'};

if any(iUser) % User homotopy
    assignments = [assignments {'parameter'}];
    declarations = [{'pathvariable'} declarations];
    if obj.config.(configFields{iUser})==1 % affine version
        variables = {'variable'};
    end
elseif any(iParamotopy) && obj.config.(configFields{iParamotopy})>=1 % Parameter homotopy
    declarations = [declarations {'parameter'}];
end
declarations = [variables declarations];
assert(~all(cellfun(@(x) isempty(obj.(x)),variables)), ...
    'BertiniLab:make_declarations:noVariables', 'No variables were declared.')
