function fname = make_data_file(poly_sys,data,fname)
%Make_data_file Create a data input file such as the start file.
%
% fname = poly_sys.make_data_file(data,fname) inputs DATA, a POLYSYM vector or
% structure, and FNAME, the name of the file. If DATA is nonempty, creates
% the file with the data formatted for reading by Bertini and returns the
% full path name of the file in FNAME. Otherwise, just returns an empty
% string for FNAME.
%
% If DATA is a structure, it is expected to have fields corresponding to
% the variables defined by the user.
%
% MAKE_DATA_FILE is used to create the files start, final_parameters and
% member_points. It is called by the method SOLVE.
%
% See also: struct2mat

if ~isempty(data)
      
    fid = fopen(poly_sys.fullname(fname),'w');

    n = size(data,2);
    fprintf(fid,'%d\n%',n);
    
    data = poly_sys.struct2mat(data);
    for ii=1:n
        fprintf(fid,'\n');
        [re,im] = real_imag(data(:,ii));
        c = cellstr(format_array([re im]));
        fprintf(fid,'%s\n',c{:});
    end
    fclose(fid);
    
else
    fname = '';
end