function poly_sys = irreducible_decomposition(poly_sys,varargin)
%IRREDUCIBLE_DECOMPOSITION Determine the irreducible decomposition of a
%system of an algebraic set
%
% poly_sys = poly_sys.irreducible_decomposition calculates the irreducible
% decomposition and updates the property COMPONENTS, a structure with
% information on the components.
%
% poly_sys = poly_sys.irreducible_decomposition(input_file_name) gives the
% name of the input file read by Bertini as a string (Default: 'input').
%
% See also: read_witness_data

poly_sys.config.TrackType = 1;
poly_sys = poly_sys.solve(varargin{:});

if ~isfield(poly_sys.config,'WitnessSupersetOnly') || poly_sys.config.WitnessSupersetOnly == 0
    poly_sys.components = poly_sys.read_witness_data;
end