function fullname = fullname(poly_sys,fname)
%FULLNAME Create full name for file
%
% fname = poly_sys.fullname(name) inputs NAME, a file name that
% may or may not include the path name. If not, the property IO_FOLDER is
% used for the path name.

[pathstr,name,ext] = fileparts(fname);

if isempty(pathstr)
    pathstr = poly_sys.io_folder;
end

fullname = fullfile(pathstr,[name ext]);
