#include "dbL.h"          
		  
   /***************************************************************************\
   *                FUNCTION FZ OF THE ReLaTIve SOFTWARE PACKAGE               *
   *                          FOR NUMERICAL INVERSION	                       *
   *                       OF THE LAPLACE TRANSFORM ON                         *
   *                               THE REAL AXIS                               *
   *                                                                           *
   *                   	   DATABASE OF LAPLACE  TEST FUNCTIONS                 *
   *                                                                           *
   *  Authors: A. MURLI  UNIVERSITY OF NAPLES FEDERICO II                      *
   *           L. D'AMORE UNIVERSITY OF NAPLES FEDERICO II                     *
   *           R. CAMPAGNA UNIVERSITY OF NAPLES FEDERICO II                    *
   *		   V. MELE   UNIVERSITY OF NAPLES FEDERICO II                      *
   *                                                                           *
   \***************************************************************************/

              
/* F(z)=1/z */
double fz1(double z) {
   return 1/z;
}

/*==================================================================*/
   
/* F(z)=1/(z^2) */ 
double fz2(double z) { 
   return 1/gsl_sf_pow_int(z,2);
}

/*==================================================================*/

/* F(z)=1/(1+2*z) */ 
double fz3(double z) {   
   return 1/(1+2*z); 
}

/*==================================================================*/

/* F(z)=1/(z+2)^2 */ 
double fz4(double z) {  
   return 1/(gsl_sf_pow_int((z+2),2)); 
}

/*==================================================================*/

/* F(z)=z/(z-1)^2 */ 
double fz5(double z){    
   return z/gsl_sf_pow_int((z-1),2); 
}

/*==================================================================*/

/* F(z)=1/(z-2)  */
double fz6(double z) {
   return 1./(z-2);
}

/*==================================================================*/

/* F(z)=1/((z+a)^5)  a=3/5 */
double fz7(double z) {
    int n=5;      
   return 1./gsl_sf_pow_int((z+3./5.),n);            
}

/*==================================================================*/

/* F(z)=1/((z+a)(z+b))  a=3/5, b=5/7 */
double fz8(double z) {
   return 1./((z+3./5.)*(z+5./7.));
}

/*==================================================================*/

/* F(z)=z/((z+a)(z+b))  a=3/5, b=5/7 */
double fz9(double z) {
   return z/((z+3./5.)*(z+5./7.));
}

/*==================================================================*/

/* F(z)=(z^2-1)/(z^2+1)^2 */
double fz10(double z){     
   double tmp,pot;  
   pot=gsl_sf_pow_int(z,2); 
   tmp=gsl_sf_pow_int((pot+1),2); 
   return (pot-1)/tmp; 
}

/*==================================================================*/

/* F(z)=z/(z^2+a^2)  a=3/5  */
double fz11(double z) {
   return z/(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2));  
   }

/*==================================================================*/

/* F(z)=1/(z^2+1) */ 
double fz12(double z) { 
   return 1/(gsl_sf_pow_int(z,2)+1);
  } 

/*==================================================================*/

/* F(z)=1/(z^2+z+1) */  
double fz13(double z) { 
   return 1/(gsl_sf_pow_int(z,2)+z+1); 
 }

/*==================================================================*/
   
/* F(z)=1/((z+2.5)^2+1)) */ 
double fz14(double z) { 
   z+=2.5;  
   return 1/(gsl_sf_pow_int(z,2)+1); 
  }

/*==================================================================*/

/* F(z)=1/(z*(z^2+a^2)  a=3/5  */
double fz15(double z) {
   return 1./(z*(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2)));      
}

/*==================================================================*/

/* F(z)=1/(z^2*(z^2+a^2)  a=3/5 */
double fz16(double z) {
   return 1./(gsl_sf_pow_int(z,2)*(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2)));  
}

/*==================================================================*/

/* F(z)=1/pow(z^2+a^2,2)  a=3/5 */
double fz17(double z) {
   return 1./gsl_sf_pow_int(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2),2);      
}

/*==================================================================*/

/* F(z)=z^2/pow(z^2+a^2,2)  a=3/5 */
double fz18(double z) {
   return gsl_sf_pow_int(z,2)/gsl_sf_pow_int(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2),2);     
}

/*==================================================================*/

/* F(z)=(8*a^3*z^2)/(z^2+a^2)^3  a=3/5  b=5/7 */
double fz19(double z) {
   return (8*gsl_sf_pow_int(3./5.,3)*gsl_sf_pow_int(z,2))/gsl_sf_pow_int(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2),3);       
}

/*==================================================================*/

/* F(z)=z/(z^2+a^2)(z^2+b^2)  a=3/5  b=5/7 */
double fz20(double z) {
   return z/((gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2))*(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(5./7.,2)));  
}

/*==================================================================*/

/* F(z)=(z+a)/((z+a)^2+b^2)  a=3/5  b=5/7 */
double fz21(double z) {
   return (z+3./5.)/(gsl_sf_pow_int(z+3./5.,2)+gsl_sf_pow_int(5./7.,2));            
}

/*==================================================================*/

/* F(z)=(3*a^2)/(z^3+a^3)  a=3/5  b=5/7 */
double fz22(double z) {
   return (3*gsl_sf_pow_int(3./5.,2))/(gsl_sf_pow_int(z,3)+gsl_sf_pow_int(3./5.,3));         
}

/*==================================================================*/

/* F(z)=(a^2)/(z^2*(z^2 - a^2))     a=0.5 */ 
double fz23(double z) {
    double tmp=pow(z,2)-0.25;
    return 0.25/(gsl_sf_pow_int(z,2)*tmp);
}

/*==================================================================*/

/* F(z)=1/(z^2-a^2)  a=3/5 */
double fz24(double z) {
   return 1./(gsl_sf_pow_int(z,2)-gsl_sf_pow_int(3./5.,2));     

   }

/*==================================================================*/

/* F(z)=z/(z^2-a^2)  a=3/5 */
double fz25(double z) {
   return z/(gsl_sf_pow_int(z,2)-gsl_sf_pow_int(3./5.,2));          
}

/*==================================================================*/

/* F(z)=(4*a^4)/(z^4+4*a^4)  a=3/5  b=5/7 */
double fz26(double z) {
   return (4*gsl_sf_pow_int(3./5.,4))/(gsl_sf_pow_int(z,4)+4*gsl_sf_pow_int(3./5.,4));             
}

/*==================================================================*/

/* F(z)=z/(z^4+4*a^4)  a=3/5  b=5/7 */
double fz27(double z) {
   return z/(gsl_sf_pow_int(z,4)+4*gsl_sf_pow_int(3./5.,4));                 
}


/*==================================================================*/

/* F(z)=1/(z^4-a^4)  a=3/5  b=5/7  */
double fz28(double z) {
   return 1./(gsl_sf_pow_int(z,4)-gsl_sf_pow_int(3./5.,4));                    
}

/*==================================================================*/

/* F(z)=z/(z^4-a^4)  a=3/5  b=5/7 */
double fz29(double z) {
   return z/(gsl_sf_pow_int(z,4)-gsl_sf_pow_int(3./5.,4));                    
}

/*==================================================================*/

/* F(z)= log((z+a)/(z+b)) a=3/5  b=5/7 */
double fz30(double z) {
   return log((z+3./5.)/(z+5./7.)) ;
}

/*==================================================================*/

/* F(z)= log((z^2+a^2)/(z^2)) a=3/5 */
double fz31(double z) {
   return log((gsl_sf_pow_int(z,2)+gsl_sf_pow_int(3./5.,2))/gsl_sf_pow_int(z,2)) ;           
}

/*==================================================================*/

/* F(z)=log((z+0.5)/(z-0.5)) */  
double fz32(double z) {  
   return log((z+0.5)/(z-0.5)); 
}


/*==================================================================*/

/* F(z)= 1./(sqrt(z)*(z-a^2)), a=3/5    */
double fz33(double z) {
	double a=3./5.;
	return 1./(sqrt(z)*(z-gsl_sf_pow_int(a,2)));
}

/*==================================================================*/

 
/* F(z)= (b^2-a^2)/(sqrt(z)*(z-a^2)*(sqrt(z)+b)), a=3/5, b=5/7   */     
double fz34(double z) {
	double a=3./5.;
	double b=5./7.;
	double a2=gsl_sf_pow_int(a,2);
	double b2=gsl_sf_pow_int(b,2);
	double sz=sqrt(z);
	return (b2-a2)/(sz*(z-a2)*(sz+b));
   }

/*==================================================================*/


/* F(z)= 1./(sqrt(z+a)*((z+b)^(3/2))), a=3/5, b=5/7   */
double fz35(double z) {
	double a=3./5.;
	double b=5./7.;
	double pot=3./2.;
	double b2=pow(z+b,pot);
	double sza=sqrt(z+a);
	return 1./(sza*b2);
}

/*==================================================================*/

/* F(z)= (sqrt(z+2a)-sqrt(z))/(sqrt(z+2a)+sqrt(z)), a=3/5   */
double fz36(double z) {
	double a=3./5.;
	double sz2a=sqrt(z+2*a);
	double sz=sqrt(z);
	return (sz2a-sz)/(sz2a+sz);
}

/*==================================================================*/

/* F(z)= (a-b)^n/((sqrt(z+a)+sqrt(z+b))^2n), a=3/5, b=5/7   */
double fz37(double z) {                                                                       
	double a=3./5.;
	double b=5./7.;
	int n=5;
	int pot=2*n;
	double sza=sqrt(z+a);
	double szb=sqrt(z+b);
	return gsl_sf_pow_int(a-b,n)/(gsl_sf_pow_int(sza+szb,pot));
   }

/*==================================================================*/

/* F(z)=1./(((sqrt(z+a)+sqrt(z))^2nu)*(sqrt(z+a)*sqrt(z))), a=3/5   */
double fz38(double z) {
	int nu=3;
	double a=3./5.;
	double sza=sqrt(z+a);
	double sz=sqrt(z);
	return 1./(gsl_sf_pow_int(sza+sz,2*nu)*(sza*sz));
}

/*==================================================================*/


/* F(z)= ((z-sqrt(z^2-a^2))^nu)/(sqrt(z^2-a^2)), a=3/5   */
double fz39(double z) {
	int nu=3;
	double a=3./5.;
	double x=sqrt(gsl_sf_pow_int(z,2)-gsl_sf_pow_int(a,2));
	double num=gsl_sf_pow_int(z-x,nu);
	return num/x;
}

/*==================================================================*/


/* F(z)=1/((sqrt(z^2+a^2))*exp(k*(sqrt(z^2+a^2)-z))), a=3/5, k=9/11  */
double fz40(double z) {
	double k=9./11.;
	double a=3./5.;
	double x=sqrt(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(a,2));
	double den=exp(k*(x-z));
	return 1./(x*den);
   }

/*==================================================================*/
  
/* F(z)=(sqrt(z+2a)/sqrt(z))-1, a=3/5  */
double fz41(double z) {
   double a=3./5.;
   return (sqrt(z+2*a)/sqrt(z))-1.;
}

/*==================================================================*/

/* F(z)=1./(sqrt(z^2+a^2)), a=3/5  */
double fz42(double z) {
   double a=3./5.;
   return 1./(sqrt(gsl_sf_pow_int(z,2)+gsl_sf_pow_int(a,2)));
}

/*==================================================================*/

/* F(z)=1/(z^(n+(1/2))), n=5   */
double fz43(double z) {
    int n=5;
    double pot=n+(1./2.);
    return 1./pow(z,pot);
}

/*==================================================================*/
 
/* F(z)=1./((z^(3/2))*exp(k*sqrt(z)))  k=9./11.*/
double  fz44(double z) {
    double k=9./11.;
	double tmp=3./2.;
    return 1./(pow(z,tmp)*exp(k*sqrt(z)));
}

 
/*==================================================================*/


/* Test 1 */  
/* F(z)= (1./(z*z+z))*((1.0/(2*z))-(exp(-2*z)/(1-exp(-2*z)))) */
double  fz45(double z) {
    double  B = (1.0/(2.*z))-(exp(-2.*z)/(1.-exp(-2.*z)));
    return (1./(z*z+z))*B;
} 

/*==================================================================*/

/* Test 2 */

double fz46(double z) { 
	double a=100; 
    double sqrt1=sqrt(z);
    double sqrtd2=sqrt(z)/2; 
    return ((a*z-1.)*(exp(sqrtd2)-exp(-sqrtd2))/2)/(z*(z*(exp(sqrt1)-exp(-sqrt1))/2+sqrt1*(exp(sqrt1)+exp(-sqrt1))/2));
} 

/*==================================================================*/

/* Test 3 */
/* F(z)= (1/z)*exp(-r*sqrt((z*(1+z))/(1+c*z))),  r=0.5, c=0.4*/  
double fz47(double z) { 
    double r=0.5;
    double c=0.4;
    double B =-r*sqrt((z*(1+z))/(1+c*z));
    return (1./z)*exp(B);
} 

/*==================================================================*/

/* Test 4 */  
/* F(z)= 1./(z*(sqrt(1+z^2+z^4/16)+(z/4)*sqrt(16+z^2))^2) */
double fz48(double z) {
    double Z2=z*z;
    double Z4=Z2*Z2;
    double ARG=1.+Z2+Z4/16.;
    double A1=sqrt(ARG);
    double A2=(z/4.)*sqrt(16.+Z2);
    return 1./(z*gsl_sf_pow_int((A1+A2),2));
}
 
/*==================================================================*/

/* Test 5 */  
/* F(z)= (z-sqrt(z^2-1))/(sqrt(z)*sqrt(z^2-1)*sqrt(z-0.5*sqrt(z^2-1))) */
double fz49(double z) {  
    double B=z-sqrt(z*z-1.);
    double BB=sqrt(z)*sqrt(z*z-1.)*sqrt(z-0.5*(sqrt(z*z-1.)));
    return B/BB;
}

/*==================================================================*/
