function psnr = psnratio(x,y,L)
%PSNRATIO   Peak Signal-to-Noise ratio.
%
%   PSNR=PSNRATIO(X,Y,L) returns the peak signal-to-noise ratio 
%   between X and Y. L is the maximum possible pixel value of the image. 

[n,m] = size(x);
mse = (sum((x(:)-y(:)).^2))/(n*m);
psnr = 10*log10(L^2/mse);