% Example of how to use QNP for deblurring Poisson-corrupted images   
% with Tikhonov regularization

clear all
close all

startup

% Phantom test problem
load('phantom38'); 
% load('galaxyNGC1288'); 

% Set the regularization parameter value
eta = 0.25;

% initial iterate
rec0 = ones(size(gn))*sum(gn(:))/numel(gn);
TF = fft2(fftshift(psf));

% Save data in structure array 
data.obj = obj; % exact image
data.gn = gn; % blurred and noisy image
data.bg = bg; % background
data.TF = TF; % fft of the psf image
data.rec0 = rec0; % initial guess

% Set objective and constraint functions and save in structure fun_params
fun_params.eta = eta; % regularization parameter 

% Set up parameters
params.max_fft  = 1e3; % maximum number of FFTs
params.kmax = 20; % maximum number of iterations
params.tol_gp = 1e-4; % projected gradient tolerance
params.tol_f = 1e-4; % objective function tolerance

% Quasi-Newton Projection method
[x,histout] = QNP(data,fun_params,params);

% Print numerical results and visualize images
NPoutput(x,histout,data)








