% Example of how to use NP for deblurring Gaussian-corrupted images   
% with Tikhonov regularization

clear all
close all

% Phantom test problem
load('test_lstk'); 

% Set the regularization parameter value
eta = 0.025;

% initial iterate
rec0 = max(gn,0);
TF = fft2(fftshift(psf));

% Save data in structure array 
data.obj = obj; % exact image
data.gn = gn; % blurred and noisy image
data.TF = TF; % fft of the psf image
data.rec0 = rec0; % initial guess

% Set objective and constraint functions and save in structure fun_params
fun_params.eta = eta; % regularization parameter 

% Set up parameters
params.max_fft = 1e3; % maximum number of FFTs
params.kmax = 20; % maximum number of iterations
params.tol_gp = 1e-4; % projected gradient tolerance
params.tol_f = 1e-4; % objective function tolerance

% Newton Projection method
[x,histout] = NP(data,fun_params,params);

% Print numerical results and visualize images
NPoutput(x,histout,data)










