% NPTools.
% Version 1.0  May 2012
% % Copyright (c) 2012 by Germana landi and Elena Loli Piccolomini
%
%
%
% Functions implementing the Newton Projection methods.
%     NCGP       - function implementing the NCGP method
%     NP         - function implementing the NP method
%     QNP        - function implementing the QNP method
%
% Computing Error measures  functions.
%   maerror      - function computing the Mean Absolute Error between two
%                 images
%   mserror      - function computing the Mean Square Error between two
%                 images
%   psnratio     - function computing the Peak Signal-to-Noise ratio
%                  between two images
%
% Utility functions.
%   Amult        - function for the matrix vector product of the hessian
%                  of the objective function
%   armijo_NCGP  - function implementing the Armijo rule in the NCGP
%                  method
%   armijo_NP    - function implementing the Armijo rule in the NP method
%   armijo_QNP   - function implementing the Armijo rule in the QNP method
%   KLTKb_obj    - function for the evaluation of the objective function,
%                  its gradient and hessian for deblurring of Poisson
%                  corrupted images with Tikhonov regularization
%   KLTVb_obj    - function for the evaluation of the objective function,
%                  its gradient and hessian for deblurring of Poisson
%                  corrupted images with Total Variation regularization
%   KLTVn_obj    - function for the evaluation of the objective function,
%                  its gradient and hessian for denoising of Poisson
%                  corrupted images with Total Variation regularization
%   LSTKb_obj    - function for the evaluation of the objective function,
%                  its gradient and hessian for deblurring of Gaussian
%                  corrupted images with Tikhonov regularization
%   LSTVb_obj    - function for the evaluation of the objective function,
%                  its gradient and hessian for deblurring of Gaussian
%                  corrupted images with Total Variation regularization
%   LSTVn_obj    - function for the evaluation of the objective function,
%                  its gradient and hessian for denoising of Gaussian
%                  corrupted images with Total Variation regularization
%   PCGsolver    - function for the solution of the linear system of NCGP
%                  with the Preconditioned Conjugate Gradients method
%   SetTV        - function for setting up the discretization for the
%                  Total Variation function
%
% Output function.
% NPoutput       - function printing the results and visualizing the images
%
%
% Tests and Examples.
%   driver_ncgp          - driver for examples of the NCGP method
%   driver_np_qnp        - driver for examples of the NP method
%   example_deblurKLTIKH - example of how to use NCGP for deblurring
%                          Poisson-corrupted images with Tikhonov
%                          regularization
%   example_deblurKLTV   - example of how to use NCGP for deblurring
%                          Poisson-corrupted images with Total Variation
%                          regularization
%   example_deblurLSTIKH - example of how to use NCGP for deblurring
%                          Gaussian-corrupted images with Tikhonov
%                          regularization
%   example_deblurLSTV   - example of how to use NCGP for deblurring
%                          Gaussian-corrupted images with Total Variation
%                          regularization
%   example_denoiseKLTV  - example of how to use NCGP for denoising
%                          Poisson-corrupted images with Total Variation
%                          regularization
%   example_denoiseLSTV  - example of how to use NCGP for denoising
%                          Gaussian-corrupted images with Total Variation
%                          regularization
%   example_np.m         - example of how to use NP for deblurring
%                          Gaussian-corrupted images with Tikhonov
%                          regularization
%   example_qnp.m        - example of how to use QNP for deblurring
%                          Poisson-corrupted images with Total Variation
%                          regularization
% Data files.
%
%   brain_lstv     - mat file containing the data (exact image, blurred
%                    noisy image, psf image) for restoring a 256-by-256 brain
%                    image corrupted by Gaussian noise
%   brainpet       - mat file containing the data(exact image, blurred noisy
%                    image, psf image and background value) for restoring a
%                    256-by-256 PET brain image corrupted by Poisson noise
%   dot            - mat file containing the data (exact image and noisy
%                    image) for denoising the 100-by-100 dot image
%                    corrupted by Gaussian noise
%   galaxy_NGC1288 - mat file containing the data (exact image, blurred
%                    noisy image, psf image and background value) for
%                    restoring a 256-by-256 galaxy image corrupted by Poisson
%                    noise
%   phantom38      - mat file containing the data (exact image, blurred and
%                    noisy image, psf image and background value) for
%                    restoring a synthetic geometric 400-by-400 image
%                    corrupted by Poisson noise
%   SheppLogan     - mat file containing the data (exact image, blurred
%                    noisy image, psf image and background value) for
%                    restoring the 256-by-256 Shepp Logan image corrupted by
%                    Poisson noise
%  test_lstk       - mat file containing the data (exact image, blurred noisy
%                    image and psf image) for restoring the 256-by-256
%                    cameraman image corrupted by Gaussian noise
