! Computing the intersection of plane curves by solving
! a standard eigenvalue problem by means of
! the Manocha-Demmel approach

program md
  USE f95_lapack, only: la_geevx
  implicit none
  integer:: n,m,i,na1,na2,na3,na4,nb1,nb2,nb3,nb4, nm
  integer,parameter::dp=kind(0.d0)
  real(dp),dimension(:),allocatable::a1,a2,a3,a4,b1,b2,b3,b4
  real(dp),allocatable,dimension(:,:)::matrix1
  real(dp),dimension(:),allocatable::alphar,alphai
  logical::flag
  real(dp)s1,s2,r1,r2,time

  ! INPUT DATA
  open(unit=20,file='pol.pol')
  read(20,*)s1,s2,r1,r2
  read(20,*)na1,na2,na3,na4
  read(20,*)nb1,nb2,nb3,nb4
  allocate(a1(0:na1),a2(0:na2),a3(0:na3),a4(0:na4))
  allocate(b1(0:nb1),b2(0:nb2),b3(0:nb3),b4(0:nb4))
  do i=0,na1
     read(20,*)a1(i)
  end do
  do i=0,na2
     read(20,*)a2(i)
  end do
  do i=0,na3
     read(20,*)a3(i)
  end do
  do i=0,na4
     read(20,*)a4(i)
  end do
  do i=0,nb1
     read(20,*)b1(i)
  end do
  do i=0,nb2
     read(20,*)b2(i)
  end do
  do i=0,nb3
     read(20,*)b3(i)
  end do
  do i=0,nb4
     read(20,*)b4(i)
  end do
  IF (na2==na4.AND.nb2==nb4)THEN
     flag=.FALSE.
     DO i=0,na2
        IF(a2(i)/=a4(i)) GOTO 500
     END DO
     DO i=0,nb2
        IF(b2(i)/=b4(i)) GOTO 500
     END DO
     flag=.TRUE.
500  CONTINUE
  end IF
  if(flag)then
     m=max(nb1,nb2,nb3)
     n=max(na1,na2,na3)
  else
     n=max(na1,na2,na3,na4)
     m=max(nb1+nb4,nb2+nb3,nb2+nb4,nb3+nb1)
  end if

! Compute  eigenvalues.
  nm=n*m
  allocate(alphar(nm),alphai(nm),matrix1(nm,nm))
  time=timing()
  call MD_standard(flag,nb1,nb2,nb3,nb4,na1,na2,na3,na4,b1,b2,b3,b4,a1,a2,a3,a4,matrix1)
  call LA_GEEVX( matrix1, alphar,alphai, BALANC='B')
  write(*,*)"cpu time=",timing()-time
    write(*,*)"eigenvalues"
  do i=1,n*m
     if(abs(alphai(i))<1.d-11*abs(alphar(i)).and.alphar(i)>s1.and.alphar(i)<s2) then
        write(*,*)alphar(i),alphai(i)
     end if
  end do
  stop

contains

  subroutine bezout(n,na, nb, a, b, bez)
    implicit none
    integer :: na,nb,n,i,j
    integer,parameter::dp=kind(0.d0)
    real(dp),dimension (0:)::a,b
    real(dp),dimension(:,:)::bez
    real(dp),dimension(:,:),allocatable::aux1,aux2,aux3,aux4
    real(dp),dimension (0:n)::aa,bb

    !    n = max(na,nb)
    aa=0; bb=0;
    aa(0:na)=a; bb(0:nb)=b
    allocate(aux1(n,n),aux2(n,n),aux3(n,n),aux4(n,n))
    aux1=0;aux2=0;aux3=0;aux4=0
    bez=0
    do i=1,n
       do j=1,n
          if(i+j<=n+1)then
             aux1(i,j)=aa(i+j-1)
             aux3(i,j)=bb(i+j-1)
          end if
          if(j-i>=0)then
             aux2(i,j)=bb(j-i)
             aux4(i,j)=aa(j-i)
          end if
       end do
    end do
    bez=matmul(aux1,aux2)-matmul(aux3,aux4)
  end subroutine bezout

  subroutine m123(flag, na1,na2,na3, na4, a1,a2,a3, a4, m1,m2,m3,m4)
    implicit none
    integer, parameter::dp=kind(0.d0)
    integer :: na1,na2,na3,na4, n
    real(dp),dimension(0:)::a1,a2,a3,a4
    real(dp),dimension(:,:),allocatable::m1,m2,m3,m4
    logical :: flag
    if(.not. flag) then
       n=max(na1,na2,na3,na4)
       allocate(m1(n,n),m2(n,n),m3(n,n),m4(n,n))
       call bezout(n,na3, na2, a3, a2, m1)
       call bezout(n,na2, na1, a4, a1, m2)
       call bezout(n,na1, na3, a1, a3, m3)
       call bezout(n,na1, na3, a2, a4, m4)
    else
       n=max(na1,na2,na3)
       allocate(m1(n,n),m2(n,n),m3(n,n))
       call bezout(n,na3, na2, a3, a2, m1)
       call bezout(n,na2, na1, a2, a1, m2)
       call bezout(n,na1, na3, a1, a3, m3)
    end if
  end subroutine m123

  subroutine MD_standard(flag,na1,na2,na3, na4, nb1,nb2,nb3, nb4, a1,a2,a3,a4, b1,b2,b3,b4, matrix)
    USE la_precision , ONLY: wp => dp
    USE f95_lapack, ONLY: la_getrf, la_getri
    implicit none
    integer,parameter:: dp=kind(0.d0)
    integer:: na1,na2,na3,nb1,nb2,nb3, nb4, na4, i,j, k, n, info
    real(dp),dimension(0:)::a1,a2,a3,b1,b2,b3,b4,a4
    real(dp),dimension(:,:),allocatable::m1,m2,m3, m4,auxinv,aux
    real(dp),dimension(:,:)::matrix
    real(dp),dimension(:),allocatable::bb1,bb2,bb3,bb4
    integer,dimension(:),allocatable::ipiv
    real(dp)::rcond,sm1,sm2,sm3,sm4
    CHARACTER(len=1)::norm
    logical::flag
    norm="1"

    if(.not. flag)then
       n=max(na1,na2,na3,na4)
       m=max(nb1+nb4,nb2+nb3,nb2+nb4,nb3+nb1)
       call m123(flag, na1,na2,na3,na4,a1,a2,a3,a4, m1,m2,m3,m4)
       matrix=0
       do i=1,m*n-n
          matrix(i,n+i)=1
       end do

       allocate(bb1(0:m),bb2(0:m),bb3(0:m),bb4(0:m))
       bb1=0;bb2=0;bb3=0;bb4=0
       bb1(0:nb1)=b1
       bb2(0:nb2)=b2
       bb3(0:nb3)=b3
       bb4(0:nb4)=b4
       allocate(auxinv(n,n),ipiv(n),aux(n,n))

       auxinv=0
       if(nb1+nb4==m)auxinv=auxinv+ bb1(nb1)*bb4(nb4)*m1
       if(nb3+nb2==m)auxinv=auxinv+ (bb3(nb3)*bb2(nb2))*m2
       if(nb2+nb4==m)auxinv=auxinv+ (bb2(nb2)*bb4(nb4))*m3
       if(nb1+nb3==m)auxinv=auxinv+ (bb1(nb1)*bb3(nb3))*m4

       CALL la_getrf(auxinv,ipiv,rcond,norm,info)
       CALL la_getri(auxinv,ipiv)

       do k=0, m-1
          sm1=0;sm2=0;sm3=0;sm4=0
          do i=0,k
             do j=0,k
                if(i+j==k)then
                   sm1=sm1+bb1(i)*bb4(j)
                   sm2=sm2+bb3(i)*bb2(j)
                   sm3=sm3+bb2(i)*bb4(j)
                   sm4=sm4+bb1(i)*bb3(j)
                end if
             end do
          end do
          aux= sm1*m1 + sm2*m2 + sm3*m3 + sm4*m4
          aux=matmul(auxinv,aux)
          do i=1,n
             do j=1,n
                matrix(n*m-n+i,n*k+j)=-aux(i,j)
             end do
          end do
       end do
    else
       n=max(na1,na2,na3)
       m=max(nb1,nb2,nb3)
       norm="1"
       call m123(flag, na1,na2,na3,na4,a1,a2,a3,a4,m1,m2,m3,m4)
       matrix=0
       do i=1,m*n-n
          matrix(i,n+i)=1
       end do

       allocate(bb1(0:m),bb2(0:m),bb3(0:m))
       bb1=0;bb2=0;bb3=0
       bb1(0:nb1)=b1
       bb2(0:nb2)=b2
       bb3(0:nb3)=b3
       allocate(auxinv(n,n),ipiv(n),aux(n,n))
       auxinv=bb1(m)*m1+bb3(m)*m2+bb2(m)*m3
       CALL la_getrf(auxinv,ipiv,rcond,norm,info)
       CALL la_getri(auxinv,ipiv)

       do k=0, m-1
          aux=bb1(k)*m1+bb3(k)*m2+bb2(k)*m3
          aux=matmul(auxinv,aux)
          do i=1,n
             do j=1,n
                matrix(n*m-n+i,n*k+j)=-aux(i,j)
             end do
          end do
       end do
    end if
  end subroutine MD_standard



  subroutine MD_gen(flag,na1,na2,na3,na4, nb1,nb2,nb3,nb4, a1,a2,a3,a4,b1,b2,b3, b4,matrix1,matrix2)
    implicit none
    integer,parameter:: dp=kind(0.d0)
    integer:: na1,na2,na3,na4,nb1,nb2,nb3, nb4,i,j, k, n
    real(dp),dimension(0:)::a1,a2,a3,a4,b1,b2,b3,b4
    real(dp),dimension(:,:),allocatable::m1,m2,m3,m4, aux
    real(dp),dimension(:,:)::matrix1,matrix2    
    real(dp),dimension(:),allocatable::bb1,bb2,bb3,bb4

    real(dp)::sm1,sm2,sm3,sm4

    logical::flag

    if(.not. flag)then
       n=max(na1,na2,na3,na4)
       m=max(nb1+nb4,nb2+nb3,nb2+nb4,nb3+nb1)
       call m123(flag,na1,na2,na3,na4,a1,a2,a3,a4,m1,m2,m3,m4)
       matrix1=0;matrix2=0
       do i=1,m*n-n
          matrix1(i,n+i)=1
       end do
       allocate(bb1(0:m),bb2(0:m),bb3(0:m),bb4(0:m))
       bb1=0;bb2=0;bb3=0;bb4=0
       bb1(0:nb1)=b1
       bb2(0:nb2)=b2
       bb3(0:nb3)=b3
       bb4(0:nb4)=b4

       allocate(aux(n,n)) 
       aux=0
       if(nb1+nb4==m)aux=aux+ bb1(nb1)*bb4(nb4)*m1
       if(nb3+nb2==m)aux=aux+ (bb3(nb3)*bb2(nb2))*m2
       if(nb2+nb4==m)aux=aux+ (bb2(nb2)*bb4(nb4))*m3
       if(nb1+nb3==m)aux=aux+ (bb1(nb1)*bb3(nb3))*m4
       matrix2=0
       do i=1,n*(m-1)
          matrix2(i,i)=1
       end do
       do i=1,n
          do j=1,n
             matrix2(n*(m-1)+i,n*(m-1)+j)=aux(i,j)
          end do
       end do
       do k=0, m-1
          sm1=0;sm2=0;sm3=0;sm4=0
          do i=0,k
             do j=0,k
                if(i+j==k)then
                   sm1=sm1+bb1(i)*bb4(j)
                   sm2=sm2+bb3(i)*bb2(j)
                   sm3=sm3+bb2(i)*bb4(j)
                   sm4=sm4+bb1(i)*bb3(j)
                end if
             end do
          end do

          aux= sm1*m1 + sm2*m2 + sm3*m3 + sm4*m4
          do i=1,n
             do j=1,n
                matrix1(n*m-n+i,n*k+j)=-aux(i,j)
             end do
          end do
       end do
    else
       n=max(na1,na2,na3)
       m=max(nb1,nb2,nb3)
       call m123(flag, na1,na2,na3,na4,a1,a2,a3,a4,m1,m2,m3,m4)
       matrix1=0;matrix2=0
       do i=1,m*n-n
          matrix1(i,n+i)=1
       end do
       allocate(bb1(0:m),bb2(0:m),bb3(0:m))
       bb1=0;bb2=0;bb3=0
       bb1(0:nb1)=b1
       bb2(0:nb2)=b2
       bb3(0:nb3)=b3
       allocate(aux(n,n))    
       aux=bb1(m)*m1+bb3(m)*m2+bb2(m)*m3
       matrix2=0
       do i=1,n*(m-1)
          matrix2(i,i)=1
       end do
       do i=1,n
          do j=1,n
             matrix2(n*(m-1)+i,n*(m-1)+j)=aux(i,j)
          end do
       end do
       do k=0, m-1
          aux=bb1(k)*m1+bb3(k)*m2+bb2(k)*m3
          do i=1,n
             do j=1,n
                matrix1(n*m-n+i,n*k+j)=-aux(i,j)
             end do
          end do
       end do
    end if
  end subroutine MD_gen

FUNCTION timing() RESULT(time)
REAL :: time
! Local variable
INTEGER :: t(8)
CALL DATE_AND_TIME(VALUES=t)
time = 3600.*t(5) + 60.*t(6) + t(7) + 0.001*t(8)
RETURN
END FUNCTION timing

end program md
