// Author:   Jeff Dicker
// For:      Dr. Yves Lucet
// Whatsit:  Unit tests for me_nep2d, me_nep, me_direct

mode(-1);
__test_set = "ME NEP";

function b = testdirect_Quadratic1d()
//compare NEP Moreau envelope algorithm with result
//computed manually for the function f(x)=x^2
	X=(1:4)';//primal grid
	F=X.^2;
	result = me_nep(X,F,X);
	correct = [1;2;5;8];
	b = and(correct == result);
endfunction

function b = testdirect2dnep2d_Quadratic()
//compare results of nep and direct algorithm for the
//bivariate function f(x,y)=4*x^2+4*y^2
	Xr = (1:5)'; Xc = Xr; //primal grid
	Sr = Xr; Sc = Sr;//dual grid
	F = (4 .* (Xr.^2) * ones(1, size(Xr, 1))) + (ones(size(Xc, 1), 1) * (4 .* (Xc').^2));
	result = me_nep2d(Xr, Xc, F, Sr, Sc);
	correct = me_direct2d(Xr, Xc, F, Sr, Sc);	
	b = and(correct == result);
endfunction

function b = testdirect2d_QuadraticUnbalanced()
//compare the result of the bivariate direct2d algorithm with
//the univariate direct algorithm for the separable function
//f(x,y)=x^2+2*y^2
	function f=f(lambda,x),f=lambda * x.^2,endfunction
	function g=g(lambda1,lambda2,x,y),g=f(lambda1,x)+f(lambda2,y),endfunction
	lambda1=1;lambda2=2;
	x1=(-10:10)';x2=(-5:5)';//primal grid
	[X, Y]=ndgrid(x1,x2);F=g(lambda1,lambda2,X,Y);//evaluate g on the primal grid
	s1=(-4:4)';s2=(-5:5)';//dual grid
	desired=me_direct2d(x1,x2,F,s1,s2);
	//check the results by using the fact g is separable
	//so its bivariate Moreau envelope is the sum of the 
	//univariate Moreau envelopes for each of its variables
	Ms1=me_direct(x1,f(lambda1,x1),s1);//univariate Moreau envelope for x1
	Ms2=me_direct(x2,f(lambda2,x2),s2);//univariate Moreau envelope for x2
	//build the bivariate result
	t1 = Ms1 * ones(1,size(Ms2,1));
	t2 = ones(size(Ms1,1),1) * Ms2';
	correct=t1+t2;
	b = and(correct == desired);
endfunction

function b = testNEP_Quadratic1d()
//compare the result of the NEP algorithm with
//manual computation for the function f(x)=x^2
//with primal grid=dual grid
	X=(1:4)';//primal grid
	F=X.^2;
	result = me_nep(X,F,X);
	correct = [1;2;5;8];
	b = and(correct == result);
endfunction

function b = testNEP_Quadratic1d_XdiffS()
//compare the result of the NEP algorithm with
//manual computation for the function f(x)=x^2
//with different primal and dual grids
	X = [1;1.2;1.4;1.6;1.8;2];//primal grid
	S = [-0.5;-0.2;0;0.2;0.5];//dual grid
	F=X.^2;
	result = me_nep(X,F,S);
	correct = me_direct(X,F,S);
	b = and(correct == result);
endfunction


function b = testNEP_Quadratic()
//Compare direct with nep algorithm to compute the 
//Moreau envelope of the bivariate function
//f(x,y)=4*x^2+4*y^2
	Xr = (1:5)'; Xc = Xr; //primal grid
	Sr = Xr; Sc = Sr;//dual grid
	F = (4 .* (Xr.^2) * ones(1, size(Xr, 1))) + (ones(size(Xc, 1), 1) * (4 .* (Xc').^2));
	result = me_nep2d(Xr, Xc, F, Sr, Sc);
	correct = me_direct2d(Xr, Xc, F, Sr, Sc);	
	b = and(correct == result);
endfunction

function b = testNEP_QuadraticTwo()
//Compare direct with nep algorithm to compute the 
//Moreau envelope of the bivariate function
//f(x,y)=4*x^2+4*y^2
	Xr = (-10:10)'; Xc = Xr; //primal grid
	Sr = Xr; Sc = Sr;//dual grid
	F = (4 .* (Xr.^2) * ones(1, size(Xr, 1))) + (ones(size(Xc, 1), 1) * (4 .* (Xc').^2));	
	result = me_nep2d(Xr, Xc, F, Sr, Sc);
	correct = me_direct2d(Xr, Xc, F, Sr, Sc);
	b = and(correct == result);
endfunction

function b = testNEP_Cubic()
//Compare direct with nep algorithm to compute the 
//Moreau envelope of the bivariate function
//f(x,y)=4*x^3+4*y^3
	Xr = (-10:10)'; Xc = Xr; //primal grid
	Sr = Xr; Sc = Sr;//dual grid
	F = (4 .* (Xr.^3) * ones(1, size(Xr, 1))) + (ones(size(Xc, 1), 1) * (4 .* (Xc').^3));	
	result = me_nep2d(Xr, Xc, F, Sr, Sc);
	correct = me_direct2d(Xr, Xc, F, Sr, Sc);
	b = and(correct == result);
endfunction

function b = testNEPrand()
//Compare direct with nep algorithm to compute the 
//Moreau envelope of a randon univariate function
	X = [-10:0.5:10]';//primal grid
	S=[-7:0.4:7]';//dual grid
	f = rand(X);//random values for f
	[X, f] = bb(X,f);//convexify the function (needed to apply the NEP algorithm)
	desired = me_direct(X, f, S);
	result = me_nep(X, f, S);
	//verify the result taking into account roundoff errors
	b = norm(result - desired) < 1E-10;
endfunction

function b = runTestFile()
	b = %t
	b = checkForFail(testWrapper(testdirect_Quadratic1d, "testdirect_Quadratic1d"), b);
	b = checkForFail(testWrapper(testdirect2dnep2d_Quadratic, "testdirect2dnep2d_Quadratic"), b);
	b = checkForFail(testWrapper(testNEP_Quadratic1d, "testNEP_Quadratic1d"), b);
	b = checkForFail(testWrapper(testNEP_Quadratic, "testNEP_Quadratic"), b);
	b = checkForFail(testWrapper(testNEP_Cubic, "testNEP_Cubic"), b);
	b = checkForFail(testWrapper(testNEP_QuadraticTwo, "testNEP_QuadraticTwo"), b);
	b = checkForFail(testWrapper(testNEP_Quadratic1d_XdiffS, "testNEP_Quadratic1d_XdiffS"), b);
	b = checkForFail(testWrapper(testNEPrand, "testNEPrand"), b);
	b = checkForFail(testWrapper(testdirect2d_QuadraticUnbalanced, "testdirect2d_QuadraticUnbalanced"), b);
endfunction
