mode(-1);
function [name] = getMonth(month)
	select month
		case 1 then name = "January";
		case 2 then name = "February";
		case 3 then name = "March";
		case 4 then name = "April";
		case 5 then name = "May";
		case 6 then name = "June";
		case 7 then name = "July";
		case 8 then name = "August";
		case 9 then name = "September";
		case 10 then name = "October";
		case 11 then name = "November";
		case 12 then name = "December";
	end
endfunction

// user set globals
global __test_file;
global __test_exclude;

// automated globals
global __test_set;
global __test_failures;
global __base_dir;
global __test_dir;

// define base directory
__cwd_dir = pwd();
__test_dir = get_absolute_file_path('test.sci');
chdir(__test_dir+"../");
__base_dir = pwd();
chdir(__test_dir);

// this must be defined at the unit test level
__test_set  = "N/A";
__test_failures = 0;

// set up the log file
__test_filename = pwd()+'/test.log';
__test_output = file("open",__test_filename,"unknown");

// write the header
__test_date = getdate();
fprintf(__test_output, "Scilab Unit Test Log :: %s %d, %d", getMonth(__test_date(2)), __test_date(6), __test_date(1));
fprintf(__test_output, "==============================================================================\n");
fprintf(__test_output, "Set Name :: Test Name ................................................[Result]\n");
fprintf(__test_output, "------------------------------------------------------------------------------\n");

// extremely useful for checking if a test failed
// the first call to this must be bool = checkForFail(check, %t), and then following calls
// must then be bool = checkForFail(check, bool)
function b = checkForFail(bool, lastBool)
	if (bool == %f | lastBool == %f)
		b = %f;
	else
		b = %t;
	end
endfunction


function b = testWrapper(testFunc, __test_name)
	global __test_failures;
	r = %f;
	
	errcatch(-1,"continue");  // catch all errors
		r = testFunc();
	if (iserror(-1))
		status = "[Error!]"
		__test_failures = __test_failures + 1
		b = %f
	else
	  if (r)
		status = "[Passed]"
		b = %t
	  else
		status = "[Failed]"
		__test_failures = __test_failures + 1
		b = %f
	  end
	end
	errclear(-1);
	
	line = sprintf("%s :: %s ", __test_set, __test_name);
	while (length(line) < 70), line = sprintf("%s.",line); end;
	
	fprintf(__test_output, "%s%s\n", line,status);
endfunction

// run tests - note that these script files will run their tests through function 
// testWrapper already
function b = runTests()
	// if the user defined __test_file, we'll just test that file
	global __test_file;
	global __test_exclude;
	
	if (length(__test_file) == 0)
		if (MSDOS)
			fileList=ls("test_*.sc?");
		else
			fileList=ls("test_*.sc?","-1");
		end;
	else
		fileList=__test_file;
	end
	
	b=%t;

	for curFileNum=1:size(fileList,1)
		curFile=fileList(curFileNum)
		curFile=stripblanks(curFile);
		
		// if not excluded, execute test files
		if (length(find(__test_exclude == curFile)) == 0)
			clear runTestFile;
			exec(curFile,-1);
			results = runTestFile();
			b = checkForFail(results, b);
		
			if (curFileNum < size(fileList, 1))
				fprintf(__test_output, "------------------------------------------------------------------------------\n");
			end
		end
	end

	fprintf(__test_output, "==============================================================================\n");
	if (b)
		fprintf(__test_output, "All tests passed!\n");
	else
		fprintf(__test_output, "%d test(s) failed!\n", __test_failures);
	end
endfunction

printf("Automated Test Suite\n");
printf("==================================================================\n");

// Print out all of the global variable settings pertaining to tests
printf("\nGlobal Variable Settings\n");
printf("------------------------\n");
if (length(__test_file) > 0)
	printf("__test_file:     %s\n", __test_file);
else
	printf("__test_file:     All files starting with test\n");
end
if (size(__test_exclude, 1) > 0)
	printf("__exclude_file:  %s\n", __test_exclude(1));
	if (size(__test_exclude, 1) > 1)
		for i=2:size(__test_exclude, 1)
			printf("                 %s\n", __test_exclude(i));
		end
	end
else
	printf("__exclude_file: No files excluded\n");
end
printf("------------------------\n");

answer = 1;

if (answer(1) == 1)
	// run all tests!
	__test_results = runTests();

	// give final results
	if (__test_results)
		printf("All tests passed!");
	else
		printf("%d test(s) failed, check log file: %s", __test_failures, __test_filename);
	end
	
	file('close',__test_output)// close file
else
	printf("Tests not ran\n");
end
chdir(__cwd_dir);//restore current directory