//demo file: Compare 4 algorithms to compute the
//Moreau envelope. Each algorithm is
//timed on the computation of the Moreau envelope of the
//function f(x)=x^2 on the grid N={1,2,3,...,n} for increasing 
//values of n=100, 200, 300, ..., 3000. The 4 algorithms compared
//are LLT, PE, NEP, and direct.
//Functions demoed: me_llt, me_ped_d, me_nep, me_direct

//Result: The nep algorithm is the winner but it requires 
//additional assumption on the data. Without these, the llt
//algorithm wins, followed by the pe algorithm. The direct algorithm
//with its quadratic complexity loses except for small values of n.
mode(-1);

//increases the memory allocated to Scilab
s=stacksize();
if s(1) < 0.6 * 10^8
	stacksize(0.6 * 10^8);
end
clear time ff gg;
//Grid containing all the increasing values of n
N=[300:300:3000]';
//boolean to verify all algorithms return the same results
isEqual = %t;
//Define the function whose transforms will be computed
function f=ff(x),f= x.^2,endfunction

printf("Looping till n=%i\n",N(length(N)));
for i=1:size(N,1)
	n=N(i);//size and upper-bound of the grid
	printf("n= %d\n",n);
	Xr=(1:1:n)';//primal grid is {1,2,...,n}
	Sr=Xr;//dual grid is equal to primal grid
	//evaluate the function on the grid. If your function does
	//not allow for vector input, use the feval function.
	f=ff(Xr);
	//time the llt algorithm (linear complexity)
	timer();M1 = me_llt(Xr, f, Sr,0);	time(i, 1) = timer();
	//time the pe algorithm (linear complexity)
	timer();M2 = me_pe_d(f);		time(i, 2) = timer();
	//time the nep algorithm (linear complexity;for convex functions only)
	timer();M3 = me_nep(Xr, f, Sr);		time(i, 3) = timer();
	//time the direct algorithm (quadratic complexity;for comparison only)
	timer();M4 = me_direct(Xr, f, Sr);	time(i, 4) = timer();
	isEqual = isEqual & isequal(M1,M2,M3,M4);
end
//check that all 3 algorithms return the exact same results
if ~isEqual 
	printf("Error! For i=%i not all methods returned the same result",i);
end

//plot the time taken by each algorithm for each value of n
labels =["llt","pe","nep","direct"];
xbasc;
plot2d(N,time);
p=get("hdl");
legends(labels,[1,2,3,4],opt="ul");
q=get("hdl");
thickness=[1;2;1;1];line_style=[1;1;2;4];
for i=1:4
	p.children(i).thickness=thickness(i);
	p.children(i).line_style=line_style(i);
	q.children(2*i).thickness=thickness(i);
	q.children(2*i).line_style=line_style(i);
end
xtitle(['Comparison of Fast Moreau Envelope algorithms'],'n','CPU seconds');
//reset the memory dedicated to Scilab to each previous size
stacksize(s(1));
clear s;
