// CCA toolbox
// builder.sce processes (re)creates html help files from xml files
// The script needs to be run only after xml files are modified.
// The help files are loaded by the loader.sce script.

// For the script to execute successfully 2 files are needed
// manrev.dtd which is copied from SCI/man/ to __base_dir/man/
// html-rev.xsl which has to be installed with scilab in SCI/man/eng/
// unfortunately the Windows binary release of Scilab 4.0 does not include html-rev.xsl
// if that happens, download it from www.scilab.org 
// (either download the source, get it from CVS, or get it from the Linux version)

// define base directory
__cwd_dir = pwd();
__base_dir = get_absolute_file_path('builder.sce');
chdir(__base_dir);//needed to generate the files in the right folder

myhelps=[__base_dir+'man', "CCA (Computational Convex Analysis) toolbox"];

// update %helps for cross reference
%helps_save=%helps;
%helps=[%helps;myhelps];

//rebuild the *.htm help files from the xml files

//check that html-rev.xsl exists
[w,e]=fileinfo(SCI+'\man\eng\html-rev.xsl');
if e == -1 then
	//file not installed with scilab See Bug 1905 and Bug 1906
	//cannot do anything about it except distributing it, and even then
	//it has to be copied to SCI/man/eng which may require administrator privileges
	printf("File html-rev.xsl not found. Please download it and copy it into "+ SCI+"/man/eng/");
else
	//copy manrev.dtd from SCI/MAN to man/
	if MSDOS then
		unix(pathconvert('copy '+SCI+'/man/manrev.dtd  '+__base_dir+'man/',%t,%f,'w'));
	else
		unix('cp '+SCI+'/man/manrev.dtd  '+__base_dir+'/man/');
	end
	//rebuild *.htm files
	xmltohtml(myhelps(:,1),myhelps(:,2));
end

//restore the previous help table
%helps=%helps_save;
//restore current directory
chdir(__cwd_dir);
//erase temporary variables
clear %helps_save xmltohtml myhelps __base_dir get_absolute_file_path
