C THIS FILE CONTAINS THE DRIVER PROGRAM FOR EXAMPLE 3 OF THIS PACKAGE.
C THE USER DOES NOT NEED TO CHANGE THIS FILE TO RUN THIS EXAMPLE,
C BUT HE OR SHE CAN MODIFY IT FOR HIS OR HER OWN EXAMPLES IF DESIRED.
C 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION COEFF(4),DERLFT(4),DERRT(4),DDERRT(4)
C
C THIS SAMPLE DRIVER USES FUNCTION SUBPROGRAM INCHWM TO TRY TO
C DETERMNE WHETHER THE POLYNOMIAL
C
C X**3 - 2*X**2 + X + 0.00001
C
C IS POSITIVE THROUGHOUT THE CLOSED INTERVAL  [0,1].
C
C NOTE THAT WITHOUT THE CONSTANT TERM, THE POLYNOMIAL WOULD HAVE
C A SINGLE ZERO AT 0 AND A DOUBLE ZERO AT 1, AND BE POSITIVE IN
C BETWEEN.
C
C THE ONLY SUBPROGRAMS NEEDED ARE I1MACH, D1MACH, INCHWM, DERCOM,
C ISGNCG, AND TCOMP.  IF THE ENTIRE FILE AMONRAT.F IS COMPILED, HOWEVER,
C THEN THE DUMMY FUNCTION SUBPROGRAM BASFN IN THE FILE BASFN_DY.F IS ALSO
C NEEDED TO AVOID WARNINGS THAT BASFN WAS NOT FOUND.
C
C SET MACHINE AND PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      NWRIT=I1MACH(1)
      SPCMN=D1MACH(3)
C
C OPEN THE OUTPUT FILE.
      OPEN(NWRIT,FILE='EXAMPLE.OUT')
C
C SET THE SMALL POSITIVE NUMBER TOL.
C IF INCHWORM DETECTS A VALUE OF THE INPUT POLYNOMIAL ON THE INPUT
C INTERVAL WHICH IS SMALLER THAN TOL, IT WILL RETURN WITH A
C DECLARATION OF NO DECISION.
C A SUGGESTED VALUE FOR TOL IS 100 TIMES MACHINE PRECISION.
      TOL=100*SPCMN
C
C PUT THE DEGREE OF THE POLYNOMIAL IN NDEG.
C NOTE THAT THE DIMENSIONS OF COEFF, DERLFT, DERRT, AND DDERRT
C ABOVE MUST ALL BE AT LEAST NDEG+1.
C THE LAST THREE OF THESE ARRAYS ARE WORK ARRAYS.
C IF SOME OF THE HIGHEST ORDER COEFFICIENTS IN COEFF ARE ZERO,
C SO THAT THE ACTUAL DEGREE IS LESS THAN NDEG, INCHWM SHOULD
C STILL WORK.
      NDEG=3
C
C PUT THE COEFFICIENTS OF THE POLYNOMIAL IN COEFF, IN ORDER OF
C INCREASING POWERS OF THE VARIABLE.
      COEFF(1)=ONE/10000
      COEFF(2)=ONE
      COEFF(3)=-TWO
      COEFF(4)=ONE
C
C SET THE INTERVAL [ALFT,ART].
      ALFT=ZERO
      ART=ONE
C
C WRITE THE INPUT.
      NDEG1=NDEG+1
      WRITE(NWRIT,100)NDEG,ALFT,ART,TOL,(COEFF(J),J=1,NDEG1)
  100 FORMAT(/14H THE DEGREE IS,I4,17H  THE INTERVAL IS,
     *2D15.6//7H TOL IS,D15.6//
     *45H THE COEFFICIENTS OF INCREASING POWERS OF THE,
     *13H VARIABLE ARE/(/4D15.6))
C
C INVOKE INCHWORM.
      IPOS=INCHWM(NDEG,COEFF,ALFT,ART,TOL,DERLFT,DERRT,
     *DDERRT)
C
C WRITE THE RESULT AND STOP.
      WRITE(NWRIT,200)IPOS
  200 FORMAT(/37H THE RESULT (1 FOR POSITIVE, 0 FOR NO,
     *13H DECISION) IS,I3)
      STOP
      END