C THIS FILE CONTAINS THE MODEL DRIVER PROGRAM FOR RATIONAL APPROXIMATION.
C THE USER MAY NEED TO MAKE SOME SMALL CHANGES IN IT TO RUN HIS OR HER OWN
C EXAMPLES, AS DESCRIBED IN THE FILE AMONRAT.MANUAL.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION X(9),Y(9),PARAM(10),ERRAT(10),
     *JWORK(849),AWORK(6332)
C
C THIS IS THE (ORDINARY OR GENERALIZED) MONOTONE RATIONAL DRIVER
C PROGRAM.  IF THIS DRIVER PROGRAM IS USED, THEN THERE ARE ONLY THREE THINGS
C IN IT THAT THE USER MAY NEED TO CHANGE;  ALL OTHER INPUT IS DONE IN AN
C INPUT DATA FILE CALLED EXAMPLE.DAT (AS DESCRIBED IN THE AMONRAT USER'S
C MANUAL AND, IF GENERALIZED RATIONAL APPROXIMATION IS TO BE DONE, IN
C FUNCTION SUBPROGRAM BASFN AS DESCRIBED IN THE USER'S MANUAL AND IN THE
C FILE BASFN_US.F).
C
C (1)  THE ARRAYS X, Y, PARAM, ERRAT, JWORK, AND AWORK MUST BE
C      DIMENSIONED ABOVE AS DESCRIBED IN THE AMONRAT USERS MANUAL.
C
C (2)  THE DIMENSIONS LJWRK OF JWORK AND LAWRK OF AWORK MUST BE
C      ASSIGNED BELOW.
C
C (3)  THE NUMBER NEVAL OF EQUALLY SPACED POINTS IN THE INTERVAL [X(1),X(NPT)]
C      FOR WHICH SUBROUTINE EVAL WILL PRINT THE ABSCISSAS, DENOMINATOR
C      VALUES, RATIONAL FUNCTION VALUES, AND DIFFERENCES OF RATIONAL
C      FUNCTION VALUES.  (IF YOU DO NOT WISH TO USE SUBROUTINE EVAL, THEN
C      SET NEVAL=0.)
C
C*****SET LJWRK = THE DIMENSION OF JWORK AND LAWRK = THE DIMENSION
C OF AWORK, AND NEVAL.
      LJWRK=849
      LAWRK=6332
      NEVAL=51
C*****END OF SETTING LJWRK, LAWRK, AND NEVAL.
C
C SET MACHINE DEPENDENT CONSTANTS.
      NREAD=I1MACH(1)
      NWRIT=I1MACH(2)
C
C OPEN THE INPUT AND OUTPUT FILES.
      OPEN(NREAD,FILE='EXAMPLE.DAT')
      OPEN(NWRIT,FILE='EXAMPLE.OUT')
C
C READ AND WRITE INITIAL INFORMATION FOR BOTH THE ORDINARY AND
C GENERALIZED CASES.
      READ(NREAD,100)JOPTN,NTOP,NBOT,NPT
  100 FORMAT(4I5)
      WRITE(NWRIT,200)JOPTN,NTOP,NBOT,NPT
  200 FORMAT(9H JOPTN IS,I4,9H  NTOP IS,I4,9H  NBOT IS,I4,
     *8H  NPT IS,I5)
      READ(NREAD,300)(X(I),Y(I),I=1,NPT)
  300 FORMAT(4D15.5)
      WRITE(NWRIT,400)(X(I),Y(I),I=1,NPT)
  400 FORMAT(/39H THE COORDINATES OF THE DATA POINTS ARE/
     *(/2D15.6,4X,2D15.6))
C
C COMPUTE NPARM AND THE ONES, TENS, AND HUNDREDS DIGITS OF JOPTN.
      NPARM=NTOP+NBOT
      JOPONE=JOPTN-(JOPTN/10)*10
      JOPTEN=(JOPTN-(JOPTN/100)*100)/10
      JOPHUN=(JOPTN-(JOPTN/1000)*1000)/100
      IF(JOPHUN)500,500,1200
C
C
C HERE WE ARE DOING ORDINARY (ADAPTIVE) APPROXIMATION.
  500 WRITE(NWRIT,600)
  600 FORMAT(/46H WE ARE DOING ORDINARY RATIONAL APPROXIMATION.)
      IF(JOPTEN)2900,2900,700
C
C HERE WE ARE DOING ORDINARY APPROXIMATION AND OVERRIDING DEFAULTS.
C WE READ AND WRITE VALUES FOR EPS, ETA, METH, LMOUT, ITLIM, LMCON,
C LMMON, LMPOS, AND THE NPARM INITIAL COEFFICIENTS.  WE ALSO PUT
C THESE VALUES IN THE PROPER PLACES IN JWORK, AWORK, AND PARAM FOR
C TRANSMITTAL TO SUBROUTINE AMONRAT.
  700 READ(NREAD,800)EPS,ETA,METH,LMOUT,ITLIM,LMCON,LMMON,
     *LMPOS
  800 FORMAT(2D15.5,6I5)
      WRITE(NWRIT,900)EPS,ETA,METH,LMOUT,ITLIM,LMCON,LMMON,
     *LMPOS
  900 FORMAT(/28H WE ARE OVERRIDING DEFAULTS.//7H EPS IS,D15.5,
     *8H  ETA IS,D15.5//8H METH IS,I3,10H  LMOUT IS,I4,
     *10H  ITLIM IS,I5//9H LMCON IS,I5,10H  LMMON IS,I5,
     *10H  LMPOS IS,I5)
      AWORK(1)=EPS
      AWORK(2)=ETA
      JWORK(1)=METH
      JWORK(2)=LMOUT
      JWORK(3)=ITLIM
      JWORK(4)=LMCON
      JWORK(5)=LMMON
      JWORK(6)=LMPOS
C
C READ THE INITIAL COEFFICIENTS, WITH THE NUMERATOR COEFFICIENTS
C FIRST, OF INCREASING POWERS OF THE VARIABLE.
      READ(NREAD,1000)(PARAM(J),J=1,NPARM)
 1000 FORMAT(4D15.5)
      WRITE(NWRIT,1100)(PARAM(J),J=1,NPARM)
 1100 FORMAT(/29H THE INITIAL COEFFICIENTS ARE/(/4D15.5))
      GO TO 2900
C
C
C HERE WE ARE DOING GENERALIZED (NONADAPTIVE) APPROXIMATION.
 1200 WRITE(NWRIT,1300)
 1300 FORMAT(/49H WE ARE DOING GENERALIZED RATIONAL APPROXIMATION.)
      IF(JOPTEN)2900,2900,1400
C
C HERE WE ARE DOING GENERALIZED APPROXIMATION AND OVERRIDING DEFAULTS.
C WE READ AND WRITE VALUES FOR EPS, ETA, METH, LMOUT, ITLIM, NDENO,
C NDER, AND THE NPARM INITIAL COEFFICIENTS.  WE ALSO PUT THESE VALUES
C IN THE PROPER PLACES IN JWORK, AWORK, AND PARAM FOR TRANSMITTAL TO
C SUBROUTINE AMONRAT.
 1400 READ(NREAD,1500)EPS,ETA,METH,LMOUT,ITLIM,NDENO,NDER
 1500 FORMAT(2D15.5,5I5)
      WRITE(NWRIT,1600)EPS,ETA,METH,LMOUT,ITLIM,NDENO,NDER
 1600 FORMAT(/28H WE ARE OVERRIDING DEFAULTS.//7H EPS IS,D15.5,
     *8H  ETA IS,D15.5//8H METH IS,I3,10H  LMOUT IS,I4,
     *10H  ITLIM IS,I5,10H  NDENO IS,I5,9H  NDER IS,I5)
      AWORK(1)=EPS
      AWORK(2)=ETA
      JWORK(1)=METH
      JWORK(2)=LMOUT
      JWORK(3)=ITLIM
      JWORK(4)=NDENO
      JWORK(5)=NDER
C
C READ THE INITIAL COEFFICIENTS, WITH THE NUMERATOR COEFFICIENTS
C FIRST.
      READ(NREAD,1700)(PARAM(J),J=1,NPARM)
 1700 FORMAT(4D15.5)
      WRITE(NWRIT,1800)(PARAM(J),J=1,NPARM)
 1800 FORMAT(/29H THE INITIAL COEFFICIENTS ARE/(/4D15.5))
C
      IF(NDENO)2200,2200,1900
C
C HERE NDENO IS POSITIVE AND WE READ THE DENOMINATOR CONSTRAINT POINTS
C INTO AWORK(3*NPT+3),...,AWORK(3*NPT+NDENO+2) AND WRITE THEM.
 1900 NSTRT=3*NPT+3
      NEND=NSTRT+NDENO-1
      READ(NREAD,2000)(AWORK(I),I=NSTRT,NEND)
 2000 FORMAT(4D15.5)
      WRITE(NWRIT,2100)(AWORK(I),I=NSTRT,NEND)
 2100 FORMAT(/38H THE DENOMINATOR CONSTRAINT POINTS ARE/
     *(/4D15.5))
C
 2200 IF(NDER)2900,2900,2300
 2300 IF(JOPONE)2600,2600,2400
C
C HERE NDER IS POSITIVE AND JOPTN=111, WHICH IS A CONFLICT BETWEEN
C NOT HAVING DERIVATIVE CONSTRAINTS (JOPONE=1) AND HAVING THEM
C (NDER .GT. 0).  JOPONE WILL TAKE PRECEDENCE, AND SUBROUTINE
C AMONRAT WILL RESET NDER TO 0.
 2400 WRITE(NWRIT,2500)
 2500 FORMAT(/42H *****THE ONES DIGIT OF JOPTN IS 1, SO THE,
     *23H USER-SELECTED POSITIVE//22H VALUE OF NDER WILL BE,
     *34H RESET TO 0 BY SUBROUTINE AMONRAT.)
      GO TO 2900
C
C HERE NDER IS POSITIVE AND WE READ THE DERIVATIVE CONSTRAINT POINTS
C INTO AWORK(3*NPT+NDENO+3),...,AWORK(3*NPT+NDENO+NDER+2) AND
C WRITE THEM.
 2600 NSTRT=3*NPT+NDENO+3
      NEND=NSTRT+NDER-1
      READ(NREAD,2700)(AWORK(I),I=NSTRT,NEND)
 2700 FORMAT(4D15.5)
      WRITE(NWRIT,2800)(AWORK(I),I=NSTRT,NEND)
 2800 FORMAT(/37H THE DERIVATIVE CONSTRAINT POINTS ARE/(/4D15.5))
C
C
C CALL AMONRAT IN EITHER THE ORDINARY OR GENERALIZED CASE.
 2900 CALL AMONRAT(JOPTN,NTOP,NBOT,NPT,X,Y,JWORK,LJWRK,AWORK,
     *LAWRK,PARAM,ERRAT,JFLAG)
C
C WRITE THE ERROR FLAG AND THE DIMENSIONS OF JWORK AND AWORK
C (WHICH WILL HAVE BEEN REPLACED BY THE NEGATIVES OF THE SMALLEST
C ALLOWABLE VALUES, WITH THE ERROR FLAG SET TO 1, IF THEY WERE
C TOO SMALL).
      WRITE(NWRIT,3000)JFLAG,LJWRK,LAWRK
 3000 FORMAT(//9H JFLAG IS,I3,10H  LJWRK IS,I6,10H  LAWRK IS,I6)
C
      IF(JFLAG)3100,3300,4500
C
 3100 WRITE(NWRIT,3200)
 3200 FORMAT(/34H WE HAVE A NORMAL SOLUTION, EXCEPT,
     *31H CONVERGENCE MAY BE INCOMPLETE.//
     *47H POSSIBLE REMEDY:  INCREASE ITLIM AND/OR LMOUT.)
      GO TO 3500
C
 3300 WRITE(NWRIT,3400)
 3400 FORMAT(/27H WE HAVE A NORMAL SOLUTION.)
C
C WRITE THE COMPUTED COEFFICIENTS, THE ERRORS AT THE DATA POINTS,
C AND THE ERROR NORM.
 3500 NT1=NTOP+1
      WRITE(NWRIT,3600)(PARAM(J),J=1,NTOP)
 3600 FORMAT(/31H THE NUMERATOR COEFFICIENTS ARE/(/3D22.14))
      WRITE(NWRIT,3700)(PARAM(J),J=NT1,NPARM)
 3700 FORMAT(/33H THE DENOMINATOR COEFFICIENTS ARE/(/3D22.14))
      WRITE(NWRIT,3800)(ERRAT(I),I=1,NPT)
 3800 FORMAT(/38H THE ERRORS YI - (P/Q)(XI) AT THE DATA,
     *11H POINTS ARE/(/3D22.14))
      WRITE(NWRIT,3900)ERRAT(NPT+1)
 3900 FORMAT(/26H THE UNIFORM ERROR NORM IS//D22.14)
C
C IF WE ARE DOING ORDINARY APPROXIMATION, WRITE THE FINAL NUMBER
C NDENO OF CONSTRAINT POINTS (WHICH SUBROUTINE AMONRAT WILL HAVE
C PLACED IN JWORK(4)) AND THE POINTS (WHICH ARE IN
C AWORK(3*NPT+3),...,AWORK(3*NPT+NDENO+2)).  IN THE GENERALIZED
C CASE THESE POINTS WILL HAVE BEEN FIXED INITIALLY AND SO DO NOT
C NEED TO BE WRITTEN HERE.
      IF(JOPHUN)4000,4000,4200
 4000 NDENO=JWORK(4)
      NSTRT=3*NPT+3
      NEND=3*NPT+NDENO+2
      WRITE(NWRIT,4100)NDENO,(AWORK(I),I=NSTRT,NEND)
 4100 FORMAT(/10H THERE ARE,I5,20H  CONSTRAINT POINTS.,
     *10H  THEY ARE/(/3D22.14))
C
C IF NEVAL .NE. 0, CALL EVAL TO PRINT NEVAL EQUALLY SPACED POINTS IN
C [X(1), X(NPT)], ALONG WITH THE DENOMINATORS, RATIONAL FUNCTION VALUES,
C AND DIFFERENCES OF THE RATIONAL FUNCTION VALUES, AND STOP.  EXAMINING
C THIS OUTPUT MAY HELP THE USER SEE IF THINGS LOOK OK.
C SET MEVAL = -NEVAL AS A SIGNAL TO EVAL IF GENERALIZED RATIONAL
C APPROXIMATION IS BEING USED.
 4200 IF(NEVAL)4250,4230,4250
 4230 STOP
 4250 IF(JOPHUN)4300,4300,4350
 4300 MEVAL=NEVAL
      GO TO 4400
 4350 MEVAL=-NEVAL
 4400 XL=X(1)
      XU=X(NPT)
      CALL EVAL(NTOP,NBOT,PARAM,XL,XU,MEVAL,NWRIT)
      STOP
C
C HERE JFLAG IS POSITIVE, AND WE PRINT A WARINIG AND STOP.
 4500 WRITE(NWRIT,4600)
 4600 FORMAT(//42H ***** WARNING ***** WARNING ***** WARNING,
     *6H *****)
      GO TO (4700,4900,5100,5300,5500,5700,5900),JFLAG
C
C HERE JFLAG=1.
 4700 WRITE(NWRIT,4800)
 4800 FORMAT(/43H THE DIMENSION(S) OF JWORK AND/OR AWORK ARE,
     *14H INSUFFICIENT.//24H SOLUTION:  INCREASE THE,
     *43H DIMENSIONS AND LJWRK AND LAWRK AT LEAST TO//
     *46H THE ABSOLUTE VALUES OF LJWRK AND LAWRK ABOVE.)
      STOP
C
C HERE JFLAG=2.
 4900 WRITE(NWRIT,5000)
 5000 FORMAT(/38H THE SOLUTION PROCESS WAS STOPPED BY A,
     *16H CONMAX FAILURE.//19H POSSIBLE SOLUTION:,
     *18H  CHECK THE INPUT.)
      STOP
C
C HERE JFLAG=3.
 5100 WRITE(NWRIT,5200)
 5200 FORMAT(/41H THE SOLUTION PROCESS WAS STOPPED BECAUSE,
     *16H ALL DENOMINATOR//27H COEFFICIENTS WERE CLOSE TO,
     *6H ZERO.//41H POSSIBLE SOLUTION:  INCREASE EPS (AND/OR,
     *18H APPLY DENOMINATOR//29H CONSTRAINTS AT ALL POINTS IN,
     *23H THE GENERALIZED CASE).)
      STOP
C
C HERE JFLAG=4.
 5300 WRITE(NWRIT,5400)
 5400 FORMAT(/41H THE SOLUTION PROCESS WAS STOPPED BECAUSE,
     *20H A DENOMINATOR VALUE//21H WAS CLOSE TO ZERO OR,
     *10H NEGATIVE.//34H POSSIBLE SOLUTION:  INCREASE EPS,//
     *51H AND/OR APPLY DENOMINATOR CONSTRAINTS AT ALL POINTS,
     *25H IN THE GENERALIZED CASE,//21H AND/OR USE METH=3 IF,
     *17H METH=2 WAS USED.)
      STOP
C
C HERE JFLAG=5.
 5500 WRITE(NWRIT,5600)
 5600 FORMAT(/41H THE SOLUTION PROCESS WAS STOPPED BECAUSE,
     *24H THE LIMIT ON THE NUMBER//21H OF CONSTRAINT POINTS,
     *13H WAS REACHED.//29H POSSIBLE SOLUTION:  INCREASE,
     *7H LMCON.//39H ONE COULD ALSO TRY INCREASING KSTEP IN,
     *19H SUBPROGRAM INCHWM.)
      STOP
C
C HERE JFLAG=6.
 5700 WRITE(NWRIT,5800)
 5800 FORMAT(/41H THE SOLUTION PROCESS WAS STOPPED BECAUSE,
     *24H THE LIMIT ON THE NUMBER//18H OF MONO CALLS WAS,
     *9H REACHED.//36H POSSIBLE SOLUTION:  INCREASE LMMON.//
     *50H ONE COULD ALSO TRY INCREASING KSTEP IN SUBPROGRAM,
     *8H INCHWM.)
      STOP
C
C HERE JFLAG=7.
 5900 WRITE(NWRIT,6000)
 6000 FORMAT(/41H THE SOLUTION PROCESS WAS STOPPED BECAUSE,
     *24H THE LIMIT ON THE NUMBER//21H OF POSITIVITY CHECKS,
     *13H WAS REACHED.//29H POSSIBLE SOLUTION:  INCREASE,
     *7H LMPOS.//39H ONE COULD ALSO TRY INCREASING KSTEP IN,
     *19H SUBPROGRAM INCHWM.)
      STOP
      END