C THIS FILE CONTAINS THE FUNCTION SUBPROGRAM BASFN SET UP FOR
C EXAMPLE 2 IN THE AMONRAT PACKAGE.
C THE USER DOES NOT NEED TO CHANGE THIS FILE.
C
      DOUBLE PRECISION FUNCTION BASFN(ITYPE,LFUN,Z)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
C HERE WE ARE APPROXIMATING BY GENERALIZED RATIONAL FUNCTIONS OF THE FORM
C
C (P0 + P1*COSZ))/(Q0 + Q1*COSZ + Q2*COS(2Z)).
C
C THUS THERE ARE FIVE BASIS FUNCTIONS, AND IN ORDER THEY ARE
C 1.0, COSZ, 1.O, COSZ, AND COS(2Z);
C WE PROVIDE CODE COMPUTING THESE WHEN ITYPE=0.
C
C THEIR DERIVATIVES ARE
C 0.0, -SINZ, 0.0, -SINZ, AND -2SIN(2Z);
C WE PROVIDE CODE COMPUTING THESE WHEN ITYPE=1.
C
C SET PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
C
      GO TO (100,400,100,400,700),LFUN
C
C HERE THE BASIS FUNCTION IS THE CONSTANT 1.0.
  100 IF(ITYPE)200,200,300
  200 BASFN=ONE
      RETURN
  300 BASFN=ZERO
      RETURN
C
C HERE THE BASIS FUNCTION IS COS(Z).
  400 IF(ITYPE)500,500,600
  500 BASFN=DCOS(Z)
      RETURN
  600 BASFN=-DSIN(Z)
      RETURN
C
C HERE THE BASIS FUNCTION IS COS(2Z).
  700 IF(ITYPE)800,800,900
  800 BASFN=DCOS(TWO*Z)
      RETURN
  900 BASFN=-TWO*DSIN(TWO*Z)
      RETURN
      END