C THIS FILE CONTAINS THE SUBPROGRAMS AMONRAT, BMONRAT, MONO, FNSET,
C EVAL, INCHWM, DERCOM, ISGNCG, AND TCOMP.
C THE USER DOES NOT NEED TO CHANGE THIS FILE.
C IF THIS ENTIRE FILE IS COMPILED, THEN ONE OF THE FILES CONTAINING
C FUNCTION SUBPROGRAM BASFN NEEDS TO BE COMPILED ALSO TO AVOID
C WARNINGS THAT BASFN WAS NOT FOUND.
C
      SUBROUTINE AMONRAT(JOPTN,NTOPSN,NBOTSN,NPTSND,X,Y,
     *JWORK,LJWRK,AWORK,LAWRK,PARAM,ERRAT,JFLAG)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION X(NPTSND),Y(NPTSND),JWORK(LJWRK),
     *AWORK(LAWRK),PARAM(NTOPSN+NBOTSN),ERRAT(NPTSND+1)
C
      COMMON/IBLK/JOPHUN,NTOP,NBOT,NPT,METHUS,NDENO,NDER
      COMMON/RBLK/EPS,ETA,DELTK
C
C THIS SUBROUTINE DIVVIES UP THE WORK VECTORS JWORK AND AWORK,
C ESTABLISHES DEFAULTS, AND DOES OTHER SETUP WORK FOR SUBROUTINE
C BMONRAT OR SUBROUTINE MONO.
C
C PLEASE SEE THE AMONRAT USER'S GUIDE FOR MORE INFORMATION
C CONCERNING THE ENTIRE AMONRAT PACKAGE.
C
C SET PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      FOUR=TWO+TWO
      TEN=FOUR+FOUR+TWO
C
C SET SOME PARAMETERS.
      NPT=NPTSND
      NTOP=NTOPSN
      NBOT=NBOTSN
      NPARM=NTOP+NBOT
      JFLAG=0
      JOPONE=JOPTN-(JOPTN/10)*10
      JOPTEN=(JOPTN-(JOPTN/100)*100)/10
      JOPHUN=(JOPTN-(JOPTN/1000)*1000)/100
C
      IF(JOPHUN)100,100,1600
C
C
C HERE THE HUNDREDS DIGIT OF JOPTN IS 0, SO WE ARE DOING ORDINARY
C (ADAPTIVE) RATIONAL APPROXIMATION.
  100 IF(JOPTEN)200,200,400
C
C HERE WE SET DEFAULT VALUES FOR EPS, ETA, METH, LMOUT, ITLIM,
C LMCON, LMMON, LMPOS, AND THE INITIAL COEFFICIENTS.
  200 EPS=ONE/(TEN*TEN*TEN)
      ETA=EPS
      METH=3
      LMOUT=3
      ITLIM=100
      LMCON=41
      LMMON=30
      LMPOS=60
      DO 300 J=1,NPARM
        PARAM(J)=ZERO
  300   CONTINUE
      PARAM(NTOP+1)=ONE
      GO TO 500
C
C HERE WE ARE OVERRIDING DEFAULTS, AND WE EXTRACT USER-SUPPLIED
C VALUES FOR EPS, ETA, METH, LMOUT, ITLIM, LMCOM, LMMON, AND
C LMPOS FROM AWORK AND JWORK.  THE USER-SUPPLIED INITIAL
C COEFFICIENTS WILL ALREADY BE IN PARAM.
  400 EPS=AWORK(1)
      ETA=AWORK(2)
      METH=JWORK(1)
      LMOUT=JWORK(2)
      ITLIM=JWORK(3)
      LMCON=JWORK(4)
      LMMON=JWORK(5)
      LMPOS=JWORK(6)
C
C NOW SET NMGDM = AN UPPER BOUND ON NUMGR FOR CONMAX, GIVEN THE
C VALUES OF NPT, LMCON, NBOT, JOPONE, AND METH.
C IF JOPONE=1 AND METH=1, WE NEED NPT LOCATIONS FOR THE TYPE 2
C CONSTRAINTS, A MAXIMUM OF LMCON LOCATIONS FOR THE DENOMINATOR
C CONSTRAINTS, AND 2*NBOT LOCATIONS FOR THE DENOMINATOR
C COEFFICIENT CONSTRAINTS.
C IF JOPONE=0, WE NEED A MAXIMUM OF LMCON ADDITIONAL LOCATIONS FOR
C THE DERIVATIVE CONSTRAINTS.
C IF METH .NE. 1, THE NPT LOCATIONS FOR THE TYPE 2 CONSTRAINTS
C WILL BE REPLACED BY 2*NPT LOCATIONS FOR THE TYPE 1 CONSTRAINTS
C WHEN DIFFERENTIAL CORRECTION STEPS ARE DONE.
  500 NMGDM=NPT+LMCON+2*NBOT
      IF(JOPONE)600,600,700
  600 NMGDM=NMGDM+LMCON
  700 IF(METH-1)900,900,800
  800 NMGDM=NMGDM+NPT
C
C SET LIWRK AND LWRK AS UPPER BOUNDS ON THE NUMBER OF LOCATIONS
C NEEEDED IN IWORK AND WORK RESPECTIVELY IN CONMAX.
  900 LIWRK=7*NPARM+7*NMGDM+3
      LWRK=2*NPARM**2+4*NMGDM*NPARM+11*NMGDM+27*NPARM+13
C
C SET IPTB = THE MAXIMUM DIMENSION NEEDED FOR PTTBL.
C PTTBL CONSISTS OF (IN THIS ORDER)
C NPT LOCATIONS FOR X,
C NPT LOCATIONS FOR Y,
C NPT LOCATIONS FOR QK, AND
C A MAXIMUM OF LMCON LOCATIONS FOR THE CONSTRAINT POINTS.
C NOTE THAT PTTBL IS A MATRIX ARRAY OF DIMENSION (IPTB,INDM)
C IN CONMAX, BUT FOR SIMPLICITY WE WILL CONVERT IT TO A VECTOR
C ARRAY OF DIMENSION IPTB OUTSIDE OF CONMAX (AND IN SUBROUTINE
C MONO WE WILL TELL CONMAX THAT INDM=1).
      IPTB=3*NPT+LMCON
C
C SET KJWRK AND KAWRK AS THE MINIMUM SAFE DIMENSIONS OF JWORK AND
C AWORK RESPECTIVELY, GIVEN THE VALUES OF NPT, NBOT, LMCON,
C NPARM (=NTOP+NBOT), JOPONE, AND METH.
C JWORK NEEDS 6 LOCATIONS FOR VALUES OF METH, LMOUT, ITLIM,
C LMCON, LMMON, AND LMPOS,
C PLUS LIWRK LOCATIONS FOR IWORK.
C AWORK NEEDS 2 LOCATIONS FOR VALUES OF EPS AND ETA,
C IPTB LOCATIONS FOR PTTBL,
C NPARM LOCATIONS FOR COEF,
C NPT+1 LOCATIONS FOR ERTKP,
C NMGDM+3 LOCATIONS FOR ERROR,
C NPARM-1 LOCATIONS FOR COEFF,
C NPARM-1 LOCATIONS FOR DERLFT,
C NPARM-1 LOCATIONS FOR DERRT,
C NPARM-1 LOCATIONS FOR DDERRT, AND
C LWRK LOCATIONS FOR WORK.
      KJWRK=6+LIWRK
      KAWRK=IPTB+5*NPARM+NPT+NMGDM+LWRK+2
C
C NOW IF LJWRK .LT. KJWRK AND/OR LAWRK .LT. KAWRK, WE RETURN WITH
C THE WARNING JFLAG=1 AFTER SETTING LJWRK=-KJWRK AND/OR
C LAWRK=-KAWRK RESPECTIVELY.
      IF(LJWRK-KJWRK)1100,1000,1000
 1000 IF(LAWRK-KAWRK)1200,1400,1400
 1100 LJWRK=-KJWRK
      IF(LAWRK-KAWRK)1200,1300,1300
 1200 LAWRK=-KAWRK
 1300 JFLAG=1
      RETURN
C
C HERE LJWRK AND LAWRK ARE SUFFICIENTLY LARGE, SO WE PUT X IN
C POSITIONS 3 THROUGH NPT+2 IN AWORK (AND THUS IN POSITIONS
C 1 THROUGH NPT IN PTTBL), AND WE PUT Y IN POSITIONS NPT+3 THROUGH
C 2*NPT+2 IN AWORK (AND THUS IN POSITIONS NPT+1 THROUGH 2*NPT IN
C PTTBL).  THIS ALLOWS THESE VALUES TO BE TRANSMITTED TO
C SUBROUTINE FNSET THROUGH PTTBL.
 1400 NPT2=NPT+2
      DO 1500 I=1,NPT
        AWORK(I+2)=X(I)
        AWORK(NPT2+I)=Y(I)
 1500   CONTINUE
C
C WE NOW SET UP STARTING INDICES IN AWORK FOR SOME VECTORS AS
C FOLLOWS.
C
C   INDEX    VECTOR  DIMENSION
C
C       3     PTTBL       IPTB
C    INDF       FUN        NPT
C    IND1      COEF      NPARM
C    IND2     ERTKP      NPT+1
C    IND3     ERROR    NMGDM+3
C    IND4     COEFF    NPARM-1
C    IND5    DERLFT    NPARM-1
C    IND6     DERRT    NPARM-1
C    IND7    DDERRT    NPARM-1
C    IND8      WORK       LWRK
C
C NOTE THAT FUN, WHICH EQUALS Y, OVERLAPS PTTBL.  IT IS SEPARATED
C OUT HERE BECAUSE IT APPEARS IN THE CALLING SEQUENCE FOR CONMAX.
C ONCE SET, IT WILL NOT BE CHANGED, NOR WILL THE CORRESPONDING
C SECTIONS IN AWORK AND PTTBL.
      INDF=3+NPT
      IND1=3+IPTB
      IND2=IND1+NPARM
      IND3=IND2+NPT+1
      IND4=IND3+NMGDM+3
      IND5=IND4+NPARM-1
      IND6=IND5+NPARM-1
      IND7=IND6+NPARM-1
      IND8=IND7+NPARM-1
C
C NOW CALL BMONRAT TO DO THE ORDINARY ADAPTIVE RATIONAL WORK.
      CALL BMONRAT(JOPTN,METH,NPARM,LMOUT,ITLIM,LMCON,LMMON,
     *LMPOS,AWORK(3),IPTB,NMGDM,NPTSND,AWORK(INDF),
     *AWORK(IND1),AWORK(IND2),AWORK(IND3),AWORK(IND4),
     *AWORK(IND5),AWORK(IND6),AWORK(IND7),JWORK(7),
     *LIWRK,AWORK(IND8),LWRK,PARAM,ERRAT,JFLAG)
C
C PUT NDENO, THE COMPUTED NUMBER OF CONSTRAINT POINTS, INTO
C JWORK(4) (OVERWRITING LMCON) FOR TRANSMITTAL BACK TO THE
C DRIVER PROGRAM.
      JWORK(4)=NDENO
      RETURN
C
C
C HERE THE HUNDREDS DIGIT OF JOPTN IS 1, AND THE REST OF THIS
C SUBROUTINE CONCERNS NONADAPTIVE, GENERALIZED RATIONAL
C APPROXIMATION.
 1600 IF(JOPTEN)1700,1700,2100
C
C HERE WE SET DEFAULT VALUES FOR EPS, ETA, METH, LMOUT, ITLIM,
C NDENO, NDER, AND THE INITIAL COEFFICIENTS.
 1700 EPS=ONE/(TEN*TEN*TEN)
      ETA=EPS
      METH=3
      ITLIM=100
      NDENO=NPT
      NDER=NPT
      IF(JOPONE)1900,1900,1800
 1800 NDER=0
 1900 DO 2000 J=1,NPARM
        PARAM(J)=ZERO
 2000   CONTINUE
      PARAM(NTOP+1)=ONE
      GO TO 2300
C
C HERE WE ARE OVERRIDING DEFAULTS, AND WE EXTRACT USER-SUPPLIED
C VALUES FOR EPS, ETA, METH, LMOUT, ITLIM, NDENO, AND NDER FROM
C AWORK AND JWORK.  THE USER-SUPPLIED INITIAL COEFFICIENTS WILL
C ALREADY BE IN PARAM.
C IF THE USER SETS THE CONTRADICTION THAT THE ONES DIGIT OF
C JOPTN IS 1 BUT NDER .GT. 0, THEN THE ONES DIGIT OF JOPTN WILL
C PREVAIL, AND NDER WILL BE RESET TO 0.
 2100 EPS=AWORK(1)
      ETA=AWORK(2)
      METH=JWORK(1)
      LMOUT=JWORK(2)
      ITLIM=JWORK(3)
      NDENO=JWORK(4)
      NDER=JWORK(5)
      IF(JOPONE)2300,2300,2200
 2200 NDER=0
C
C SET NMGDM = AN UPPER BOUND ON NUMGR FOR CONMAX, GIVEN THE VALUES
C OF NPT, NBOT, METH, NDENO, AND NDER.
C IF METH=1, WE NEED NPT LOCATIONS FOR THE TYPE 2 CONSTRAINTS,
C NDENO LOCATIONS FOR THE DENOMINATOR CONSTRAINTS, NDER LOCATIONS
C FOR THE DERIVATIVE CONSTRAINTS, AND 2*NBOT LOCATIONS FOR THE
C DENOMINATOR COEFFICIENT CONSTRAINTS.
C IF METH .NE. 1, THE NPT LOCATIONS FOR THE TYPE 2 CONSTRAINTS
C WILL BE REPLACED BY 2*NPT LOCATIONS FOR THE TYPE 1 CONSTRAINTS
C WHEN DIFFERENTIAL CORRECTION STEPS ARE DONE.
 2300 NMGDM=NPT+NDENO+NDER+2*NBOT
      IF(METH-1)2500,2500,2400
 2400 NMGDM=NMGDM+NPT
C
C SET LIWRK AND LWRK AS UPPER BOUNDS ON THE NUMBER OF LOCATIONS
C NEEEDED IN IWORK AND WORK RESPECTIVELY IN CONMAX.
 2500 LIWRK=7*NPARM+7*NMGDM+3
      LWRK=2*NPARM**2+4*NMGDM*NPARM+11*NMGDM+27*NPARM+13
C
C SET IPTB = THE MAXIMUM DIMENSION NEEDED FOR PTTBL.
C PTTBL CONSISTS OF (IN THIS ORDER)
C NPT LOCATIONS FOR X,
C NPT LOCATIONS FOR Y,
C NPT LOCATIONS FOR QK,
C NDENO LOCATIONS FOR THE POINTS WHERE DENOMINATOR CONSTRAINTS
C ARE APPLIED,
C NDER LOCATIONS FOR THE POINTS WHERE DERIVATIVE CONSTRAINTS ARE
C APPLIED,
C NPRAM*NPT LOCATIONS FOR THE VALUES OF THE BASIS FUNCTIONS AT THE
C ABSCISSAS OF THE ORIGINAL DATA POINTS,
C NBOT*NDENO LOCATIONS FOR THE VALUES OF THE DENOMINATOR BASIS
C FUNCTIONS AT THE DENOMINATOR CONSTRAINT POINTS, AND
C 2*NPARM*NDER LOCATIONS FOR THE VALUES OF THE BASIS FUNCTIONS AND
C THEIR DERIVATIVES AT THE DERIVATIVE CONSTRAINT POINTS.
C THE BASIS FUNCTION AND DERIVATIVE VALUES ARE STORED IN PTTBL
C FOR USE IN FNSET TO AVOID HAVING TO REPEATEDLY COMPUTE THEM.
C NOTE THAT PTTBL IS A MATRIX ARRAY OF DIMENSION (IPTB,INDM)
C IN CONMAX, BUT FOR SIMPLICITY WE WILL CONVERT IT TO A VECTOR
C ARRAY OF DIMENSION IPTB OUTSIDE OF CONMAX (AND IN SUBROUTINE
C MONO WE WILL TELL CONMAX THAT INDM=1).
      IPTB=3*NPT+NDENO+NDER+NPARM*NPT+NBOT*NDENO+2*NPARM*NDER
C
C SET KJWRK AND KAWRK AS THE MINIMUM SAFE DIMENSIONS OF JWORK AND
C AWORK RESPECTIVELY, GIVEN THE VALUES OF NPT, NBOT, METH, NPARM
C (=NTOP+NBOT), NDENO, AND NDER.
C JWORK NEEDS 5 LOCATIONS FOR VALUES OF METH, LMOUT, ITLIM,
C NDENO, AND NDER,
C PLUS LIWRK LOCATIONS FOR IWORK.
C AWORK NEEDS 2 LOCATIONS FOR VALUES OF EPS AND ETA,
C IPTB LOCATIONS FOR PTTBL,
C NPARM LOCATIONS FOR COEF,
C NPT+1 LOCATIONS FOR ERTKP,
C NMGDM+3 LOCATIONS FOR ERROR, AND
C LWRK LOCATIONS FOR WORK.
      KJWRK=5+LIWRK
      KAWRK=IPTB+NPARM+NPT+NMGDM+LWRK+6
C
C NOW IF LJWRK .LT. KJWRK AND/OR LAWRK .LT. KAWRK, WE RETURN WITH
C THE WARNING JFLAG=1 AFTER SETTING LJWRK=-KJWRK AND/OR
C LAWRK=-KAWRK RESPECTIVELY.
      IF(LJWRK-KJWRK)2700,2600,2600
 2600 IF(LAWRK-KAWRK)2800,3000,3000
 2700 LJWRK=-KJWRK
      IF(LAWRK-KAWRK)2800,2900,2900
 2800 LAWRK=-KAWRK
 2900 JFLAG=1
      RETURN
C
C HERE LJWRK AND LAWRK ARE SUFFICIENTLY LARGE,
C SO WE PUT VARIOUS VALUES INTO PTTBL (AND THUS INTO AWORK).
C THIS ALLOWS THESE VALUES TO BE TRANSMITTED TO SUBROUTINE FNSET
C THROUGH PTTBL.
C WE FIRST PUT X IN POSITIONS 3 THROUGH NPT+2 IN AWORK (AND THUS
C IN POSITIONS 1 THROUGH NPT IN PTTBL), AND WE PUT Y IN POSITIONS
C NPT+3 THROUGH 2*NPT+2 IN AWORK (AND THUS IN POSITIONS NPT+1
C THROUGH 2*NPT IN PTTBL).
 3000 NPT2=NPT+2
      DO 3100 I=1,NPT
        AWORK(I+2)=X(I)
        AWORK(NPT2+I)=Y(I)
 3100   CONTINUE
C
C NEXT, IF WE ARE USING DEFAULT VALUES WE PUT THE DENOMINATOR
C CONSTRAINT POINTS, WHICH WILL BE IN X IN THIS CASE, IN
C POSITIONS 3*NPT+3 THROUGH 4*NPT+2 IN AWORK (AND THUS IN
C POSITIONS 3*NPT+1 THROUGH 4*NPT IN PTTBL), AND IF ALSO
C NDER .GT. 0 WE PUT THE DERIVATIVE CONSTRAINT POINTS (WHICH
C WILL ALSO BE IN X IN THIS CASE) IN POSITIONS 4*NPT+3 THROUGH
C 5*NPT+2 IN AWORK (AND THUS IN POSITIONS 4*NPT+1 THROUGH 5*NPT
C IN PTTBL).
C IF WE ARE OVERRIDING DEFAULTS, THEN THE NDENO DENOMINATOR
C CONSTRAINT POINTS AND NDER DERIVATIVE CONSTRAINT POINTS WILL
C HAVE ALREADY BEEN PLACED IN AWORK (POSITIONS 3*NPT+3 THROUGH
C 3*NPT+NDENO+2 AND 3*NPT+NDENO+3 THROUGH 3*NPT+NDENO+NDER+2
C RESPECTIVELY) AND PTTBL (POSITIONS 3*NPT+1 THROUGH
C 3*NPT+NDENO AND 3*NPT+NDENO+1 THROUGH 3*NPT+NDENO+NDER
C RESPECTIVELY) BY THE USER IN THE DRIVER PROGRAM.
      IF(JOPTEN)3200,3200,3600
 3200 NPT32=3*NPT+2
      DO 3300 I=1,NPT
        AWORK(NPT32+I)=X(I)
 3300   CONTINUE
      IF(NDER)3600,3600,3400
 3400 NPT42=4*NPT+2
      DO 3500 I=1,NPT
        AWORK(NPT42+I)=X(I)
 3500   CONTINUE
C
C NOW, STARTING WITH POSITION 3*NPT+NDENO+NDER+3 IN AWORK (WHICH
C IS POSITION 3*NPT+NDENO+NDER+1 IN PTTBL) WE FILL IN THE VALUES
C OF THE NPARM BASIS FUNCTIONS AT X(1), IN THE SAME ORDER AS
C THE CORRESPONDING COEFFICIENTS IN PARAM (THUS THE NUMERATOR
C BASIS FUNCTIONS APPEAR FIRST).
C IN THE NEXT NPARM POSITIONS WE FILL IN THE VALUES OF THESE
C BASIS FUNCTIONS AT X(2), ETC., PROCEEDING THROUGH X(NPT).
C THIS ALLOWS SUBROUTINE FNSET TO USE THESE VALUES WITHOUT
C REPEATEDLY COMPUTING THEM.
 3600 ISTRT=3*NPT+NDENO+NDER+2
      DO 3800 I=1,NPT
        Z=X(I)
        ISTRTI=ISTRT+(I-1)*NPARM
        DO 3700 LFUN=1,NPARM
          AWORK(ISTRTI+LFUN)=BASFN(0,LFUN,Z)
 3700     CONTINUE
 3800   CONTINUE
C
      IF(NDENO)4200,4200,3900
C
C HERE NDENO .GT. 0 AND, STARTING WITH POSITION
C 3*NPT+NDENO+NDER+NPARM*NPT+3 IN AWORK (WHICH IS POSITION
C 3*NPT+NDENO+NDER+NPARM*NPT+1 IN PTTBL) WE FILL IN THE VALUES
C OF THE NBOT DENOMINATOR BASIS FUNCTIONS AT THE FIRST
C DENOMINATOR CONSTRAINT POINT (WHICH IS IN AWORK(3*NPT+3)), IN
C THE SAME ORDER AS THE CORRESPONDING DENOMINATOR COEFFICIENTS
C APPEAR IN PARAM.
C IN THE NEXT NBOT POSITIONS WE FILL IN THE VALUES OF THE
C DENOMINATOR BASIS FUNCTIONS AT THE SECOND DENOMINATOR
C CONSTRANT POINT (WHICH IS IN AWORK(3*NPT+4)), ETC., PROCEEDING
C THROUGH AWORK(3*NPT+NDENO+2).
 3900 ISTRT=3*NPT+NDENO+NDER+NPARM*NPT+2
      JSTRT=3*NPT+2
      DO 4100 I=1,NDENO
        Z=AWORK(JSTRT+I)
        ISTRTI=ISTRT+(I-1)*NBOT
        DO 4000 J=1,NBOT
          LFUN=NTOP+J
          AWORK(ISTRTI+J)=BASFN(0,LFUN,Z)
 4000     CONTINUE
 4100   CONTINUE
C
 4200 IF(NDER)4600,4600,4300
C
C HERE NDER .GT. 0 AND, STARTING WITH POSITION
C 3*NPT+NDENO+NDER+NPARM*NPT+NBOT*NDENO+3 IN AWORK (WHICH IS
C POSITION 3*NPT+NDENO+NDER+NPARM*NPT+NBOT*NDENO+1 IN PTTBL)
C WE FILL IN THE VALUES OF THE NPARM BASIS FUNCTIONS AT THE FIRST
C DERIVATIVE CONSTRAINT POINT (WHICH IS IN AWORK(3*NPT+NDENO+3)),
C IN THE SAME ORDER AS THE CORRESPONDING COEFFICIENTS APPEAR IN
C PARAM, FOLLOWED BY THE VALUES OF THE DERIVATIVES OF THESE BASIS
C FUNCTIONS AT THIS POINT, AGAIN USING THE SAME ORDER AS THE
C CORRESPONDING COEFFICIENTS APPEAR IN PARAM (THUS WE FILL IN A
C SEQUENCE OF NPARM FUNCTION VALUES, FOLLOWED BY A SEQUENCE OF
C NPARM DERIVATIVE VALUES).
C WE THEN DO THE SAME THING AT THE NEXT DERIVATIVE CONSTRAINT
C POINT (WHICH IS IN AWORK(3*NPT+NDENO+4)), ETC., PROCEEDING
C THROUGH AWORK(3*NPT+NDENO+NDER+2).
 4300 ISTRT=3*NPT+NDENO+NDER+NPARM*NPT+NBOT*NDENO+2
      JSTRT=3*NPT+NDENO+2
      DO 4500 I=1,NDER
        Z=AWORK(JSTRT+I)
        ISTRTI=ISTRT+(I-1)*2*NPARM
        KSTRTI=ISTRTI+NPARM
        DO 4400 LFUN=1,NPARM
          AWORK(ISTRTI+LFUN)=BASFN(0,LFUN,Z)
          AWORK(KSTRTI+LFUN)=BASFN(1,LFUN,Z)
 4400     CONTINUE
 4500   CONTINUE
C
C WE HAVE NOW FINISHED FILLING IN PTTBL, EXCEPT FOR POSITIONS
C 2*NPT+1 THROUGH 3*NPT (I.E. POSITIONS 2*NPT+3 THROUGH 3*NPT+2
C IN AWORK), WHICH WILL BE USED LATER FOR DENOMINATOR VALUES QK.
C WE NOW SET UP STARTING INDICES IN AWORK FOR SOME VECTORS AS
C FOLLOWS.
C
C   INDEX    VECTOR  DIMENSION
C
C       3     PTTBL       IPTB
C    INDF       FUN        NPT
C    IND1      COEF      NPARM
C    IND2     ERTKP      NPT+1
C    IND3     ERROR    NMGDM+3
C    IND4      WORK       LWRK
C
C NOTE AGAIN THAT FUN, WHICH EQUALS Y, OVERLAPS PTTBL.  IT IS
C SEPARATED OUT HERE BECAUSE IT APPEARS IN THE CALLING SEQUENCE
C FOR CONMAX.  ONCE SET, IT WILL NOT BE CHANGED, NOR WILL THE
C CORRESPONDING SECTIONS IN AWORK AND PTTBL.
 4600 INDF=NPT+3
      IND1=IPTB+3
      IND2=IND1+NPARM
      IND3=IND2+NPT+1
      IND4=IND3+NMGDM+3
C
C NOW CALL MONO TO DO THE GENERALIZED RATIONAL WORK.
      CALL MONO(METH,NPARM,LMOUT,ITLIM,AWORK(3),IPTB,NMGDM,
     *NPTSND,AWORK(INDF),AWORK(IND1),AWORK(IND2),
     *AWORK(IND3),JWORK(6),LIWRK,AWORK(IND4),LWRK,PARAM,
     *ERRAT,JFLAG)
      RETURN
      END
      SUBROUTINE BMONRAT(JOPTN,METH,NPARM,LMOUT,ITLIM,LMCON,
     *LMMON,LMPOS,PTTBL,IPTB,NMGDM,NPTSND,FUN,COEF,ERTKP,
     *ERROR,COEFF,DERLFT,DERRT,DDERRT,IWORK,LIWRK,WORK,LWRK,
     *PARAM,ERRAT,JFLAG)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION PTTBL(IPTB),FUN(NPTSND),COEF(NPARM),
     *ERTKP(NPTSND+1),ERROR(NMGDM+3),COEFF(NPARM-1),
     *DERLFT(NPARM-1),DERRT(NPARM-1),DDERRT(NPARM-1),
     *IWORK(LIWRK),WORK(LWRK),PARAM(NPARM),ERRAT(NPTSND+1)
C
      COMMON/IBLK/JOPHUN,NTOP,NBOT,NPT,METHUS,NDENO,NDER
      COMMON/RBLK/EPS,ETA,DELTK
C
C THIS IS THE SUBROUTINE THAT CONTROLS ORDINRY (ADAPTIVE) MONOTONE
C RATIONAL APPROXIMATION.
C
C SET MACHINE AND PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      FOUR=TWO+TWO
      TEN=FOUR+FOUR+TWO
      SPCMN=D1MACH(3)
      TOL=TEN*TEN*SPCMN
C
C COMPUTE THE ONES DIGIT OF JOPTN, AND INITIALIZE THE COUNTERS
C ITMON AND ITPOS.
      JOPONE=JOPTN-(JOPTN/10)*10
      ITMON=0
      ITPOS=0
C
C SET THE NUMBER NDENO OF DENOMINATOR LOWER BOUND CONSTRAINTS TO BE
C USED, AND PUT THEIR LOCATIONS IN PTTBL(3*NPT+1),...,
C PTTBL(3*NPT+NDENO).
      NDENO=NPT
      NPTT3=3*NPT
      DO 60 I=1,NDENO
        PTTBL(NPTT3+I)=PTTBL(I)
   60   CONTINUE
C
C SET THE NUMBER NDER OF DERIVATIVE CONSTRAINTS TO BE USED.
C IF THERE ARE ANY SUCH POINTS, THEIR LOCATIONS WILL HAVE BEEN SET
C IN THE PREVIOUS LOOP SINCE THEY WILL BE THE SAME AS THE
C DENOMINATOR CONSTRAINT POINTS.
      IF(JOPONE)80,80,70
   70 NDER=0
      GO TO 300
   80 NDER=NPT
C
C IF THE USER SET LMMON=0, THEN WE WILL NOT CALL MONO, BUT RATHER
C WILL GO STRAIGHT TO THE POSITIVITY CHECKING.
  300 IF(LMMON)500,500,400
C
C CALL MONO TO COMPUTE A RATIONAL APPROXIMATION WITH THE
C PRESCRIBED CONSTRAINTS.
  400 CALL MONO(METH,NPARM,LMOUT,ITLIM,PTTBL,IPTB,NMGDM,
     *NPTSND,FUN,COEF,ERTKP,ERROR,IWORK,LIWRK,WORK,LWRK,
     *PARAM,ERRAT,JFLAG)
C
C IF JFLAG IS POSITIVE THEN THERE HAS BEEN A BREAKDOWN IN MONO,
C AND WE RETURN.
      IF(JFLAG)450,450,430
  430 RETURN
C
C INCREMENT THE COUNTER OF THE NUMBER OF TIMES MONO WAS CALLED.
  450 ITMON=ITMON+1
C
C CHECK TO SEE IF WE HAVE REACHED THE LIMIT ON THE NUMBER OF
C POSITIVITY CHECKS.  IF SO, SET JFLAG=7 AS A WARNING AND RETURN.
C IF NOT, INCREMENT ITPOS AND DO A POSITIVITY CHECK.
  500 IF(ITPOS-LMPOS)550,520,520
  520 JFLAG=7
      RETURN
C
  550 ITPOS=ITPOS+1
C
C NOW WE CHECK EACH OF THE NDENO-1 SUBINTERVALS FORMED BY THE NDENO
C POINTS ON WHICH THE CONSTRAINT Q .GE. EPS WAS APPLIED (AS WELL AS
C THE CONSTRAINT RPRIME .GE. ETA IF JOPONE=0).
      NSUB=NDENO-1
C
C IF THERE WAS ONLY ONE CONSTRAINT POINT, THEN THE POSITIVITY
C AND DERIVATIVE CONSTRAINTS WILL AUTOMATICALLY BE SATISFIED ON THE
C ONE-POINT INTERVAL CONTAINING IT, SO WE RETURN.
      IF(NSUB)570,570,600
  570 RETURN
C
C INITIALIZE PARAMETERS BEFORE ENTERING THE LOOP OVER THE
C SUBINTERVALS.
  600 LRUN=0
      JADD=0
      IRERUN=0
      IWANT=0
C
C WHEN WE HAVE COMPLETED OR LEFT THE FOLLOWING LOOP OVER THE
C SUBINTERVALS, THERE WILL BE EXACTLY FOUR POSSIBLE CONFIGURATIONS
C OF JADD, IWANT, AND IRERUN, AS FOLLOWS.
C
C IF JADD=0, IWANT=0, AND IRERUN=0, THEN WE WILL HAVE DETERMINED
C THAT Q (AND (P/Q)', IF THE ONES DIGIT OF JOPTN IS 0) ARE
C POSITIVE THROUGHOUT THE CLOSED INTERVAL [X(1),X(NPT)].
C
C IF JADD=0, IWANT=1, AND IRERUN=0, THEN WE WILL NOT HAVE BEEN
C ABLE TO DETERMINE WHETHER THE POSITIVITY IN THE PREVIOUS
C PARAGRAPH HOLDS OR NOT, BUT WE WILL NOT BE ABLE TO ADD ANY MORE
C CONSTRAINT POINTS BECAUSE WE WILL BE AT THE LIMIT ON THE NUMBER
C OF CONSTRAINT POINTS.
C
C IF JADD IS POSITIVE, IWANT=1, AND IRERUN=0, THEN WE WILL HAVE
C ADDED JADD CONSTRAINT POINTS, AT ALL OF WHICH Q .GE. EPS (AND
C (P/Q)' .GE. ETA, IF THE ONES DIGIT OF JOPTN IS 0).
C
C IF JADD IS POSITIVE, IWANT=1, AND IRERUN=1, THEN WE WILL HAVE
C ADDED JADD CONSTRAINT POINTS, AND AT AT LEAST ONE OF THEM WE
C WILL HAVE Q .LT. EPS (OR (P/Q)' .LT. ETA, IF THE ONES DIGIT OF
C JOPTN IS 0).
      DO 4100 L=1,NSUB
C
C INCREMENT LRUN, WHICH WILL BE THE INDEX OF THE LEFT ENDPOINT OF THE
C SUBINTERVAL TO BE CONSIDERED, TAKING INTO THE ACCOUNT THE FACT THAT
C SOME POINTS MAY HAVE BEEN ADDED.
        LRUN=LRUN+1
C
C PUT THE ENDPOINTS OF THE CURRENT SUBINTERVAL IN ALFT AND ART.
        ALFT=PTTBL(3*NPT+LRUN)
        ART=PTTBL(3*NPT+LRUN+1)
C
C PUT THE MAXIMUM DEGREE OF Q IN NDEG AND ITS COEFFICIENTS IN COEFF.
C NOTE THAT THE DIMENSION OF COEFF SHOULD BE AT LEAST
C MAX(NBOT, NTOP+NBOT-2), SO NTOP+NBOT-1 SUFFICES (IN CASE NTOP=1).
C IF NTOP=NBOT, THEN NTOP+NBOT-2 CAN BE REPLACED BY NTOP+NBOT-3 ABOVE.
        NDEG=NBOT-1
        DO 700 J=1,NBOT
          NTJ=NTOP+J
          COEFF(J)=PARAM(NTJ)
  700     CONTINUE
C
C USE INCHWORM TO TRY TO SHOW THAT Q IS POSITIVE THROUGHOUT THE CLOSED
C SUBINTERVAL [ALFT,ART], SETTING IPOSQ=1 IF WE SUCCEED AND SETTING
C IPOSQ=0 IF WE FAIL.
        IPOSQ=INCHWM(NDEG,COEFF,ALFT,ART,TOL,DERLFT,DERRT,
     *  DDERRT)
        IF(IPOSQ)2000,2000,800
C
C HERE IPOSQ=1 AND WE CHECK RPRIME IF JOPONE=0.
C OTHERWISE WE LOOK AT THE NEXT SUBINTERVAL.
  800   IF(JOPONE)900,900,4100
C
C NOW PUT THE MAXIMAL DEGREE OF THE NUMERATOR OF RPRIME IN NDEG AND ITS
C COEFFICIENTS IN COEFF.
  900   NDEG=NTOP+NBOT-3
C
C NOTICE THAT IF NTOP=NBOT, THE DEGREE WILL BE AT MOST NTOP+NBOT-4
C SINCE THE HIGHEST POWER COEFFICIENTS WILL CANCEL.
        IF(NTOP-NBOT)980,960,980
  960   NDEG=NTOP+NBOT-4
C
C IF THE COMPUTED DEGREE IS NEGATIVE THEN BOTH THE NUMERATOR AND
C DENOMINATOR OF R WERE CONSTANT SO RPRIME IS IDENTICALLY ZERO, SO
C WE HAVE A FAILURE TO GUARANTEE POSITIVITY OF RPRIME.
  980   IF(NDEG)2000,1100,1100
C
C WE NOW PUT THE NDEG+1 COEFFICIENTS IN THE NUMERATOR OF RPRIME INTO
C COEFF.
C THIS NUMERATOR IS
C
C PPRIME*Q - P*QPRIME
C = (SUM FROM K1=1 TO NTOP)((K1-1)*PK1*X**(K1-2))
C * (SUM FROM K2=1 TO NBOT)(QK2*X**(K2-1))
C - (SUM FROM K1=1 TO NTOP)(PK1*X**(K1-1))
C * (SUM FROM K2=1 TO NBOT)((K2-1)*QK2*X**(K2-2))
C = (SUM FROM K1=1 TO NTOP)(SUM FROM K2=1 TO NBOT)
C ((K1-K2)*PK1*QK2*X**(K1+K2-3)).
C
C NOTE THAT ALL TERMS IN THIS DOUBLE SUM WITH K1=K2 CAN BE IGNORED
C SINCE THEY WOULD BE ZERO.
C THUS FOR EACH K=3,...,NTOP+NBOT, WE CONSIDER THE PAIRS OF INTEGERS
C K1, K2 WITH K1+K2=K, 1 .LE. K1 .LE. NTOP, 1 .LE. K2 .LE. NBOT,
C K1 .NE. K2, AND WE PUT INTO COEFF(K-2) THE SUM OVER SUCH PAIRS OF
C (K1-K2)*PARAM(K1)*PARAM(NTOP+K2).
 1100   DO 1600 K=3,NPARM
          COF=ZERO
          DO 1500 K1=1,NTOP
            K2=K-K1
            IF(K2-1)1500,1200,1200
 1200       IF(K2-NBOT)1300,1300,1500
 1300       IF(K1-K2)1400,1500,1400
 1400       ISUBQ=NTOP+K2
            COF=COF+(K1-K2)*PARAM(K1)*PARAM(ISUBQ)
 1500       CONTINUE
          COEFF(K-2)=COF
 1600     CONTINUE
C
C USE INCHWORM TO TRY TO SHOW THAT THE NUMERATOR OF RPRIME IS
C POSITIVE THROUGHOUT THE CLOSED SUBINTERVAL [ALFT,ART], SETTING
C IPOSRP=1 IF WE SUCCEED AND IPOSRP=0 IF WE FAIL.
        IPOSRP=INCHWM(NDEG,COEFF,ALFT,ART,TOL,DERLFT,DERRT,
     *  DDERRT)
C
C IF IPOSRP=1 HERE THEN WE HAVE GUARANTEED POSITIVITY OF Q AND RPRIME
C ON THE CLOSED SUBINTERVAL [ALFT,ART], AND WE LOOK AT THE NEXT
C SUBINTERVAL.
        IF(IPOSRP)2000,2000,4100
C
C HERE WE HAVE A FAILURE TO GUARANTEE POSITIVITY OF Q (OR RPRIME,
C IF THE ONES DIGIT OF JOPTN IS 0) ON THIS SUBINTERVAL, SO WE SET
C IWANT=1 TO INDICATE WE WANT TO ADD ANOTHER POINT
 2000   IWANT=1
C
C IF WE ALREADY HAVE THE MAXIMUM ALLOWABLE NUMBER OF POINTS IN OUR
C CONSTRAINT SET THEN WE CANNOT ADD MORE, SO WE LEAVE THE L LOOP.
        IF(NDENO-LMCON)2100,4200,4200
C
C NOW COMPUTE THE MIDPOINT OF THE SUBINTERVAL, INCREMENT JADD AND NDENO,
C AND ADD THIS POINT.
 2100   AMID=(ALFT+ART)/TWO
        JADD=JADD+1
C
C MOVE POINTS LRUN+1,...,NDENO ONE SLOT TO THE RIGHT TO MAKE ROOM FOR
C AMID.
        LRUNP1=LRUN+1
        DO 2200 K=LRUNP1,NDENO
          KK=NDENO-K+LRUNP1
          PTTBL(3*NPT+KK+1)=PTTBL(3*NPT+KK)
 2200     CONTINUE
        PTTBL(3*NPT+LRUNP1)=AMID
        NDENO=NDENO+1
C
C IF JOPONE=0 WE INCREMENT NDER ALSO.  THE DERIVATIVE CONSTRAINT
C POINTS ARE IN THE SAME LOCATIONS IN PTTBL AS THE DENOMINATOR
C CONSTRAINT POINTS, SO AMID WILL HAVE ALREADY BEEN PUT IN ABOVE.
        IF(JOPONE)2300,2300,2450
 2300   NDER=NDER+1
C
C INCREMENT LRUN TO REFLECT THE FACT THAT A POINT HAS BEEN ADDED.
 2450   LRUN=LRUN+1
C
C IF IRERUN=0, INDICATING WE HAVE NOT YET FOUND ANY NEW POINTS
C WHICH WOULD REQUIRE RERUNNING MONO, WE CHECK TO SEE WHETHER
C Q(AMID) .LT. EPS (OR (P/Q)'(AMID) .LT. ETA, IF THE ONES DIGIT
C OF JOPTN IS 0).  IF SO, WE SET IRERUN TO 1.
 2500   IF(IRERUN)2600,2600,4000
C
C CHECK WHETHER Q(AMID) .GE. EPS.  JOPHUN=0 ELSE WE WOULD NOT BE IN
C THIS SUBROUTINE, SO WE COMPUTE QQ AS AN ORDINARY POLYNOMIAL.
 2600   QQ=PARAM(NTOP+1)
        IF(NBOT-1)2850,2850,2700
 2700   DO 2800 J=2,NBOT
          NTJ=NTOP+J
          QQ=QQ+PARAM(NTJ)*AMID**(J-1)
 2800     CONTINUE
 2850   IF(QQ-EPS)3900,2900,2900
 2900   IF(JOPONE)3000,3000,4000
C
C NOW WE MUST CHECK RPRIME AT AMID.
 3000   NDEG=NTOP+NBOT-3
C
C NOTICE THAT IF NTOP=NBOT, THE DEGREE WILL BE AT MOST NTOP+NBOT-4
C SINCE THE HIGHEST POWER COEFFICIENTS WILL CANCEL.
        IF(NTOP-NBOT)3020,3010,3020
 3010   NDEG=NTOP+NBOT-4
 3020   IF(NDEG)3900,3100,3100
C
C ACCUMULATE THE NUMERATOR OF RPRIME AT AMID IN RPTOP.
 3100   DO 3800 K=3,NPARM
          COF=ZERO
          DO 3500 K1=1,NTOP
            K2=K-K1
            IF(K2-1)3500,3200,3200
 3200       IF(K2-NBOT)3300,3300,3500
 3300       IF(K1-K2)3400,3500,3400
 3400       ISUBQ=NTOP+K2
            COF=COF+(K1-K2)*PARAM(K1)*PARAM(ISUBQ)
 3500       CONTINUE
          IF(K-3)3600,3600,3700
 3600     RPTOP=COF
          GO TO 3800
 3700     RPTOP=RPTOP+COF*AMID**(K-3)
 3800     CONTINUE
        RPAMID=RPTOP/(QQ*QQ)
        IF(RPAMID-ETA)3900,4000,4000
C
C HERE WE WILL NEED TO USE SUBROUTINE MONO AGAIN.
 3900   IRERUN=1
C
C HERE WE HAVE JUST ADDED A POINT TO THE CONSTRAINT SET.  IF WE HAVE
C NOW REACHED THE MAXIMUM ALLOWABLE NUMBER OF POINTS WE LEAVE THE
C L LOOP, SINCE WE CANNOT ADD ANY MORE POINTS.
 4000   IF(NDENO-LMCON)4100,4200,4200
C
C END OF L LOOP FOR CHECKING POSITIVITY OF Q (AND ALSO RPRIME IF
C JOPONE=0).
 4100   CONTINUE
 4200 CONTINUE
C
      IF(JADD)5000,5000,4300
C
C HERE WE HAVE ADDED POINTS.  IF IRERUN=1 WE WILL DO MONORAT AGAIN,
C UNLESS WE HAVE ALREADY DONE MONORAT THE MAXIMUM ALLOWED NUMBER OF
C TIMES, IN WHICH CASE WE SET JFLAG=6 AS A WARNING AND RETURN.
 4300 IF(IRERUN)4700,4700,4400
 4400 IF(ITMON-LMMON)400,4500,4500
 4500 JFLAG=6
      RETURN
C
C HERE WE HAVE ADDED POINTS, BUT IRERUN=0 SO RUNNING MONO AGAIN
C WOULD PRODUCE NO CHANGE IN THE RATIONAL FUNCTION.  IF THERE IS
C ROOM TO ADD MORE POINTS AND WE HAVE NOT REACHED THE LIMIT ON THE
C NUMBER OF POSITIVITY CHECKS WE CHECK POSITIVITY AGAIN WITH THE
C IDEA OF ADDING MORE.
C IF THERE IS NO ROOM TO ADD MORE POINTS, WE SET JFLAG=5 AS A
C WARNING AND RETURN.
 4700 IF(NDENO-LMCON)500,4800,4800
 4800 JFLAG=5
      RETURN
C
C HERE WE DID NOT ADD POINTS.  IF WE WANTED TO BUT COULD NOT
C BECAUSE OF THE CONSTRAINT POINT LIMIT, WE SET JFLAG=5 AS A WARNING
C AND RETURN.
C OTHERWISE WE HAVE THE DESIRED SOLUTION, SO WE RETURN.
 5000 IF(IWANT)5100,5100,4800
C
 5100 RETURN
      END
      SUBROUTINE MONO(METH,NPARM,LMOUT,ITLIM,PTTBL,IPTB,NMGDM,
     *NPTSND,FUN,COEF,ERTKP,ERROR,IWORK,LIWRK,WORK,LWRK,
     *PARAM,ERRAT,JFLAG)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION PTTBL(IPTB),FUN(NPTSND),COEF(NPARM),
     *ERTKP(NPTSND+1),ERROR(NMGDM+3),IWORK(LIWRK),WORK(LWRK),
     *PARAM(NPARM),ERRAT(NPTSND+1)
C
      COMMON/IBLK/JOPHUN,NTOP,NBOT,NPT,METHUS,NDENO,NDER
      COMMON/RBLK/EPS,ETA,DELTK
C
C THIS SUBROUTINE COMPUTES A RATIONAL APPROXIMATION P/Q TO THE
C DATA POINTS (PTTBL(I),PTTBL(NPT+I)), I=1,...,NPT,
C WITH THE RESTRICTIONS
C Q .GE. EPS AT THE DENOMINATOR CONSTRAINT POINTS, WHICH ARE
C PTTBL(3*NPT+I), I=1,...,NDENO,
C THE DERIVATIVE OF P/Q .GE. ETA AT THE DERIVATIVE CONSTRAINT
C POINTS, WHICH ARE PTTBL(3*NPT+I), I=1,...,NDER IF JOPHUN=0
C (ORDINARY APPROXIMATION) AND ARE PTTBL(3*NPT+NDENO+I),
C I=1,...,NDER IF JOPHUN=1 (GENERALIZED APPROXIMATION), AND
C THE ABSOLUTE VALUES OF ALL DENOMINATOR COEFFICIENTS ARE .LE. 1.
C
C SET MACHINE AND PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      FOUR=TWO+TWO
      TEN=FOUR+FOUR+TWO
      SPCMN=D1MACH(3)
      DNTOL=TEN*TEN*SPCMN
C
C SET THE OUTER ITERATION COUNTER K, WHICH WILL COUNT THE NUMBER OF
C TIMES CONMAX HAS BEEN CALLED, AND SET SOME OTHER PARAMETERS.
      K=0
      IOPTN=10
      JFLAG=0
      METHUS=METH
      INDM=1
      IFUN=NPT
      NT1=NTOP+1
      NPT1=NPT+1
C
C NUMGR, THE NUMBER OF CONSTRAINTS IN CONMAX, WILL BE
C NPT+NDENO+NDER+2*NBOT IF METH=1 OR 3 AND WILL BE
C 2*NPT+NDENO+NDER+2*NBOT IF METH=2.
C IF METH=3 NUMGR MAY BE CHANGED TO THE METH=2 VALUE LATER.
      NUMGR=NPT+NDENO+NDER+2*NBOT
      IF(METH-2)200,100,200
  100 NUMGR=NUMGR+NPT
C
C METH=2 HERE, AND WE INITIALLY COMPUTE THE DENOMINATORS AND ERROR
C NORM SINCE THESE WILL BE NEEDED IN CONMAX FOR DIFFERENTIAL
C CORRECTION.  IF METH=1 OR METH=3 WE REFRAIN FROM COMPUTING THESE
C INITIAL VALUES SINCE THEY ARE NOT NEEDED, AND IF A DENOMINATOR
C VALUE WERE TOO SMALL (WHICH COULD EASILY OCCUR IN ADAPTIVE
C APPROXIMATION AT AN ADDED CONSTRAINING POINT), THIS WOULD
C TERMINATE THE PROGRAM PREMATURELY.
C THUS USING METH=2 IS RISKY, EXCEPT POSSIBLY WHEN ONE IS JUST
C TRYING TO REFINE A PREVIOUS GOOD APPROXIMATION.
C NOTE THAT NO APPROXIMATION WILL BE RETURNED TO THE USER WHICH
C HAS NOT COME FROM A CONMAX CALL, SINCE OTHERWISE THE RISK OF
C CONSTRAINT VIOLATION IS TOO GREAT.
      GO TO 700
C
C WE NOW CALL CONMAX TO COMPUTE A RATIONAL APPROXIMATION SATISFYING
C THE RESTRICTIONS, OR TO IMPROVE SUCH AN APPROXIMATION BY DOING
C A DIFFERENTIAL CORRECTION STEP IF METHUS=2.
C WE SET IWORK(1)=3 AND WORK(1)=10**(-10) EACH TIME CONMAX IS
C CALLED WHICH, ALONG WITH THE TENS DIGIT OF IOPTN=1, WILL DIRECT
C CONMAX TO NOT ALLOW MORE THAN 3 CONSECUTIVE ITERATIONS WITH
C IMPROVEMENT OF LESS THAN 10**(-10), THUS POSSIBLY SAVING SOME
C COMPUTER TIME.  ALSO, THIS WILL MAKE ARITHMETIC UNDERFLOWS LESS
C LIKELY;  THESE ARE ANNOYING BUT USUALLY HARMLESS.
  200 IWORK(1)=3
      WORK(1)=TEN**(-10)
      CALL CONMAX(IOPTN,NPARM,NUMGR,ITLIM,FUN,IFUN,PTTBL,
     *IPTB,INDM,IWORK,LIWRK,WORK,LWRK,ITER,PARAM,ERROR)
C
C INCREMENT THE COUNT OF THE NUMBER OF TIMES CONMAX HAS BEEN
C CALLED IN THIS CALL TO MONO.
      K=K+1
      IF(ITER)300,700,700
C
C HERE ITER WAS NEGATIVE, SO CONMAX WAS UNABLE TO PRODUCE A RATIONAL
C APPROXIMATION SATISFYING THE CONSTRAINTS.
C IF THIS WAS THE FIRST CONMAX CALL, WE SET JFLAG=2 AS A WARNING
C AND RETURN.
C OTHERWISE WE RESTORE THE VALUES OF PARAM AND ITER FROM THE PREVIOUS
C CONMAX CALL.
  300 IF(K-1)400,400,500
  400 JFLAG=2
      RETURN
C
C RESTORE PARAM AND ITER.
  500 DO 600 J=1,NPARM
        PARAM(J)=COEF(J)
  600   CONTINUE
      ITER=ITERKP
      GO TO 4300
C
C HERE CONMAX PRODUCED A RATIONAL APPROXIMATION SATISFYING THE
C CONSTRAINTS, OR ELSE METH=2 AND WE ARE EXAMINING THE INITIAL
C COEFFICIENTS, AND WE COMPUTE THE LARGEST ABSOLUTE VALUE OF
C THE DENOMINATOR COEFFICIENTS.
  700 AMAX=ZERO
      DO 900 J=1,NBOT
        NTJ=NTOP+J
        AA=ABS(PARAM(NTJ))
        IF(AA-AMAX)900,900,800
  800   AMAX=AA
  900   CONTINUE
      IF(AMAX-DNTOL)1000,1200,1200
C
C HERE ALL THE DENOMINATOR COEFFICIENTS ARE SMALLER THAN DNTOL
C IN ABSOLUTE VALUE.
C IF THIS WAS THE FIRST CONMAX CALL (OR THE INITIAL APPROXIMATION
C IN THE METH=2 CASE), WE SET JFLAG=3 AS A WARNING AND RETURN.
C OTHERWISE WE RESTORE THE VALUES OF PARAM AND ITER FROM THE PREVIOUS
C CONMAX CALL.
 1000 IF(K-1)1100,1100,500
 1100 JFLAG=3
      RETURN
C
C HERE THERE IS AT LEAST ONE DENOMINATOR COEFFICIENT WITH ABSOLUTE
C VALUE AT LEAST DNTOL, AND WE NORMALIZE THE RATIONAL FUNCTION SO
C THAT THE LARGEST ABSOLUTE VALUE OF ANY DENOMINATOR COEFFICIENT
C IS 1.
C NOTE THAT UNLESS THIS IS THE INITIAL APPROXIMATION IN THE METH=2
C CASE, AMAX SHOULD BE .LE. 1 DUE TO CONSTRAINTS IN CONMAX.
 1200 DO 1300 J=1,NPARM
        PARAM(J)=PARAM(J)/AMAX
 1300   CONTINUE
C
C NOW FOR THE ABSCISSA X(I) OF EACH DATA POINT (SO I=1,...,NPT),
C WE COMPUTE THE DENOMINATOR VALUE QKI = QK(X(I)) AND PUT IT IN
C PTTBL(2*NPT+I) FOR POSSIBLE LATER USE IN SUBROUTINE FNSET.
C IF QKI .GE. DNTOL WE ALSO COMPUTE THE NUMERATOR VALUE
C PKI = PK(X(I)) AND THE ERROR ERRAT(I) = Y(I) - PKI/QKI.
C IF ALL QKI .GE. DNTOL, WE ALSO COMPUTE DELTK = ERRAT(NPT+1)
C = MAX(ERRAT(I),I=1,...,NPT).
C IF SOME QKI .LT. DNTOL, THEN IF WE HAVE DONE ONLY ONE CONMAX
C CALL OR THIS IS THE INITIAL APPROXIMATION IN THE METH=2 CASE,
C WE SET JFLAG=4 AS A WARNING AND RETURN;
C IF WE HAVE DONE MORE THAN ONE CONMAX CALL, WE RESTORE DELTK,
C ERRAT, PARAM, AND ITER FROM THE PREVIOUS CONMAX CALL.
      DELTK=ZERO
      ISTRT=3*NPT+NDENO+NDER
      DO 2800 I=1,NPT
C
C COMPUTE QKI AND PUT IT IN PTTBL(2*NPT+I).
        IF(JOPHUN)1400,1400,1700
C
C HERE JOPHUN=0 AND WE COMPUTE QKI AS AN ORDINARY POLYNOMIAL.
 1400   XI=PTTBL(I)
        QKI=PARAM(NT1)
        IF(NBOT-1)1900,1900,1500
 1500   DO 1600 J=2,NBOT
          NTJ=NTOP+J
          QKI=QKI+PARAM(NTJ)*XI**(J-1)
 1600     CONTINUE
        GO TO 1900
C
C HERE JOPHUN=1 AND WE COMPUTE QKI AS A GENERALIZED POLYNOMIAL.
 1700   ISTRTI=ISTRT+(I-1)*NPARM
        QKI=ZERO
        DO 1800 J=NT1,NPARM
          QKI=QKI+PARAM(J)*PTTBL(ISTRTI+J)
 1800     CONTINUE
 1900   PTTBL(2*NPT+I)=QKI
        IF(QKI-DNTOL)2900,2000,2000
C
C HERE QKI .GE. DNTOL AND WE COMPUTE PKI AND PUT
C PTTBL(NPT+I) - PKI/QKI IN ERRAT(I).
 2000   IF(JOPHUN)2100,2100,2400
C
C HERE JOPHUN=0 AND WE COMPUTE PKI AS AN ORDINARY POLYNOMIAL.
 2100   PKI=PARAM(1)
        IF(NTOP-1)2600,2600,2200
 2200   DO 2300 J=2,NTOP
          PKI=PKI+PARAM(J)*XI**(J-1)
 2300     CONTINUE
        GO TO 2600
C
C HERE JOPHUN=1 AND WE COMPUTE PKI AS A GENERALIZED POLYNOMIAL.
 2400   PKI=ZERO
        DO 2500 J=1,NTOP
          PKI=PKI+PARAM(J)*PTTBL(ISTRTI+J)
 2500     CONTINUE
C
 2600   ERRAT(I)=PTTBL(NPT+I)-PKI/QKI
        ABERR=ABS(ERRAT(I))
        IF(ABERR-DELTK)2800,2800,2700
 2700   DELTK=ABERR
 2800   CONTINUE
      ERRAT(NPT+1)=DELTK
      GO TO 3300
C
C HERE WE FOUND A QKI IN THE I LOOP ABOVE WITH QKI .LT. DNTOL.
 2900 IF(K-1)3000,3000,3100
 3000 JFLAG=4
      RETURN
C
 3100 DELTK=DELPR
      DO 3200 I=1,NPT1
        ERRAT(I)=ERTKP(I)
 3200   CONTINUE
      GO TO 500
C
C HERE WE HAVE SUCCESSFULLY COMPUTED ALL QKI AND PKI, DELTK, AND
C ERRAT.
C IF K=0, WHICH WILL OCCUR HERE IFF THIS IS THE INITIAL
C APPROXIMATION IN THE METH=2 CASE, THEN WE DO THE FIRST CONMAX
C CALL.
 3300 IF(K)200,200,3350
C
C HERE K .GE. 1.
C IF METH=1 HERE, THEN WE WILL ALSO HAVE K=1, AND WE WILL DO NO
C MORE CONMAX CALLS.
 3350 IF(METH-1)4300,4300,3400
C
C HERE METH IS 2 OR 3.
 3400 IF(K-1)3600,3600,3500
C
C HERE WE HAVE DONE MORE THAN ONE CONMAX CALL.  IF DELTK HAS
C NOT IMPROVED, WE RESTORE THE PREVIOUS DELTK, ERRAT, PARAM,
C AND ITER.
 3500 IF(DELTK-DELPR)3600,3100,3100
C
C SEE IF WE HAVE REACHED THE LIMIT ON THE NUMBER OF CONMAX CALLS.
 3600 IF(K-LMOUT)3700,4300,4300
C
C HERE K .LT. LMOUT, AND EITHER K IS 1, OR ELSE K .GT. 1 AND
C DELTK HAS IMPROVED.
C WE SAVE DELTK, ERRAT, PARAM, AND ITER IN DELPR, ERTKP, COEF,
C AND ITERKP RESPECTIVELY.
 3700 DELPR=DELTK
      DO 3800 I=1,NPT1
        ERTKP(I)=ERRAT(I)
 3800   CONTINUE
      DO 3900 J=1,NPARM
        COEF(J)=PARAM(J)
 3900   CONTINUE
      ITERKP=ITER
C
C NOW IF METHUS=3 HERE, WE WILL NECESSARILY HAVE K=1, AND WE RESET
C METHUS TO 2 (WHERE IT WILL REMAIN FOR THE REST OF THIS CALL TO
C MONO) AND INCREASE NUMGR FOR THE DIFFERENTIAL CORRECTION STEPS.
C REGARDLESS OF WHETHER METHUS IS 2 OR 3 (THE ONLY POSSIBILITIES
C HERE), WE CALL CONMAX AGAIN TO TRY TO IMPROVE THE CURRENT
C RATIONAL APPROXIMATION.
      IF(METHUS-3)200,4200,4200
 4200 METHUS=2
      NUMGR=NUMGR+NPT
      GO TO 200
C
C HERE WE HAVE HAD AT LEAST ONE SUCCESSFUL CONMAX CALL, BUT WE WILL
C DO NO MORE CONMAX CALLS DUE TO A PROBLEM WITH THE LAST CONMAX CALL
C OR ITS AFTERMATH, OR HAVING REACHED THE ITERATION LIMIT LMOUT, OR
C HAVING METH=1.
C IF ITER=ITLIM HERE WE SET JFLAG=-1 AS A CAUTION THAT THE
C CONVERGENCE MAY NOT BE COMPLETE, AND WE RETURN.  ITER HERE IS THE
C NUMBER OF ITERATIONS INSIDE CONMAX FOR THE CONMAX CALL WHICH
C PRODUCED THE RATIONAL APPROXIMATION WHICH IS TO BE RETURNED.
C IF ITER .LT. ITLIM WE JUST RETURN.
C IN EITHER CASE THE BEST APPROXIMATION WE HAVE BEEN ABLE TO PROVIDE
C WILL HAVE ITS COEFFICIENTS IN PARAM AND ITS ERRORS IN ERRAT.
 4300 IF(ITER-ITLIM)4500,4400,4400
 4400 JFLAG=-1
 4500 RETURN
      END
      SUBROUTINE FNSET(NPARM,NUMGR,PTTBL,IPTB,INDM,PARAM,IPT,INDFN,
     *ICNTYP,CONFUN)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION PTTBL(IPTB),PARAM(NPARM),ICNTYP(NUMGR),
     *CONFUN(NUMGR,NPARM+1)
C
      COMMON/IBLK/JOPHUN,NTOP,NBOT,NPT,METHUS,NDENO,NDER
      COMMON/RBLK/EPS,ETA,DELTK
C
C THIS IS THE SUBROUTINE FNSET FOR MONORAT.
C IT IS CALLED BY THE CONMAX PACKAGE.
C NOTE THAT WE ARE USING PTTBL AS A VECTOR ARRAY OF DIMENSION IPTB
C RATHER THAN AS A MATRIX ARRAY OF DIMENSION (IPTB,1).
C
C SET MACHINE AND PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      SPCMN=D1MACH(3)
      TOLCON=SQRT(SPCMN)
C
      I1=NPT
      IF(METHUS-2)200,100,200
  100 I1=2*NPT
  200 I2=I1+2*NBOT
      I3=I2+NDENO
C
      IF(IPT-I1)300,300,2900
  300 IF(METHUS-2)1000,2500,1000
C
C
C HERE IPT .LE. NPT AND METHUS = 1 OR 3 AND WE SET CONFUN(IPT,1) = THE
C VALUE OF THE RATIONAL FUNCTION AT POINT IPT.
 1000 ICNTYP(IPT)=2
      IF(JOPHUN)1050,1050,2411
C
C HERE WE ARE USING ORDINARY RATIONALS OF THE FORM
C
C (PARAM(1) + PARAM(2)*PT +...+ PARAM(NTOP)*PT**(NTOP-1))/
C (PARAM(NTOP+1) + PARAM(NTOP+2)*PT +...+ PARAM(NPARM)*PT**(NBOT-1)),
C
C WITH PT = PTTBL(IPT).
C
 1050 PT=PTTBL(IPT)
      PP=PARAM(1)
      IF(NTOP-1)1300,1300,1100
 1100 DO 1200 J=2,NTOP
        PP=PP+PARAM(J)*PT**(J-1)
 1200   CONTINUE
 1300 QQ=PARAM(NTOP+1)
      IF(NBOT-1)1600,1600,1400
 1400 DO 1500 J=2,NBOT
        NTJ=NTOP+J
        QQ=QQ+PARAM(NTJ)*PT**(J-1)
 1500   CONTINUE
C
C NOTE THAT HERE WE SHOULD HAVE QQ .GE. EPS BECAUSE OF THE
C DENOMINATOR CONSTRAINTS, SO THE NEXT STATEMENT SHOULD NOT CAUSE
C A DIVISION PROBLEM UNLESS THE USER HAS OVERRIDEN THE DEFAULT
C SETTING OF EPS AND MADE EPS TOO SMALL (E.G. ZERO).
 1600 CONFUN(IPT,1)=PP/QQ
      IF(INDFN)2400,2400,1800
C
C HERE INDFN .GT. 0 AND WE COMPUTE THE PARTIAL DERIVATIVES.
 1800 CONFUN(IPT,2)=ONE/QQ
      IF(NTOP-1)2100,2100,1900
 1900 DO 2000 J=2,NTOP
        CONFUN(IPT,J+1)=PT*CONFUN(IPT,J)
 2000   CONTINUE
 2100 FACT=-PP/QQ**2
      CONFUN(IPT,NTOP+2)=FACT
      IF(NBOT-1)2400,2400,2200
 2200 DO 2300 J=2,NBOT
        NTJ=NTOP+J
        CONFUN(IPT,NTJ+1)=PT*CONFUN(IPT,NTJ)
 2300   CONTINUE
C
 2400 RETURN
C
C HERE WE ARE USING GENERALIZED RATIONALS OF THE FORM
C
C (PARAM(1)*PTTBL(NSTRT+1) + PARAM(2)*PTTBL(NSTRT+2) +...+
C PARAM(NTOP)*PTTBL(NSTRT+NTOP))/
C (PARAM(NTOP+1)*PTTBL(NSTRT+NTOP+1) +
C PARAM(NTOP+2)*PTTBL(NSTRT+NTOP+2) +...+
C PARAM(NPARM)*PTTBL(NSTRT+NPARM)),
C
C WITH NSTRT = 3*NPT + NDENO + NDER + (IPT-1)*NPARM.
C
 2411 NSTRT=3*NPT+NDENO+NDER+(IPT-1)*NPARM
      PP=ZERO
      DO 2421 J=1,NTOP
        PP=PP+PARAM(J)*PTTBL(NSTRT+J)
 2421   CONTINUE
      QQ=ZERO
      NT1=NTOP+1
      DO 2431 J=NT1,NPARM
        QQ=QQ+PARAM(J)*PTTBL(NSTRT+J)
 2431   CONTINUE
      CONFUN(IPT,1)=PP/QQ
      IF(INDFN)2471,2471,2441
 2441 DO 2451 J=1,NTOP
        CONFUN(IPT,J+1)=PTTBL(NSTRT+J)/QQ
 2451   CONTINUE
      FACT=-PP/QQ**2
      DO 2461 J=NT1,NPARM
        CONFUN(IPT,J+1)=FACT*PTTBL(NSTRT+J)
 2461   CONTINUE
 2471 RETURN
C
C
C HERE IPT .LE. I1 = 2*NPT AND METHUS = 2, SO WE SET A CONSTRAINT OF THE
C FORM (FQ - P - DELTK*Q)/QK .LE. W OR (-FQ + P - DELTK*Q)/QK .LE. W.
 2500 ICNTYP(IPT)=1
      IQUOT=(IPT+1)/2
      NTIQ=NTOP+IQUOT
      IREM=IPT+1-2*IQUOT
      QK=PTTBL(2*NPT+IQUOT)
      FUNIQ=PTTBL(NPT+IQUOT)
      IF(IREM)2520,2520,2525
C
C HERE IPT IS ODD AND WE SET THE CONSTRAINT
C (-1.0/QK)*P + ((F - DELTK)/QK)*Q .LE. W.
 2520 FACTP=-ONE/QK
      FACTQ=(FUNIQ-DELTK)/QK
      GO TO 2530
C
C HERE IPT IS EVEN AND WE SET THE CONSTRAINT
C (1.0/QK)*P + ((-F - DELTK)/QK)*Q .LE. W.
 2525 FACTP=ONE/QK
      FACTQ=(-FUNIQ-DELTK)/QK
C
 2530 IF(JOPHUN)2535,2535,2801
C
C HERE WE ARE USING ORDINARY RATIONALS OF THE FORM
C
C (PARAM(1) + PARAM(2)*PT +...+ PARAM(NTOP)*PT**(NTOP-1))/
C (PARAM(NTOP+1) + PARAM(NTOP+2)*PT +...+ PARAM(NPARM)*PT**(NBOT-1)),
C
C WITH PT = PTTBL(IQUOT).
C
 2535 PT=PTTBL(IQUOT)
      PP=PARAM(1)
      IF(NTOP-1)2580,2580,2540
 2540 DO 2560 J=2,NTOP
        PP=PP+PARAM(J)*PT**(J-1)
 2560   CONTINUE
 2580 QQ=PARAM(NTOP+1)
      IF(NBOT-1)2640,2640,2600
 2600 DO 2620 J=2,NBOT
        NTJ=NTOP+J
        QQ=QQ+PARAM(NTJ)*PT**(J-1)
 2620   CONTINUE
C
 2640 CONFUN(IPT,1)=FACTP*PP+FACTQ*QQ
      IF(INDFN)2400,2400,2660
 2660 CONFUN(IPT,2)=FACTP
      IF(NTOP-1)2720,2720,2680
 2680 DO 2700 J=2,NTOP
        CONFUN(IPT,J+1)=PT*CONFUN(IPT,J)
 2700   CONTINUE
 2720 CONFUN(IPT,NTOP+2)=FACTQ
      IF(NBOT-1)2400,2400,2740
 2740 DO 2760 J=2,NBOT
        NTJ=NTOP+J
        CONFUN(IPT,NTJ+1)=PT*CONFUN(IPT,NTJ)
 2760   CONTINUE
      RETURN
C
C HERE WE ARE USING GENERALIZED RATIONALS OF THE FORM
C
C (PARAM(1)*PTTBL(NSTRT+1) + PARAM(2)*PTTBL(NSTRT+2) +...+
C PARAM(NTOP)*PTTBL(NSTRT+NTOP))/
C (PARAM(NTOP+1)*PTTBL(NSTRT+NTOP+1) +
C PARAM(NTOP+2)*PTTBL(NSTRT+NTOP+2) +...+
C PARAM(NPARM)*PTTBL(NSTRT+NPARM)),
C
C WITH NSTRT = 3*NPT + NDENO + NDER + (IQUOT-1)*NPARM.
C
 2801 NSTRT=3*NPT+NDENO+NDER+(IQUOT-1)*NPARM
      PP=ZERO
      DO 2811 J=1,NTOP
        PP=PP+PARAM(J)*PTTBL(NSTRT+J)
 2811   CONTINUE
      QQ=ZERO
      NT1=NTOP+1
      DO 2821 J=NT1,NPARM
        QQ=QQ+PARAM(J)*PTTBL(NSTRT+J)
 2821   CONTINUE
      CONFUN(IPT,1)=FACTP*PP+FACTQ*QQ
      IF(INDFN)2861,2861,2831
 2831 DO 2841 J=1,NTOP
        CONFUN(IPT,J+1)=FACTP*PTTBL(NSTRT+J)
 2841   CONTINUE
      DO 2851 J=NT1,NPARM
        CONFUN(IPT,J+1)=FACTQ*PTTBL(NSTRT+J)
 2851   CONTINUE
 2861 RETURN
C
C
 2900 IF(IPT-I2)3000,3000,3700
C
C
C HERE I1 .LT. IPT .LE. I2, SO 1 .LE. II = IPT-I1 .LE. 2*NBOT AND WE
C SET HALF OF A CONSTRAINT OF THE FORM -1.0 .LE. PARAM(.) .LE. 1.0.
 3000 ICNTYP(IPT)=-1
      II=IPT-I1
      IQUOT=(II+1)/2
      NTIQ=NTOP+IQUOT
      IREM=II+1-2*IQUOT
      IF(IREM)3100,3100,3400
C
C HERE II IS ODD AND WE SET THE CONSTRAINT PARAM(NTOP+IQUOT) - 1.0
C .LE. 0.0.
 3100 CONFUN(IPT,1)=PARAM(NTIQ)-ONE
      IF(INDFN)2400,2400,3200
 3200 DO 3300 J=1,NPARM
        CONFUN(IPT,J+1)=ZERO
 3300   CONTINUE
      CONFUN(IPT,NTIQ+1)=ONE
      RETURN
C
C HERE II IS EVEN AND WE SET THE CONSTRAINT -PARAM(NTOP+IQUOT) - 1.0
C .LE. 0.0.
 3400 CONFUN(IPT,1)=-PARAM(NTIQ)-ONE
      IF(INDFN)2400,2400,3500
 3500 DO 3600 J=1,NPARM
        CONFUN(IPT,J+1)=ZERO
 3600   CONTINUE
      CONFUN(IPT,NTIQ+1)=-ONE
      RETURN
C
 3700 IF(IPT-I3)4000,4000,5000
C
C
C HERE I2 .LT. IPT .LE. I3, SO 1 .LE. II = IPT-I2 .LE. NDENO, AND WE SET
C A CONSTRAINT OF THE FORM -Q + EPS .LE. 0.
 4000 ICNTYP(IPT)=-1
      II=IPT-I2
      IF(JOPHUN)4050,4050,4801
C
C HERE WE ARE USING ORDINARY RATIONALS WITH DENOMINATORS OF THE FORM
C
C PARAM(NTOP+1) + PARAM(NTOP+2)*PT +...+ PARAM(NPARM)*PT**(NBOT-1),
C
C WITH PT = PTTBL(3*NPT+II).
C
 4050 PT=PTTBL(3*NPT+II)
      QQ=PARAM(NTOP+1)
      IF(NBOT-1)4300,4300,4100
 4100 DO 4200 J=2,NBOT
        NTJ=NTOP+J
        QQ=QQ+PARAM(NTJ)*PT**(J-1)
 4200   CONTINUE
 4300 CONFUN(IPT,1)=-QQ+EPS
      IF(INDFN)2400,2400,4400
 4400 DO 4500 J=1,NTOP
        CONFUN(IPT,J+1)=ZERO
 4500   CONTINUE
      CONFUN(IPT,NTOP+2)=-ONE
      IF(NBOT-1)2400,2400,4600
 4600 DO 4700 J=2,NBOT
        NTJ=NTOP+J
        CONFUN(IPT,NTJ+1)=PT*CONFUN(IPT,NTJ)
 4700   CONTINUE
      RETURN
C
C HERE WE ARE USING GENERALIZED RATIONALS WITH DENOMINATORS OF THE FORM
C
C PARAM(NTOP+1)*PTTBL(NSTRT+1) +
C PARAM(NTOP+2)*PTTBL(NSTRT+2) +...+
C PARAM(NPARM)*PTTBL(NSTRT+NBOT),
C
C WITH NSTRT = 3*NPT + NDENO + NDER + NPARM*NPT + (II-1)*NBOT.
C
 4801 NSTRT=3*NPT+NDENO+NDER+NPARM*NPT+(II-1)*NBOT
      QQ=ZERO
      DO 4811 J=1,NBOT
        QQ=QQ+PARAM(NTOP+J)*PTTBL(NSTRT+J)
 4811   CONTINUE
      CONFUN(IPT,1)=-QQ+EPS
      IF(INDFN)4851,4851,4821
 4821 DO 4831 J=1,NTOP
        CONFUN(IPT,J+1)=ZERO
 4831   CONTINUE
      DO 4841 J=1,NBOT
        NTJ=NTOP+J
        CONFUN(IPT,NTJ+1)=-PTTBL(NSTRT+J)
 4841   CONTINUE
 4851 RETURN
C
C
C HERE IPT .GT. I3 SO 1 .LE. II = IPT-I3 .LE. NDER AND WE SET A
C CONSTRAINT OF THE FORM RPRIME .GE. ETA, REWRITTEN AS -Q*PPRIME
C + P*QPRIME + ETA*Q**2 .LE. 0.  ACTUALLY, WE ADD TOLCON ON THE
C LEFT, SO WHEN CONMAX REPLACES .LE. 0 BY .LE. TOLCON WE WILL
C HAVE A TRUE .LE. 0 CONSTRAINT.
 5000 ICNTYP(IPT)=-2
      II=IPT-I3
      IF(JOPHUN)5050,5050,6901
C
C HERE WE ARE USING ORDINARY RATIONALS OF THE FORM
C
C (PARAM(1) + PARAM(2)*PT +...+ PARAM(NTOP)*PT**(NTOP-1))/
C (PARAM(NTOP+1) + PARAM(NTOP+2)*PT +...+ PARAM(NPARM)*PT**(NBOT-1)),
C
C WITH PT = PTTBL(3*NPT+II).
C
 5050 PT=PTTBL(3*NPT+II)
      PP=PARAM(1)
      PPPR=ZERO
      IF(NTOP-1)5500,5500,5100
 5100 DO 5200 J=2,NTOP
        PP=PP+PARAM(J)*PT**(J-1)
 5200   CONTINUE
      PPPR=PARAM(2)
      IF(NTOP-2)5500,5500,5300
 5300 DO 5400 J=3,NTOP
        PPPR=PPPR+(J-1)*PARAM(J)*PT**(J-2)
 5400   CONTINUE
 5500 QQ=PARAM(NTOP+1)
      QQPR=ZERO
      IF(NBOT-1)6000,6000,5600
 5600 DO 5700 J=2,NBOT
        NTJ=NTOP+J
        QQ=QQ+PARAM(NTJ)*PT**(J-1)
 5700   CONTINUE
      QQPR=PARAM(NTOP+2)
      IF(NBOT-2)6000,6000,5800
 5800 DO 5900 J=3,NBOT
        NTJ=NTOP+J
        QQPR=QQPR+(J-1)*PARAM(NTJ)*PT**(J-2)
 5900   CONTINUE
 6000 CONFUN(IPT,1)=-QQ*PPPR+PP*QQPR+ETA*QQ*QQ+TOLCON
      IF(INDFN)2400,2400,6100
 6100 CONFUN(IPT,2)=QQPR
      IF(NTOP-1)6500,6500,6200
 6200 CONFUN(IPT,3)=-QQ+QQPR*PT
      IF(NTOP-2)6500,6500,6300
 6300 DO 6400 J=3,NTOP
        CONFUN(IPT,J+1)=-(J-1)*QQ*PT**(J-2)+QQPR*PT**(J-1)
 6400   CONTINUE
 6500 FACT=-PPPR+TWO*ETA*QQ
      CONFUN(IPT,NTOP+2)=FACT
      IF(NBOT-1)2400,2400,6600
 6600 CONFUN(IPT,NTOP+3)=FACT*PT+PP
      IF(NBOT-2)2400,2400,6700
 6700 DO 6800 J=3,NBOT
        NTJ=NTOP+J
        CONFUN(IPT,NTJ+1)=FACT*PT**(J-1)+(J-1)*PP*PT**(J-2)
 6800   CONTINUE
      RETURN
C
C HERE WE ARE USING GENERALIZED RATIONALS OF THE FORM
C
C (PARAM(1)*PTTBL(NSTRT+1) + PARAM(2)*PTTBL(NSTRT+2) +...+
C PARAM(NTOP)*PTTBL(NSTRT+NTOP))/
C (PARAM(NTOP+1)*PTTBL(NSTRT+NTOP+1) +
C PARAM(NTOP+2)*PTTBL(NSTRT+NTOP+2) +...+
C PARAM(NPARM)*PTTBL(NSTRT+NPARM)),
C
C WITH NSTRT = 3*NPT + NDENO + NDER + NPARM*NPT + NBOT*NDENO +
C (II-1)*2*NPARM.
C
C THE DERIVATIVE OF THE NUMERATOR IS
C
C PARAM(1)*PTTBL(KSTRT+1) + PARAM(2)*PTTBL(KSTRT+2) +...+
C PARAM(NTOP)*PTTBL(KSTRT+NTOP),
C
C AND THE DERIVATIVE OF THE DENOMINATOR IS
C
C PARAM(NTOP+1)*PTTBL(KSTRT+NTOP+1) +
C PARAM(NTOP+2)*PTTBL(KSTRT+NTOP+2) +...+
C PARAM(NPARM)*PTTBL(KSTRT+NPARM),
C
C WITH KSTRT = NSTRT + NPARM.
C
 6901 NSTRT=3*NPT+NDENO+NDER+NPARM*NPT+NBOT*NDENO+
     *(II-1)*2*NPARM
      KSTRT=NSTRT+NPARM
      PP=ZERO
      PPPR=ZERO
      DO 6911 J=1,NTOP
        PP=PP+PARAM(J)*PTTBL(NSTRT+J)
        PPPR=PPPR+PARAM(J)*PTTBL(KSTRT+J)
 6911   CONTINUE
      QQ=ZERO
      QQPR=ZERO
      NT1=NTOP+1
      DO 6921 J=NT1,NPARM
        QQ=QQ+PARAM(J)*PTTBL(NSTRT+J)
        QQPR=QQPR+PARAM(J)*PTTBL(KSTRT+J)
 6921   CONTINUE
      CONFUN(IPT,1)=-QQ*PPPR+PP*QQPR+ETA*QQ*QQ+TOLCON
      IF(INDFN)6961,6961,6931
 6931 DO 6941 J=1,NTOP
        CONFUN(IPT,J+1)=-QQ*PTTBL(KSTRT+J)+QQPR*PTTBL(NSTRT+J)
 6941   CONTINUE
      FACT=-PPPR+TWO*ETA*QQ
      DO 6951 J=NT1,NPARM
        CONFUN(IPT,J+1)=FACT*PTTBL(NSTRT+J)+PP*PTTBL(KSTRT+J)
 6951   CONTINUE
 6961 RETURN
C
      END
      SUBROUTINE EVAL(NTOP,NBOT,PARAM,XL,XU,MEVAL,NWRIT)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION PARAM(NTOP+NBOT)
C
C THIS SUBROUTINE COMPUTES VALUES OF Q,  Y = P/Q, AND DY = THE
C CHANGE IN P/Q FOR THE RATIONAL APPROXIMATION P/Q.
C IT ALSO PRINTS THEM ON UNIT NWRIT.
C NOTE THAT IN THIS SUBROUTINE X AND Y ARE POINTS, NOT VECTORS AS
C IN MOST OF THE OTHER SUBPROGRAMS.
C
C SET MACHINE AND PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      FOUR=TWO+TWO
      TEN=FOUR+FOUR+TWO
      SPCMN=D1MACH(3)
      TOLEVL=TEN*SPCMN
C
C SET IGENR=0 AND NEVAL=MEVAL IF MEVAL IS POSITIVE (INDICATING THAT
C WE ARE USING ORDINARY RATIONALS), AND SET IGENR=1 AND NEVAL=-MEVAL
C IF MEVAL IS NEGATIVE (INDICATING GENERALIZED RATIONALS).
C IF MEVAL=0, JUST RETURN.
C NOTE THAT IGENR SHOULD BE THE SAME AS THE HUNDREDS DIGIT OF JOPTN
C IN THE CALLING PROGRAM.
      IGENR=0
      NEVAL=MEVAL
      IF(MEVAL)100,50,200
   50 RETURN
  100 IGENR=1
      NEVAL=-MEVAL
C
C IF THE ABSOLUTE VALUE OF MEVAL IS 1, DO NOT ATTEMPT TO COMPUTE THE
C SPACING, AS THIS WOULD RESULT IN A DIVIDE FAULT.
  200 IF(NEVAL-1)50,600,500
  500 SPAC=(XU-XL)/(NEVAL-1)
  600 NT1=NTOP+1
      NPARM=NTOP+NBOT
      Y0=ZERO
      WRITE(NWRIT,1000)
 1000 FORMAT(/' ABSCISSAS, DENOMINATORS, RATIONAL FUNCTIONS,',
     *' AND DIFFERENCES',
     *//9X,'X',14X,'Q',13X,'P/Q',6X,'CHANGE IN P/Q'/)
      DO 3000 I=1,NEVAL
        X=XL+(I-1)*SPAC
        IF(IGENR)1050,1050,1211
C
C HERE WE ARE USING ORDINARY RATIONALS OF THE FORM
C
C (PARAM(1) + PARAM(2)*X +...+ PARAM(NTOP)*X**(NTOP-1))/
C (PARAM(NTOP+1) + PARAM(NTOP+2)*X +...+ PARAM(NPARM)*X**(NBOT-1)),
C
C WITH X = XL + (I-1)*SPAC.
C
 1050   Q=PARAM(NTOP+1)
        IF(NBOT-1)1300,1300,1100
 1100   DO 1200 J=2,NBOT
          NTJ=NTOP+J
          Q=Q+PARAM(NTJ)*X**(J-1)
 1200     CONTINUE
        GO TO 1300
C
C HERE WE ARE USING GENERALIZED RATIONALS OF THE FORM
C
C (PARAM(1)*BASFN(0,1,X) + PARAM(2)*BASFN(0,2,X) +...+
C PARAM(NTOP)*BASFN(0,NTOP,X))/
C (PARAM(NTOP+1)*BASFN(0,NTOP+1,X) + PARAM(NTOP+2)*BASFN(0,NTOP+2,X)
C +...+ PARAM(NPARM)*BASFN(0,NPARM,X)),
C
C WITH X = XL + (I-1)*SPAC.
C
 1211   Q=ZERO
        DO 1221 J=NT1,NPARM
          Q=Q+PARAM(J)*BASFN(0,J,X)
 1221     CONTINUE
C
C IF Q .LT. TOLEVL WE DO NOT COMPUTE Y OR DY.
 1300   IF(Q-TOLEVL)1400,1500,1500
 1400   WRITE(NWRIT,1450)X,Q
 1450   FORMAT(2D15.6)
        GO TO 3000
C
 1500   IF(IGENR)1550,1550,1711
C
C HERE WE ARE USING ORDINARY RATIONALS.
 1550   P=PARAM(1)
        IF(NTOP-1)1800,1800,1600
 1600   DO 1700 J=2,NTOP
          P=P+PARAM(J)*X**(J-1)
 1700     CONTINUE
        GO TO 1800
C
C HERE WE ARE USING GENERALIZED RATIONALS.
 1711   P=ZERO
        DO 1721 J=1,NTOP
          P=P+PARAM(J)*BASFN(0,J,X)
 1721     CONTINUE
C
 1800   Y=P/Q
        DY=Y-Y0
        Y0=Y
        IF(I-1)1900,1900,2100
 1900   WRITE(NWRIT,2000)X,Q,Y
 2000   FORMAT(3D15.6)
        GO TO 3000
 2100   WRITE(NWRIT,2200)X,Q,Y,DY
 2200   FORMAT(4D15.6)
 3000   CONTINUE
      RETURN
      END
      INTEGER FUNCTION INCHWM(NDEG,COEFF,ALFT,ART,TOL,DERLFT,DERRT,
     *DDERRT)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION COEFF(NDEG+1),DERLFT(NDEG+1),DERRT(NDEG+1),
     *DDERRT(NDEG+1)
C
C GIVEN A POLYNOMIAL P WITH NONNEGATIVE DEGREE AT MOST NDEG AND
C COEFFICIENTS (OF INCREASING POWERS OF THE VARIABLE) IN COEFF,
C THIS SUBPROGRAM SETS INCHWM=1 IF IT CAN GUARANTEE THAT THE
C POLYNOMIAL IS STRICTLY POSITIVE ON THE CLOSED INTERVAL [ALFT,ART],
C AND OTHERWISE IT SETS INCHWM=0.
C
C NORMALLY THE DEGREE OF THE POLYNOMIAL WILL BE NDEG, BUT IT IS
C ACCEPTABLE FOR THE LAST COEFFICIENT(S) IN COEFF TO BE ZERO,
C IN WHICH CASE THE DEGREE WILL BE LESS THAN NDEG.
C
C*****SET THE MAXIMUM NUMBER KSTEP OF NORMAL INCHWORM STEPS WE WILL
C ALLOW BEFORE GIVING UP AND RETURNING WITH INCHWM=0.
C KSTEP MUST BE AT LEAST 1 TO AVOID A DIVIDE FAULT.
C MAKING KSTEP LARGER INCREASES THE PROBABILITY THAT POSITIVITY WILL
C BE DETECTED, BUT POSSIBLY AT THE COST OF COMPUTER TIME.
      KSTEP=100
C*****END OF SETTING KSTEP.
C
C DMIN WILL BE THE MINIMUM MOVEMENT WE WILL ALLOW PER NORMAL
C INCHWORM STEP.
C DMIN WILL NOT CHANGE DURING THIS CALL TO INCHWM.
      DMIN=(ART-ALFT)/KSTEP
C
C IF NDEG IS 0, WE WILL ACCEPT THE POLYNOMIAL AS BEING POSITIVE ON
C THE INTERVAL IFF ITS ONLY COEFFICIENT IS .GE. TOL.  IF NDEG IS 1,
C WE WILL ACCEPT THE POLYNOMIAL AS BEING POSITIVE ON THE INTERVAL
C IFF ITS VALUE IS .GE. TOL AT BOTH ENDPOINTS.
      IF(NDEG-1)100,400,600
  100 IF(COEFF(1)-TOL)200,300,300
C
  200 INCHWM=0
      RETURN
C
  300 INCHWM=1
      RETURN
C
  400 IF(COEFF(1)+COEFF(2)*ALFT-TOL)200,500,500
  500 IF(COEFF(1)+COEFF(2)*ART-TOL)200,300,300
C
C HERE NDEG IS .GE. 2 AND WE CALL DERCOM TO PUT P(ALFT),...,
C P(NDEG)(ALFT)/(NDEG FACTORIAL) IN DERLFT.
  600 CALL DERCOM(NDEG,ALFT,COEFF,DERLFT)
C
C IF P(ALFT) .LT. TOL WE RETURN WITH INCHWM=0.
      IF(DERLFT(1)-TOL)200,700,700
C
C NOW USE ISGNCG WITH ISTRNG=0 TO PUT THE WEAK ZERO COUNT AT ALFT
C IN KNTLFT, WHERE WE TREAT ALL NUMBERS WITH ABSOLUTE VALUE .LT.
C TOL AS ZEROES.
C ACTUALLY, THIS WILL BE AN UPPER BOUND ON THE STRONG ZERO COUNT
C UNDER THE ASSUMPTION THAT NO NUMBERS IN DERLFT ARE IN ERROR BY
C MORE THAN TOL.
  700 KNTLFT=ISGNCG(0,NDEG,DERLFT,TOL)
C
C NOW CALL DERCOM TO PUT P(ART),..., P(NDEG)(ART)/(NDEG FACTORIAL) IN
C DERRT.
      CALL DERCOM(NDEG,ART,COEFF,DERRT)
C
C IF P(ART) .LT. TOL WE RETURN WITH INCHWM=0.
      IF(DERRT(1)-TOL)200,800,800
C
C NOW USE ISGNCG WITH ISTRNG=1 TO PUT THE STRONG ZERO COUNT AT ART
C IN KNTRT, WHERE WE TREAT ALL NUMBERS WITH ABSOLUTE VALUE .LT.
C TOL AS ZEROES.
C ACTUALLY, THIS WILL BE A LOWER BOUND ON THE STRONG ZERO COUNT
C UNDER THE ASSUMPTION THAT NO NUMBERS IN DERRT ARE IN ERROR BY TOL
C OR MORE.
  800 KNTRT=ISGNCG(1,NDEG,DERRT,TOL)
C
C NOW USE THE BUDAN-FOURIER THEOREM, WHICH SAYS THAT THE NUMBER OF
C ZEROES OF P ON (ALFT,ART) IS .LE. KNTLFT-KNTRT.  THUS IF
C KNTLFT-KNTRT .LE. 0, THEN P HAS NO ZEROES ON (ALFT,ART), SO IT
C MUST BE POSITIVE THERE.  THIS IMPLIES THAT P IS POSITIVE ON THE
C CLOSED INTERVAL [ALFT,ART] SINCE WE KNOW IT IS .GE. TOL .GT. 0
C AT THE ENDPOINTS.
      IF(KNTLFT-KNTRT)300,300,900
C
C HERE NDEG .GE. 2 AND BUDAN-FOURIER WAS UNABLE TO PROVE THAT THE
C POLYNOMIAL P WITH DEGREE NDEG AND COEFFICIENTS IN COEFF IS POSITIVE
C ON THE INTERVAL (ALFT,ART).  THUS WE ATTEMPT TO VERIFY POSITIVITY
C USING THE INCHWORM ALGORITHM, WHICH SUCCESSIVELY CONSIDERS THE FIRST
C POSITIVE ZERO (IF ANY) OF A QUADRATIC POLYNOMIAL Q WHICH LIES ON OR
C BELOW THE ORIGINAL POLYNOMIAL P FROM THE CURRENT POINT (SHIFTED TO 0)
C WHERE IT INTERPOLATES P AND ITS FIRST DERIVATIVE TO THE RIGHT END OF
C THE INTERVAL.  SHIFTED P SHOULD BE POSITIVE AT LEAST FROM 0 UP TO
C MIN(THE FIRST POSITIVE ZERO OF Q, LENGTH OF CURRENT INTERVAL), SO
C ORIGINAL P SHOULD BE POSITIVE AT LEAST FROM THE CURRENT POINT UP TO
C THE CURRENT POINT PLUS MIN(THE FIRST POSITIVE ZERO OF Q, LENGTH OF
C CURRENT INTERVAL).
C
C SET THE CURRENT LEFT ENDPOINT BLFT AND THE CURRENT DISTANCE ALONG LEFT
C TO TRAVERSE IN THE INTERVAL.
C HENCEFORTH, WHENEVER BLFT IS RESET, WE WILL HAVE ALREADY SHOWN THAT P
C IS POSITIVE ON [ALFT,BLFT].
  900 BLFT=ALFT
      ALONG=ART-BLFT
C
C USE TCOMP TO COMPUTE THE FIRST (FUDGED) POSITIVE ZERO TSTAR OF
C THE APPROXIMATING QUADRATIC POLYNOMIAL Q.
C P SHOULD BE POSITIVE AT LEAST ON THE INTERVAL [BLFT, BLFT +
C MIN(TSTAR,ALONG)], SO IF TSTAR .GE. ALONG IT SHOULD BE POSITIVE
C ON ALL OF [ALFT,ART].
 1000 TSTAR=TCOMP(NDEG,ALONG,DERLFT,TOL)
      IF(TSTAR-ALONG)1100,300,300
C
C WE HAVE (HOPEFULLY) PROGRESSED DOWN THE INTERVAL [ALFT,ART] FROM BLFT
C TO PT = BLFT+TSTAR.
 1100 PT=BLFT+TSTAR
C
C CALL DERCOM TO PUT P(BLFT+TSTAR),...,P(NDEG)(BLFT+TSTAR)/(NDEG
C FACTORIAL) INTO DERLFT.
      CALL DERCOM(NDEG,PT,COEFF,DERLFT)
C
C IF P(BLFT+TSTAR) .LT. TOL WE GIVE UP.
      IF(DERLFT(1)-TOL)200,1200,1200
C
C HERE P(BLFT+TSTAR) .GE. TOL AND WE CHECK TO SEE IF WE HAVE MADE
C PROGRESS OF AT LEAST DMIN UNITS.
 1200 IF(TSTAR-DMIN)1500,1300,1300
C
C HERE WE MADE AT LEAST DMIN UNITS OF PROGRESS IN THE LAST STEP,
C AND IF BUDAN-FOURIER IS ABLE TO SHOW THAT P IS POSITIVE ON
C (BLFT+TSTAR, ART) WE ARE DONE, WHILE OTHERWISE WE RESET BLFT AND
C ALONG AND DO ANOTHER STEP.
 1300 KNTLFT=ISGNCG(0,NDEG,DERLFT,TOL)
      IF(KNTLFT-KNTRT)300,300,1400
 1400 BLFT=BLFT+TSTAR
      ALONG=ART-BLFT
      GO TO 1000
C
C HERE THE GAIN IN THE LAST STEP WAS SMALLER THAN DMIN.
 1500 IF(DMIN-ALONG)1600,2100,2100
C
C HERE THE GAIN IN THE LAST STEP WAS SMALLER THAN DMIN, AND DMIN IS
C SMALLER THAN THE DISTANCE REMAINING TO GO BEFORE THIS STEP.
C WE SET A TEMPORARY RIGHT ENDPOINT AT BRT = BLFT + DMIN, ADVANCE BLFT
C BY TSTAR, CALL DERCOM TO PUT P(BRT),...,P(NDEG)(BRT)/(NDEG FACTORIAL)
C IN DDERRT, AND CHECK TO MAKE SURE P(BRT) IS .GE. TOL.  IF SO, WE TRY
C TO SHOW P IS POSITIVE ON [(NEW)BLFT,BRT] FIRST BY BUDAN-FOURIER AND (IF
C THAT FAILS) BY COMPUTING A NEW TSTAR FOR THIS INTERVAL.  IF WE ARE ABLE
C TO SHOW THAT P IS POSITIVE ON THIS INTERVAL WE ADVANCE BLFT TO BRT
C AND DO ANOTHER NORMAL INCHWORM STEP, WHILE OTHERWISE WE GIVE UP AND
C RETURN WITH INCHWM=0.
 1600 BRT=BLFT+DMIN
      BLFT=BLFT+TSTAR
      CALL DERCOM(NDEG,BRT,COEFF,DDERRT)
      IF(DDERRT(1)-TOL)200,1700,1700
C
C HERE P(BRT) .GE. TOL AND WE CONTINUE WITH THE PLAN IN THE PARAGRAPH
C ABOVE BY TRYING BUDAN-FOURIER.
 1700 KNTLFT=ISGNCG(0,NDEG,DERLFT,TOL)
      KKNTRT=ISGNCG(1,NDEG,DDERRT,TOL)
      IF(KNTLFT-KKNTRT)1900,1900,1800
C
C HERE BUDAN-FOURIER WAS UNABLE TO PROVE THAT P IS POSITIVE ON (BLFT,BRT),
C SO WE SET BLONG TO THE LENGTH OF THIS INTERVAL AND COMPUTE THE (FUDGED)
C FIRST POSITIVE ZERO TSTAR (IF ANY) OF THE APPROXIMATING QUADRATIC
C POLYNOMIAL Q. IF THIS IS AT LEAST BLONG WE HAVE SUCCEEDED IN MOVING A
C DISTANCE DMIN FROM THE LAST POINT WHERE WE USED THE QUADRATIC
C POLYNOMIAL, AND OTHERWISE WE GIVE UP.
 1800 BLONG=BRT-BLFT
      TSTAR=TCOMP(NDEG,BLONG,DERLFT,TOL)
      IF(TSTAR-BLONG)200,1900,1900
C
C HERE EITHER BUDAN-FOURIER OR THE QUADRATIC POLYNOMIAL SHOWED THAT P IS
C POSITIVE ON [BLFT,BRT], AND WE RESET BLFT TO BRT, RESET DERLFT AND
C ALONG, AND DO ANOTHER NORMAL INCHWORM STEP.
 1900 BLFT=BRT
      NDEG1=NDEG+1
      DO 2000 J=1,NDEG1
        DERLFT(J)=DDERRT(J)
 2000   CONTINUE
      ALONG=ART-BLFT
      GO TO 1000
C
C HERE TSTAR FROM A NORMAL INCHWORM STEP IS .LT. DMIN, BUT ALSO DMIN
C IS .GE. THE DISTANCE REMAINING TO GO BEFORE THIS STEP.  WE TRY
C ONCE MORE, FIRST WITH BUDAN-FOURIER AND THEN WITH THE QUADRATIC
C APPROXIMATING POLYNOMIAL, TO COVER THE REMAINING DISTANCE (WHICH
C IS SMALLER THAN DMIN) TO ART, AND IF WE ARE NOT SUCCESSFUL WE GIVE
C UP.
C IF WE ARE SUCCESSFUL, THEN WE HAVE SHOWN THAT P IS POSITIVE ON THE
C ORIGINAL INTERVAL [ALFT,ART].
 2100 BLFT=BLFT+TSTAR
      ALONG=ART-BLFT
C
C TRY BUDAN-FOURIER.
      KNTLFT=ISGNCG(0,NDEG,DERLFT,TOL)
      IF(KNTLFT-KNTRT)300,300,2200
C
C HERE BUDAN-FOURIER FAILED, AND WE MAKE THE FINAL TRY WITH THE
C APPROXIMATING QUADRATIC POLYNOMIAL.
 2200 TSTAR=TCOMP(NDEG,ALONG,DERLFT,TOL)
      IF(TSTAR-ALONG)200,300,300
      END
      SUBROUTINE DERCOM(NDEG,PT,COEFF,DERVEC)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION COEFF(NDEG+1),DERVEC(NDEG+1)
C
C GIVEN THE NDEG+1 COEFFICIENTS OF A POLYNOMIAL P IN COEFF (IN ORDER OF
C ASCENDING POWERS OF PT), THIS SUBROUTINE PUTS P(PT), PPRIME(PT),
C PDOUBLEPRIME(PT)/2,...,P(NDEG)(PT)/(NDEG FACTORIAL) IN DERVEC(1),...,
C DERVEC(NDEG+1).
C
C NDEG NEGATIVE IS NOT ALLOWED SO WE RETURN IF THIS HAPPENS.
      IF(NDEG)100,200,200
  100 RETURN
C
C COPY COEFF INTO DERVEC.
  200 NDEG1=NDEG+1
      DO 300 J=1,NDEG1
        DERVEC(J)=COEFF(J)
  300   CONTINUE
C
C IF NDEG=0 WE ARE DONE AND WE RETURN.
      IF(NDEG)100,100,400
C
C THE NEXT LOOP DOES THE FOLLOWING.
C FIRST, IT USES SYNTHETIC DIVISION TO DETERMINE A POLYNOMIAL P1
C OF DEGREE (AT MOST) NDEG-1 FOR WHICH
C P(X) = (X-PT)*P1(X) + P(PT).
C P(PT) AND THE COEFFICIENTS OF P1 OVERWRITE DERVEC(1),...,
C DERVEC(NDEG).
C DERVEC(NDEG+1), WHICH IS THE LEADING COEFFICIENT OF ALL THESE
C POLYNOMIALS, DOES NOT NEED TO BE OVERWRITTEN SINCE IT NEVER
C CHANGES.
C IF NDEG .GE. 2, THEN FOR J=2 THE LOOP USES SYNTHETIC DIVISION
C APPLIED TO P1 TO PRODUCE A POLYNOMIAL P2 OF DEGREE (AT MOST)
C NDEG-2 FOR WHICH
C P(X) = (X-PT)*((X-PT)*P2(X) + P1(PT)) + P(PT).
C P1(PT) AND THE COEFFICIENTS OF P2 OVERWRITE DERVEC(2),...,
C DERVEC(NDEG).
C WE HAVE DERVEC(1) = P(PT), AND FROM THE LAST EQUATION WE SEE THAT
C PPRIME(PT) = P1(PT) = DERVEC(2), AND
C PDOUBLEPRIME(PT) = 2*P2(PT),
C SO DERVEC(3) = P2(PT) = PDOUBLEPRIME(PT)/2.
C CHANTING THE MAGIC WORDS "MATHEMATICAL INDUCTION", WE SEE THAT
C AFTER NDEG PASSES THROUGH THE LOOP, DERVEC WILL BE AS CLAIMED AT
C THE BEGINNING OF THIS SUBPROGRAM.
  400 DO 600 J=1,NDEG
C
C NMULT IS THE NUMBER OF MULTIPLICATIONS NEEDED TO DETERMINE THE NEW
C DERVEC(J) BY SYNTHETIC DIVISION, FOR J=1,...,NDEG, AND SO FOR
C NMULT = NDEG,...,1.
C DERVEC(NDEG+1) WILL REMAIN AT COEFF(NDEG+1).
        NMULT=NDEG-J+1
        DO 500 K=1,NMULT
C
C KK RUNS FROM NDEG+1 TO J+1.
          KK=NDEG-K+2
          DERVEC(KK-1)=DERVEC(KK-1)+PT*DERVEC(KK)
  500     CONTINUE
  600   CONTINUE
      RETURN
      END
      INTEGER FUNCTION ISGNCG(ISTRNG,NDEG,VEC,TOL)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION VEC(NDEG+1)
C
C THIS FUNCTION SUBPROGRAM COUNTS SIGN CHANGES IN THE NDEG+1 ELEMENTS OF
C THE VECTOR VEC.  ALL NUMBERS SMALLER THAN TOL IN ABSOLUTE VALUE WILL
C BE TREATED AS ZEROES.  IF NO ELEMENTS OF VEC ARE IN ERROR BY TOL OR
C MORE, THEN WITH ISTRNG=1 WE WILL BE GETTING A LOWER BOUND ON THE ACTUAL
C NUMBER OF STRONG SIGN CHANGES (THAT IS, SIGN CHANGES WITH ZEROES
C IGNORED), WHILE IF ISTRNG=0 WE WILL BE GETTING AN UPPER BOUND ON THE
C ACTUAL NUMBER OF STRONG SIGN CHANGES.
C (A SLIGHTLY STRONGER STATEMENT THAN THAT IN THE PREVIOUS SENTENCE
C HOLDS IN THE ISTRNG=0 CASE, I.E. WE STILL GET THE UPPER BOUND AS
C LONG AS NO ELEMENTS IN VEC ARE IN ERROR BY MORE THAN TOL, SO ERROR
C =TOL IS OK IN THE ISTRNG=0 CASE BUT NOT IN THE ISTRNG=1 CASE.)
C IN THE CASE ISTRNG=1 WE WILL ACTUALLY BE COUNTING THE NUMBER OF STRONG
C SIGN CHANGES IN THE ADJUSTED VECTOR FORMED FROM VEC BY REPLACING
C ELEMENTS SMALLER THAN TOL IN ABSOLUTE VALUE BY ZERO.
C IN THE CASE ISTRNG=0 WE WILL ACTUALLY BE COUNTING THE NUMBER OF WEAK
C SIGN CHANGES (THAT IS, SIGN CHANGES WITH ZEROES TAKEN TO BE POSITIVE OR
C NEGATIVE, WHICHEVER MAXIMIZES THE COUNT) IN THE ADJUSTED VECTOR FORMED
C FROM VEC BY REPLACING ELEMENTS SMALLER THAN TOL IN ABSOLUTE VALUE BY
C ZERO.
C NOTE THAT THIS FUNCTION SUBPROGRAM DOES NOT ACTUALLY CHANGE ANY OF THE
C ELEMENTS OF VEC.
C
C KNT WILL COUNT THE NUMBER OF SIGN CHANGES.
      KNT=0
C
C IF NDEG=0 THERE IS ONLY ONE ELEMENT IN VEC AND WE RETURN WITH ISGNCG=0.
      IF(NDEG)100,100,200
C
  100 ISGNCG=KNT
      RETURN
C
C NOW SET ISIGN, WHICH WILL REPRESENT THE ADJUSTED SIGN OF THE PREVIOUS
C ELEMENT OF VEC.  INITIALLY THIS WILL BE THE FIRST ELEMENT OF VEC.
  200 NDEG1=NDEG+1
      IF(VEC(1)-TOL)400,300,300
  300 ISIGN=1
      GO TO 700
  400 IF(VEC(1)+TOL)500,500,600
  500 ISIGN=-1
      GO TO 700
  600 ISIGN=0
C
  700 IF(ISTRNG)1800,1800,800
C
C HERE ISTRNG=1 SO WE COUNT STRONG SIGN CHANGES IN THE ADJUSTED VECTOR
C VEC.  WE HAVE ALREADY CONSIDERED VEC(1), AND WE NOW LOOP THROUGH THE
C REMAINING NDEG ELEMENTS.
  800 DO 1700 J=2,NDEG1
        IF(ISIGN)1500,1100,900
C
C HERE ISIGN=1.  IF THE NEXT ELEMENT IN VEC IS .GT. -TOL WE LEAVE
C ISIGN AND KNT ALONE, WHILE IF IT IS .LE. -TOL WE INCREMENT KNT AND
C CHANGE ISIGN TO -1.
  900   IF(VEC(J)+TOL)1000,1000,1700
 1000   KNT=KNT+1
        ISIGN=-1
        GO TO 1700
C
C HERE ISIGN=0.  IF THE NEXT ELEMENT OF VEC IS .GE. TOL WE LEAVE KNT
C ALONE AND CHANGE ISIGN TO 1, IF IT IS .LE. -TOL WE LEAVE KNT ALONE
C AND CHANGE ISIGN TO -1, AND OTHERWISE WE LEAVE KNT AND ISIGN ALONE.
C NOTE THAT ONCE ISIGN BECOMES NONZERO IT WILL NEVER BECOME ZERO AGAIN.
 1100   IF(VEC(J)-TOL)1300,1200,1200
 1200   ISIGN=1
        GO TO 1700
 1300   IF(VEC(J)+TOL)1400,1400,1700
 1400   ISIGN=-1
        GO TO 1700
C
C HERE ISIGN=-1.  IF THE NEXT ELEMENT IN VEC IS .LT. TOL WE LEAVE KNT
C AND ISIGN ALONE, WHILE IF IT IS .GE. TOL WE INCREMENT KNT AND CHANGE
C ISIGN TO 1.
 1500   IF(VEC(J)-TOL)1700,1600,1600
 1600   KNT=KNT+1
        ISIGN=1
 1700   CONTINUE
      ISGNCG=KNT
      RETURN
C
C HERE ISTRNG=0 SO WE COUNT WEAK SIGN CHANGES IN THE ADJUSTED VECTOR VEC.
C WE HAVE ALREADY CONSIDERED VEC(1), AND WE NOW LOOP THROUGH THE REMAINING
C NDEG ELEMENTS.
 1800 DO 2700 J=2,NDEG1
        IF(ISIGN)2500,2100,1900
C
C HERE ISIGN=1.  IF THE NEXT ELEMENT IN VEC IS .LT. TOL WE INCREMENT
C KNT AND CHANGE ISIGN TO -1, WHILE IF IT IS .GE. TOL WE LEAVE KNT
C AND ISIGN ALONE.
 1900   IF(VEC(J)-TOL)2000,2700,2700
 2000   KNT=KNT+1
        ISIGN=-1
        GO TO 2700
C
C HERE ISIGN=0.  IF THE NEXT ELEMENT IN VEC IS .GE. TOL WE INCREMENT
C KNT AND CHANGE ISIGN TO 1, IF IT IS .LE. -TOL WE INCREMENT KNT AND
C CNANGE ISIGN TO -1, AND OTHERWISE WE INCREMENT KNT AND LEAVE ISIGN
C ALONE.  NOTE THAT ONCE ISIGN BECOMES NONZERO IT WILL NEVER BECOME ZERO
C AGAIN.
 2100   KNT=KNT+1
        IF(VEC(J)-TOL)2300,2200,2200
 2200   ISIGN=1
        GO TO 2700
 2300   IF(VEC(J)+TOL)2400,2400,2700
 2400   ISIGN=-1
        GO TO 2700
C
C HERE ISIGN=-1.  IF THE NEXT ELEMENT IN VEC IS .GT. -TOL WE INCREMENT
C KNT AND CHANGE ISIGN TO 1, WHILE IF IT IS .LE. -TOL WE LEAVE KNT
C AND ISIGN ALONE.
 2500   IF(VEC(J)+TOL)2700,2700,2600
 2600   KNT=KNT+1
        ISIGN=1
 2700   CONTINUE
      ISGNCG=KNT
      RETURN
      END
      DOUBLE PRECISION FUNCTION TCOMP(NDEG,CLONG,DERVEC,TOL)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z), INTEGER (I-N)
C
      DIMENSION DERVEC(NDEG+1)
C
C THIS FUNCTION SUBPROGRAM COMPUTES THE COEFFICIENTS A, B, C OF THE
C QUADRATIC POLYNOMIAL Q(T) = A*T**2 + B*T + C AND THEN DETERMINES THE
C SMALLEST POSITIVE ZERO OF Q.  IF THIS ZERO DOES NOT EXIST OR WE FIND
C IT TO BE .GE. CLONG+1 WE TAKE TCOMP = CLONG+1 (WHICH IMPLIES THAT
C THERE ARE NO ZEROES IN THE CLOSED INTERVAL [ZERO, CLONG+1]).
C OTHERWISE WE TAKE IT TO BE FUDGE TIMES THE COMPUTED ZERO OF Q, WHERE
C ZERO .LT. FUDGE .LT. 1, WITH THE IDEA BEING TO BACK UP INTO A
C POSITIVITY REGION OF Q.
C WHEN THIS SUBPROGRAM IS USED, C = DERVEC(1) SHOULD BE .GE. TOL .GT. 0,
C NDEG SHOULD BE .GE. 2, CLONG AND TOL SHOULD BE POSITIVE, AND
C DERVEC(J) SHOULD EQUAL P(J-1)(CLFT)/(J-1 FACTORIAL) FOR J=1,...,NDEG+1,
C WHERE CLFT IS THE LEFT ENDPOINT OF THE INTERVAL FOR THE POLYNOMIAL
C P OF DEGREE AT MOST NDEG BEING WORKED ON IN THE CALLING PROGRAM.
C
C SET PRECISION DEPENDENT CONSTANTS.
      ONE=1.0D0
      ZERO=ONE-ONE
      TWO=ONE+ONE
      FOUR=TWO+TWO
      TEN=FOUR+FOUR+TWO
C
      FUDGE=(TEN-ONE)/TEN
C
C IN THE CALLING ROUTINE THE ORIGINAL POLYNOMIAL P IS TO BE CHECKED FOR
C POSITIVITY ON [CLFT, CLFT+CLONG], SO Q, WHICH FORMS A (SHIFTED) LOWER
C BOUND FOR P, IS TO BE CHECKED FOR POSITIVITY ON [0, CLONG].
C WE SET
C C = P(CLFT) = Q(0) .GE. TOL,
C B = PPRIME(CLFT) = QPRIME(0), AND
C A WILL BE .LE. PDOUBLEPRIME(CLFT)/2 (SEE BELOW).
      C=DERVEC(1)
      B=DERVEC(2)
      A=DERVEC(3)/TWO
C
C IF NDEG=2 WE TAKE A = PDOUBLEPRIME(CLFT)/2.
C THIS COMES FROM THE TAYLOR EXPANSION
C
C P(CLFT+T) = P(CLFT) + T*PPRIME(CLFT) +
C (T**2)*(PDOUBLEPRIME(CLFT)/2 + T*P(3)(CLFT)/6 +...+
C (T**(NDEG-2))*P(NDEG)(CLFT)/(NDEG FACTORIAL)).
C
C IF NDEG .GT. 2 WE UNDERESTIMATE THE COEFFICIENT OF T**2 BY REPLACING
C T**J BY 0 IF THE COEFFICIENT OF T**J IS NONNEGATIVE (FOR J=1,...,
C NDEG-2) AND REPLACING T**J BY CLONG**J IF THE COEFFICIENT OF T**J
C IS NEGATIVE.
C THUS Q(T) SHOULD LIE ON OR BELOW P(CLFT+T) FOR ALL T IN [O, CLONG].
C THUS IF Q HAS NO POSITIVE ZEROES THEN P WILL HAVE NO ZEROES ON
C [CLFT, CLFT+CLONG], AND IN THIS CASE WE TAKE TCOMP = CLONG+1,
C WHILE IF Q HAS A (FIRST) POSITIVE ZERO THEN IT WILL BE AT OR LEFT OF
C ANY ZERO OF P(CLFT+T) ON [0,CLONG], AND IN THIS CASE WE TAKE TCOMP
C TO BE SMALLER THAN THE FIRST POSITIVE ZERO OF Q.
C THUS EXCEPT POSSIBLY FOR ROUNDOFF ERROR (WHICH WE TRY TO CONTROL BY
C A CONSERVATIVE STRATEGY BELOW), P SHOULD BE POSITIVE ON
C [CLFT, CLFT + MIN(TCOMP,CLONG)].
      IF(NDEG-2)400,400,100
  100 NDEG1=NDEG+1
      DO 300 J=4,NDEG1
        IF(DERVEC(J))200,300,300
  200   A=A+DERVEC(J)*CLONG**(J-3)
  300   CONTINUE
C
C NOW IF ABS(A) .LT. TOL WE REPLACE A BY -TOL TO AVOID DIVIDING BY
C NUMBERS WITH SMALL ABSOLUTE VALUE OR UNWISELY ASSUMING A TO BE POSITIVE
C WHEN IN FACT THE POSITIVITY IS DUE TO ROUNDOFF ERROR.  NOTE THAT THIS
C CHOICE UNDERESTIMATES A TO BE SAFE.
  400 IF (ABS(A)-TOL)500,600,600
  500 A=-TOL
C
C NOW A CANNOT BE ZERO.  NOTE THAT THE FIRST POSITIVE SOLUTION OF
C A*T**2 + B*T + C = 0, IF IT EXISTS, IS
C (-B - SQRT(B**2 - 4*A*C))/(2*A),
C REGARDLESS OF WHETHER A IS NEGATIVE (SO Q IS CONCAVE DOWN)
C OR A IS POSITIVE (SO Q IS CONCAVE UP).
  600 IF(A)700,700,1100
C
C HERE A IS NEGATIVE (AND IN FACT A .LE. -TOL) SO Q IS CONCAVE DOWN,
C AND B**2 - 4*A*C IS POSITIVE.
C WE NOW USE THE ORDINARY OR RATIONALIZED FORM OF THE QUADRATIC
C FORMULA, ACCORDING AS B IS NONNEGATIVE OR NOT, TO AVOID CANCELLATION
C IN THE TWO-TERM PART OF THE FRACTION.
C NOTE THAT IN THE FORMER CASE THE ABSOLUTE VALUE OF THE DENOMINATOR
C IS -2*A .GE. 2*TOL,
C AND IN THE LATTER CASE THE ABSOLUTE VALUE OF THE DENOMINATOR
C -B + SQRT(B**2 - 4*A*C) IS .GT. SQRT(-4*A*C) .GE. 2*TOL ALSO.
  700 IF(B)900,800,800
  800 TT=(-B-SQRT(B**2-FOUR*A*C))/(TWO*A)
      GO TO 1000
  900 TT=TWO*C/(-B+SQRT(B**2-FOUR*A*C))
C
C AS MENTIONED EARLIER, WE FUDGE A LITTLE TO GET BACK INTO A REGION OF
C POSITIVITY OF Q AND TO TRY TO COVER ANY ROUNDOFF ERRORS THAT HAVE
C OCCURRED.
 1000 TCOMP=FUDGE*TT
      RETURN
C
C HERE A IS POSITIVE (AND IN FACT A .GE. TOL) SO Q IS CONCAVE UP,
C AND IF B .GE. 0 THERE WILL BE NO POSITIVE ZEROES OF Q.
 1100 IF(B)1300,1200,1200
 1200 TCOMP=CLONG+ONE
      RETURN
C
C HERE A IS POSITIVE AND B IS NEGATIVE.
C IF THE COMPUTED VALUE OF THE DISCRIMINANT IS .LE. -TOL WE WILL ASSUME
C THAT ITS TRUE VALUE IS NEGATIVE, SO AGAIN Q WILL HAVE NO POSITIVE
C ZEROES.
C IF ON THE OTHER HAND WE HAVE -TOL .LT. COMPUTED VALUE OF DISCRIMINANT
C .LT. 0 WE WILL TAKE THE DISCRIMINANT TO BE ZERO TO AVOID THE SQUARE
C ROOT OF A NEGATIVE NUMBER.
 1300 DISC=B**2-FOUR*A*C
      IF(DISC+TOL)1200,1200,1400
 1400 IF(DISC)1600,1600,1500
 1500 DEN=-B+SQRT(DISC)
      GO TO 1700
 1600 DEN=-B
C
C IF DEN .LE. 2C/(CLONG+1) THEN TT = 2C/DEN .GE. CLONG+1, SO WE TAKE
C TCOMP = CLONG+1.  OTHERWISE WE COMPUTE TT NORMALLY, KNOWING THAT THE
C DENOMINATOR IS NOT TOO SMALL.
 1700 IF(DEN-TWO*C/(CLONG+ONE))1200,1200,1800
 1800 TT=TWO*C/DEN
      GO TO 1000
      END