function x_turv = turv(U,R,V,p,b)
%  turv --> Solves a least squares problem using the URV decomposition.
%
%  <Synopsis>
%    x_turv = turv(U,R,V,p,b)
%
%  <Description>
%    Solves the near-rank deficient least squares problem
%
%           min_x || b-A*x ||_2
%
%    using the URV decomposition. Here, A = U*R*V' is the URV
%    decomposition of A, p is the numerical rank of A, and the
%    TURV solution is defined by
%
%           x_turv = V(:,1:p)*inv(R(1:p,1:p))*U(:,1:p)'*b.
%
%  <See Also>
%    tulv  --> Solves a least squares problem using the ULV decomposition.
%    trrqr --> Solves a least squares problem using the RRQR decomposition.

%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%    Peter S.K. Hansen, IMM, Technical University of Denmark
%
%    Last revised: June 22, 1999
%-----------------------------------------------------------------------

% Transform right hand side.
beta = U(:,1:p)'*b;

% Back-substitution.
y = R(1:p,1:p)\beta;

% Compute TURV solution.
x_turv = V(:,1:p)*y;

%-----------------------------------------------------------------------
% End of function turv
%-----------------------------------------------------------------------
