function x_tulv = tulv(U,L,V,p,b)
%  tulv --> Solves a least squares problem using the ULV decomposition.
%
%  <Synopsis>
%    x_tulv = tulv(U,L,V,p,b)
%
%  <Description>
%    Solves the near-rank deficient least squares problem
%
%           min_x || b-A*x ||_2
%
%    using the ULV decomposition. Here, A = U*L*V' is the ULV
%    decomposition of A, p is the numerical rank of A, and the
%    TULV solution is defined by
%
%           x_tulv = V(:,1:p)*inv(L(1:p,1:p))*U(:,1:p)'*b.
%
%  <See Also>
%    turv  --> Solves a least squares problem using the URV decomposition.
%    trrqr --> Solves a least squares problem using the RRQR decomposition.

%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%    Peter S.K. Hansen, IMM, Technical University of Denmark
%
%    Last revised: June 22, 1999
%-----------------------------------------------------------------------

% Transform right hand side.
beta = U(:,1:p)'*b;

% Back-substitution.
y = L(1:p,1:p)\beta;

% Compute TULV solution.
x_tulv = V(:,1:p)*y;

%-----------------------------------------------------------------------
% End of function tulv
%-----------------------------------------------------------------------
