function [c,s,r] = gen_giv(a,b)
%  gen_giv --> Determine a 2-by-2 Givens rotation matrix.
%
%  <Synopsis>
%    [c,s,r] = gen_giv(a,b)
%
%  <Description>
%    Compute a Givens rotation to annihilate b using a, i.e.,
%    compute c, s, and r such that
%
%             [ c  s] [a] = [r]   or   [a b] [c  -s] = [r 0]
%             [-s  c] [b]   [0]              [s   c]
%
%  <See Also>
%    app_giv --> Apply a Givens rotation (left/right).

%  <References>
%  [1] G.H. Golub and C.F. Van Loan, "Matrix Computations", Johns Hopkins
%      University Press, 3. Ed., p. 215, (1996).
%
%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%    Peter S.K. Hansen, IMM, Technical University of Denmark
%
%    Last revised: June 22, 1999
%-----------------------------------------------------------------------

if (a == 0)
  c = 0;
  s = 1;
  r = b;
else
  if (abs(a) > abs(b))
    t  = b/a;
    tt = sqrt(1 + t'*t);
    c  = 1/tt;
    s  = c*t;
    r  = a*tt;
  else
    t  = a/b;
    tt = sqrt(1 + t'*t);
    s  = 1/tt;
    c  = s*t;
    r  = b*tt;
  end
end

%-----------------------------------------------------------------------
% End of function gen_giv
%-----------------------------------------------------------------------
