function A = app_hous(A,beta,v)
%  app_hous --> Apply a Householder transformation.
%
%  <Synopsis>
%    A = app_hous(A,beta,v)
%
%  <Description>
%    Applies the Householder transformation, defined by vector v and
%    scalar beta, to the matrix A, i.e., A = (I - beta*v*v')*A.
%
%  <See Also>
%    gen_hous --> Determine a Householder transformation.

%  <References>
%  [1] G.H. Golub and C.F. Van Loan, "Matrix Computations", Johns Hopkins
%      University Press, 3. Ed., p. 211, (1996).
%
%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%    Peter S.K. Hansen, IMM, Technical University of Denmark
%
%    Last revised: June 22, 1999
%-----------------------------------------------------------------------

A = A - (beta*v)*(v'*A);

%-----------------------------------------------------------------------
% End of function app_hous
%-----------------------------------------------------------------------
