function [u1,u2] = app_giv(v1,v2,c,s)
%  app_giv --> Apply a Givens rotation (left/right).
%
%  <Synopsis>
%    [u1,u2] = app_giv(v1,v2,c,s)
%
%  <Description>
%    Apply a Givens rotation, defined by the parameters c and s,
%    from the left to the row vectors v1 and v2 such that
%
%                   [u1] = [ c  s] [v1]
%                   [u2]   [-s  c] [v2]
%
%    or from the right to the column vectors v1 and v2 such that
%
%                [u1 u2] = [v1 v2] [c  -s]
%                                  [s   c]
%
%  <See Also>
%    gen_giv --> Determine a 2-by-2 Givens rotation matrix.

%  <References>
%  [1] G.H. Golub and C.F. Van Loan, "Matrix Computations", Johns Hopkins
%      University Press, 3. Ed., p. 216, (1996).
%
%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%    Peter S.K. Hansen, IMM, Technical University of Denmark
%
%    Last revised: June 22, 1999
%-----------------------------------------------------------------------

u1 = c*v1 + s*v2;
u2 = c*v2 - s*v1;

%-----------------------------------------------------------------------
% End of function app_giv
%-----------------------------------------------------------------------
