% UTV Tools.
% Version 1.1  2-January-05  (fixes bugs in version 1.0)
%
% Demonstration.
%   hulvdemo  - Demonstrates the use of the high-rank ULV algorithms hulv
%               and hulv_a.
%   hurvdemo  - Ditto for the high-rank URV algorithms hurv and hurv_a.
%   lulvdemo  - Demonstrates the use of the low-rank ULV algorithms lulv
%               and lulv_a.
%   lurvdemo  - Ditto for the low-rank URV algorithms lurv and lurv_a.
%   rrqrdemo  - Demonstrates the use of the high- and low-rank RRQR algorithms
%               hrrqr and lrrqr.
%   ullvdemo  - Demonstrates the use of the high-rank ULLV algorithm ullv,
%               and the up- and downdating algorithms ullv_up_a and ullv_dw_a.
%   wulvdemo  - Demonstrates the use of the ULV up- and downdating algorithms,
%               implemented in ulv_win.
%   wurvdemo  - Ditto for the URV up- and downdating algorithms, implemented
%               in urv_win.
%
% UTV-Based Solvers.
%   tulv      - Solves a numerically rank-deficient least squares problem
%               using the rank-revealing ULV decomposition.
%   turv      - Ditto, using the rank-revealing URV decomposition.
%
% High-Rank UTV Algorithms.
%   hulv      - Stewart's rank-revealing ULV algorithm.
%   hulv_a    - The alternative rank-revealing ULV algorithm.
%   hurv      - Stewart's rank-revealing URV algorithm.
%   hurv_a    - The alternative rank-revealing URV algorithm.
%
% Low-Rank UTV Algorithms.
%   lulv      - Warm-started rank-revealing ULV algorithm.
%   lurv      - Warm-started rank-revealing URV algorithm.
%   lulv_a    - Cold-started rank-revealing ULV algorithm.
%   lurv_a    - Cold-started rank-revealing URV algorithm.
%
% Block QR Refinement.
%   ulv_qrit  - Refinement of L in the ULV decomposition.
%   urv_qrit  - Refinement of R in the URV decomposition.
%
% UTV Up- and Downdating.
%   ulv_dw    - Downdate the rank-revealing ULV decomposition.
%   ulv_up    - Update the rank-revealing ULV decomposition.
%   ulv_win   - Sliding window modification of the rank-revealing
%               ULV decomposition.
%   urv_dw    - Downdate the rank-revealing URV decomposition.
%   urv_up    - Update the rank-revealing URV decomposition.
%   urv_win   - Sliding window modification of the rank-revealing
%               URV decomposition.
%
% ULLV Algorithms.
%   ullv      - Compute a high-rank revealing ULLV decomposition.
%   ullv_dw_a - Downdate A in the rank-revealing ULLV decomposition.
%   ullv_dw_b - Downdate B in the rank-revealing ULLV decomposition.
%   ullv_up_a - Update A in the rank-revealing ULLV decomposition.
%   ullv_up_b - Update B in the rank-revealing ULLV decomposition.
%
% RRQR Algorithms.
%   hrrqr     - Chan/Foster high-rank RRQR algorithm.
%   lrrqr     - Chan-Hansen low-rank RRQR algorithm.
%   trrqr     - Solves a numerically rank-deficient least squares problem
%               using the RRQR decomposition.
%
% Misc. Tools.
%   app_giv   - Apply a Givens rotation (from the left or right).
%   app_hous  - Apply a Householder reflection (from the left or right).
%   ccvl      - Estimation of the smallest singular value via
%               Cline-Conn-Van Loan algorithm.
%   gen_giv   - Determine a 2-by-2 Givens rotation matrix.
%   gen_hous  - Determine a Householder reflection matrix.
%   inviter   - Estimation of the smallest singular value via inverse
%               iteration.
%   lanczos   - Estimation of the largest singular value via Lanczos
%               bidiagonalization.
%   mgsr      - Modified Gram-Schmidt with re-orthogonalization
%               (expansion step).
%   powiter   - Estimation of the largest singular value via the power method.
%   ullv_csne - Corrected semi-normal equations expansion step (ULLV).
%   ullv_rdef - Deflate one row of LA in the ULLV decomposition.
%   ullv_ref  - Refine one row of LA in the ULLV decomposition.
%   ulv_cdef  - Deflate one column of L in the ULV decomposition.
%   ulv_csne  - Corrected semi-normal equations expansion step (ULV).
%   ulv_rdef  - Deflate one row of L in the ULV decomposition.
%   ulv_ref   - Refine one row of L in the ULV decomposition.
%   urv_cdef  - Deflate one column of R in the URV decomposition.
%   urv_csne  - Corrected semi-normal equations expansion step (URV).
%   urv_rdef  - Deflate one row of R in the URV decomposition.
%   urv_ref   - Refine one column of R in the URV decomposition.

%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%    Peter S.K. Hansen, IMM, Technical University of Denmark
%
%    Last revised: January 2, 2005
%-----------------------------------------------------------------------
