(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6369,        207]*)
(*NotebookOutlinePosition[      7209,        234]*)
(*  CellTagsIndexPosition[      7165,        230]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testshfvnew",
    FontSize->18],
  " notebook contains the results produced by the package\n    shfv.m \
corresponding to a ",
  StyleBox["new",
    FontSize->18],
  " ",
  StyleBox["example",
    FontSize->18],
  " given by the user.    \n\n :Date: July 1999. \n\n:Available at \
http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
Shohat-Favard's method, regular forms, d-dimensional canonical forms, \n \
d-orthogonal polynomial sequences.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139 - 164."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form \
performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfvnew.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< shohatfavard`shfv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The recurrence coefficients are given in the package \
datashfvnew.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ recurrence\ coefficients\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \n\(d = \); 
    \(imax = \)\ ; \ \ \ \ \ \  (*\ for\ example\ *) \ 
     (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(Do[\ 
      Do[Print["\<gamma[\>", d, "\<,\>", r, "\<,\>", n, "\<]=\>", \n
          \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ gamma[d, r, n]\ ], \ \ \ \ \ \ \ \n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, imax + r - d + 1}]; 
      Print["\<  \>"], \ \n\ \ \ \ \ \ {r, 0, d - 1}]\ \)\)], "Input"],

Cell[BoxData[
    \(\(\ Do[Print["\<beta[\>", d, "\<,\>", n, "\<]=\>", beta[d, n]\ ], 
      \ \ \ \ \ \ \ \n\ \ \ \ \ \ \ \ \ \ {n, 0, imax - 1}]\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The exact expressions of the moments of the d-dimensional form are \
given in the package datashfvnew.m\
\>", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(Timing[\n\t
      Do[Do[Print["\<formexact[\>", d "\<,\>", r, "\<,\>", i, "\<]=\>", \n
            \t\t\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
            formexact[d, r, i]\ ], {i, 0, imax}]; \n\t\t\ \ \ \ \ 
        Print["\<   \>"], {r, 1, d}\ ]\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\)], 
  "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ 
     (*\ for\ example\ *)  (*TO\ FILL\ IN\ BY\ THE\ USER*) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printdcanform[d,nmax,Infinity,$MachinePrecision,True,False]]\
\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the moments of the d-dimensional canonical form  \
performing numerical computations with the machine precision\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package shfv.m, the package datashfvnew.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(\(<< shohatfavard`shfv`; \)\ \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the moments of the d-dimensional form", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printdcanform[d,nmax,$MachinePrecision,$MachinePrecision,\
True,True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{84, Automatic}, {84, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1126, 22, 548, "Subsection"],

Cell[CellGroupData[{
Cell[2860, 75, 143, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3028, 83, 109, 3, 44, "Subsection"],
Cell[3140, 88, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3239, 94, 124, 4, 44, "Subsection"],
Cell[3366, 100, 88, 1, 27, "Input"],
Cell[3457, 103, 191, 3, 43, "Input"],
Cell[3651, 108, 361, 6, 75, "Input"],
Cell[4015, 116, 161, 2, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4213, 123, 133, 3, 44, "Subsection"],
Cell[4349, 128, 189, 3, 43, "Input"],
Cell[4541, 133, 336, 6, 91, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4914, 144, 69, 0, 28, "Subsection"],
Cell[4986, 146, 181, 3, 43, "Input"],
Cell[5170, 151, 46, 1, 27, "Input"],
Cell[5219, 154, 120, 4, 42, "Input"],
Cell[5342, 160, 46, 1, 27, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5437, 167, 174, 4, 48, "Section"],

Cell[CellGroupData[{
Cell[5636, 175, 109, 3, 44, "Subsection"],
Cell[5748, 180, 66, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5851, 186, 69, 0, 28, "Subsection"],
Cell[5923, 188, 189, 3, 43, "Input"],
Cell[6115, 193, 46, 1, 27, "Input"],
Cell[6164, 196, 128, 4, 42, "Input"],
Cell[6295, 202, 46, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

