(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7274,        264]*)
(*NotebookOutlinePosition[      8112,        291]*)
(*  CellTagsIndexPosition[      8068,        287]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchvnew",
    FontSize->18],
  " notebook will contain the results produced by the package\n    chv.m \
corresponding to a ",
  StyleBox["new",
    FontSize->18],
  " ",
  StyleBox["example",
    FontSize->18],
  " given by the user.    \n\n ",
  StyleBox[
  ":Date: July 1999.\n\n :Available at http://netlib.bell-labs.com/ in the  \
numeralgo library in netlib:       \n",
    FontSize->12],
  "\n :Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n \
:Keywords: chebyshev's method, recurrence relations,  orthogonal polynomials \
of dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139-164."
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachvnew.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(\(<< chebyshev`chv`; \)\ \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The moments of the d-dimensional form are given in the package \
datachvnew.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \n\(d = \)\ \ ; 
    \(imax = \)\ \ ; \ \ \ \ \ \  (*\ for\ example\ *) \ 
     (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \)\ ; \ 
    \(nmax = \)\ \ \ \ ; \  (*\ for\ example\ *) \ 
     (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \)\ ; \ 
    \(nmax = \)\ \ ; \ \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \)\ ; \ 
    \(nmax = \)\ ; \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachvnew.m is \
automatically loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`\ ; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \)\ ; \ 
    \(nmax = \)\ ; \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \)\ ; \ 
    \(nmax = \)\ ; \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \n\(d = \); \ 
    \(nmax = \)\ ; \ \ \ \ \ 
     (*\ for\ example\ *)  (*\ TO\ FILL\ IN\ BY\ THE\ USER\ *) \)\)], "Input"],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1165, 25, 530, "Subsection"],

Cell[CellGroupData[{
Cell[2899, 78, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3078, 86, 107, 3, 44, "Subsection"],
Cell[3188, 91, 62, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3287, 97, 133, 4, 28, "Subsection"],
Cell[3423, 103, 71, 1, 27, "Input"],
Cell[3497, 106, 197, 3, 43, "Input"],
Cell[3697, 111, 141, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3875, 118, 54, 0, 28, "Subsection"],
Cell[3932, 120, 191, 3, 43, "Input"],
Cell[4126, 125, 46, 1, 27, "Input"],
Cell[4175, 128, 117, 4, 27, "Input"],
Cell[4295, 134, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4378, 140, 53, 0, 28, "Subsection"],
Cell[4434, 142, 193, 3, 43, "Input"],
Cell[4630, 147, 46, 1, 27, "Input"],
Cell[4679, 150, 116, 4, 27, "Input"],
Cell[4798, 156, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4881, 162, 60, 0, 28, "Subsection"],
Cell[4944, 164, 189, 3, 43, "Input"],
Cell[5136, 169, 46, 1, 27, "Input"],
Cell[5185, 172, 84, 1, 27, "Input"],
Cell[5272, 175, 46, 1, 27, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5367, 182, 187, 5, 48, "Section"],

Cell[CellGroupData[{
Cell[5579, 191, 107, 3, 44, "Subsection"],
Cell[5689, 196, 58, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5784, 202, 54, 0, 28, "Subsection"],
Cell[5841, 204, 189, 3, 43, "Input"],
Cell[6033, 209, 46, 1, 27, "Input"],
Cell[6082, 212, 125, 4, 27, "Input"],
Cell[6210, 218, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6293, 224, 53, 0, 28, "Subsection"],
Cell[6349, 226, 189, 3, 43, "Input"],
Cell[6541, 231, 46, 1, 27, "Input"],
Cell[6590, 234, 124, 4, 27, "Input"],
Cell[6717, 240, 46, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6800, 246, 60, 0, 28, "Subsection"],
Cell[6863, 248, 189, 3, 43, "Input"],
Cell[7055, 253, 46, 1, 27, "Input"],
Cell[7104, 256, 93, 1, 27, "Input"],
Cell[7200, 259, 46, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

