(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    187806,       5409]*)
(*NotebookOutlinePosition[    188646,       5436]*)
(*  CellTagsIndexPosition[    188602,       5432]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv41",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 4.1",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999. \n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 ( 1999 ) 139-164.\n   \n - About the example treated here see \
pp. 82, 103 of:\n   K. Douak, P. Maroni, Les polyn\[OHat]mes orthogonaux \
\"classiques\" de dimension deux, Analysis 12,  71-107 (1992)\n"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv41.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
 The moments of the d-dimensional form are given in the package \
datachv41.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 10; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/7\),
      SequenceForm[ "form[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 20, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]32\/3\),
      SequenceForm[ "form[", 2, ",", 1, ",", 9, "]=", 
        Rational[ 32, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]2\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/3\),
      SequenceForm[ "form[", 2, ",", 2, ",", 7, "]=", 
        Rational[ 20, 3]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/3\),
      SequenceForm[ "form[", 2, ",", 2, ",", 10, "]=", 
        Rational[ 80, 3]],
      Editable->False]], "Print"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(939600\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/21\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 20, 21]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]20\/21\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 20, 21]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]6\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 6, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]14\/15\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 14, 15]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]56\/65\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 56, 65]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]56\/65\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 56, 65]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]12\/13\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 12, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]12\/13\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 12, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/52\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 45, 52]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]45\/52\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 45, 52]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({7.28333333333333143`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(985656\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(987440\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({3.81666666666666287`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(990216\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(992032\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "dorthpoly[", 2, ",", 0, ",", x, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 2, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^2\),
      SequenceForm[ "dorthpoly[", 2, ",", 2, ",", x, "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 1\) + x\^3\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -1, 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 2\)\ x + x\^4\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 
          Times[ -2, x], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - \(20\ x\^2\)\/7\) + 
          x\^5\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ 
          Times[ 
            Rational[ -20, 7], 
            Power[ x, 2]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(20\/21 - \(80\ x\^3\)\/21 + 
          x\^6\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 
          Rational[ 20, 21], 
          Times[ 
            Rational[ -80, 21], 
            Power[ x, 3]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\(8\ x\)\/3 - 
          \(14\ x\^4\)\/3 + x\^7\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ 
          Times[ 
            Rational[ 8, 3], x], 
          Times[ 
            Rational[ -14, 3], 
            Power[ x, 4]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\(16\ x\^2\)\/3 - 
          \(28\ x\^5\)\/5 + x\^8\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 
          Times[ 
            Rational[ 16, 3], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -28, 5], 
            Power[ x, 5]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 32\/39\) + 
          \(112\ x\^3\)\/13 - \(84\ x\^6\)\/13 + x\^9\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ 
          Rational[ -32, 39], 
          Times[ 
            Rational[ 112, 13], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -84, 13], 
            Power[ x, 6]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - \(128\ x\)\/39\) + 
          \(168\ x\^4\)\/13 - \(96\ x\^7\)\/13 + x\^10\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 
          Times[ 
            Rational[ -128, 39], x], 
          Times[ 
            Rational[ 168, 13], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -96, 13], 
            Power[ x, 7]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({1.51666666666666571`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(996824\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv41.m is automaticaly \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 40; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(961088\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, ",", 2, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857295`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 0.85714285714285721],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 3, "]=", 0.8571428571428571],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.9545897701910002`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 3, "]=", 14.954589770191001],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.95238095238095255`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 0.95238095238095255],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.952380952380952372`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 4, "]=", 0.95238095238095233],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.6535597745270207`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 4, "]=", 14.65355977452702],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.85714285714285463`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 0.85714285714285465],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.857142857142857117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 5, "]=", 0.8571428571428571],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.6121670893687962`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 5, "]=", 13.612167089368796],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.933333333333336412`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 0.93333333333333635],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.933333333333333392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 6, "]=", 0.93333333333333335],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.5232260060320141`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 6, "]=", 13.523226006032015],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.861538461538486188`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 0.86153846153848623],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.861538461538461675`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 7, "]=", 0.86153846153846159],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.6082367957403618`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 7, "]=", 12.608236795740362],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.923076923076824762`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 0.92307692307682476],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.923076923076923172`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 8, "]=", 0.92307692307692313],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.0071560483039507`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 8, "]=", 12.007156048303951],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.865384615384684252`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 0.86538461538468425],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.865384615384615329`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 9, "]=", 0.86538461538461542],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.1621980806927476`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 9, "]=", 12.162198080692749],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.916666666667215856`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 10, "]=", 0.91666666666721586],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.916666666666666607`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 10, "]=", 0.91666666666666663],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2602478598268218`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 10, "]=", 11.260247859826821],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.86842105262954039`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 11, "]=", 0.86842105262954039],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.868421052631578938`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 11, "]=", 0.86842105263157898],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.6906697871352296`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 11, "]=", 10.69066978713523],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.912280701755588374`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 12, "]=", 0.9122807017555884],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.912280701754385958`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 12, "]=", 0.91228070175438591],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.9199212143567624`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 12, "]=", 10.919921214356762],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.870813397139657929`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 13, "]=", 0.87081339713965789],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.870813397129186661`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 13, "]=", 0.87081339712918659],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.97999979176137408`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 13, "]=", 9.9799997917613741],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.909090909064881458`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 14, "]=", 0.90909090906488144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.909090909090908994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 14, "]=", 0.90909090909090906],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.58456546744877968`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 14, "]=", 9.5845654674487797],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.872727272725342828`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 15, "]=", 0.87272727272534278],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.872727272727272662`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 15, "]=", 0.87272727272727268],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.7144650400224383`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 15, "]=", 10.714465040022437],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.906666666728805203`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 16, "]=", 0.90666666672880525],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.906666666666666642`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 16, "]=", 0.90666666666666662],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "16", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.2066383430093186`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 16, "]=", 9.2066383430093186],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.874285714352968312`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 17, "]=", 0.87428571435296831],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.874285714285714377`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 17, "]=", 0.87428571428571433],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "17", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.17228200855149466`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 17, "]=", 9.1722820085514947],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.904761904898416879`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 18, "]=", 0.9047619048984169],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.904761904761904744`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 18, "]=", 0.90476190476190477],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "18", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.86482874130695641`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 18, "]=", 8.8648287413069564],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.875576032340953958`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 19, "]=", 0.87557603234095405],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.87557603686635943`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 19, "]=", 0.87557603686635943],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "19", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["7.34434251081367506`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 19, "]=", 7.3443425108136751],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.903225817704837297`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 20, "]=", 0.90322581770483734],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.903225806451612811`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 20, "]=", 0.90322580645161288],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "20", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.94872301835208006`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 20, "]=", 6.9487230183520801],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.876660367832467457`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 21, "]=", 0.87666036783246748],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.876660341555977318`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 21, "]=", 0.87666034155597727],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "21", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.58043264466766864`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 21, "]=", 6.5804326446676686],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.901960610329972567`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 22, "]=", 0.90196061032997255],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.901960784313725483`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 22, "]=", 0.90196078431372551],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "22", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.7594913053333947`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 22, "]=", 5.7594913053333947],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.877583660480657279`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 23, "]=", 0.87758366048065728],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.877583465818759833`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 23, "]=", 0.8775834658187599],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "23", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.71071904785018258`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 23, "]=", 5.7107190478501826],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.900901731688339424`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 24, "]=", 0.90090173168833942],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.900900900900900936`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 24, "]=", 0.90090090090090091],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "24", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.08051007861119696`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 24, "]=", 5.080510078611197],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.878374958891836676`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 25, "]=", 0.8783749588918367],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.878378378378378421`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 25, "]=", 0.8783783783783784],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "25", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.46603910120914537`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 25, "]=", 4.4660391012091454],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.900003544734634886`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 26, "]=", 0.90000354473463495],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.9`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 26, "]=", 0.90000000000000002],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "26", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.45041627131281103`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 26, "]=", 4.450416271312811],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879082176664305947`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 27, "]=", 0.87908217666430588],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879069767441860427`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 27, "]=", 0.87906976744186049],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "27", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.90625543028672339`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 27, "]=", 3.9062554302867234],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.899156266484974864`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 28, "]=", 0.89915626648497493],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.899224806201550386`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 28, "]=", 0.89922480620155043],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "28", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.16405769579105022`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 28, "]=", 3.1640576957910502],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879834130213145115`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 29, "]=", 0.87983413021314505],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.879676440849342888`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 29, "]=", 0.87967644084934282],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "29", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.80219759898423816`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 29, "]=", 2.8021975989842383],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.898640937776676373`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 30, "]=", 0.89864093777667631],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.898550724637681241`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 30, "]=", 0.89855072463768115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "30", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.04473020550088602`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 30, "]=", 3.044730205500886],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.878276989199506097`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 31, "]=", 0.87827698919950614],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.880212954747116249`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 31, "]=", 0.88021295474711625],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "31", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.71310237565156775`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 31, "]=", 1.7131023756515678],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.902958994436614226`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 32, "]=", 0.9029589944366142],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.897959183673469318`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 32, "]=", 0.89795918367346939],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "32", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.30104643287943089`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 32, "]=", 1.3010464328794309],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.882037901878384644`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 33, "]=", 0.88203790187838471],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.880690737833594994`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 33, "]=", 0.88069073783359497],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "33", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.87057951681665723`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 33, "]=", 1.8705795168166572],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.861630292870368563`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 34, "]=", 0.86163029287036852],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.897435897435897445`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 34, "]=", 0.89743589743589747],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "34", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.44604898896014351`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 34, "]=", 0.44604898896014356],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.9714340956792606`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 35, "]=", 0.97143409567926065],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881118881118881169`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 35, "]=", 0.88111888111888115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "35", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.0442390819896407716`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 35, "]=", 0.044239081989640772],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.776343371500081147`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 36, "]=", 0.77634337150008115],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.896969696969696883`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 36, "]=", 0.89696969696969697],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "36", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0814420985050298185`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 36, "]=", -0.081442098505029814],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.92837771238207658`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 37, "]=", 0.92837771238207667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.881504702194357392`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 37, "]=", 0.88150470219435739],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "37", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.329077155164718915`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 37, "]=", 0.32907715516471892],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.71956906658499608`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 38, "]=", 2.7195690665849961],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.89655172413793096`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 38, "]=", 0.89655172413793105],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "38", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.260790800137827627`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 38, "]=", -0.26079080013782763],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["9.29527653866803404`",
            StyleBoxAutoDelete->True,
            PrintPrecision->16]}]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 39, "]=", -9.295276538668034],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.88185415488976826`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 39, "]=", 0.88185415488976826],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "39", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.0076253517136815`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 39, "]=", -1.0076253517136815],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]40
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, ",", 40, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({41.2500000000000177`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1402672\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 40\ ; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1404456\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 1, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 2, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 3, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 4, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 5, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 6, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 7, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 8, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 9, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 10, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]11
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 11, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]12
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 12, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]13
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 13, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]14
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 14, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]15
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 15, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]16
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 16, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]17
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 17, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]18
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 18, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]19
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 19, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]20
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 20, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]21
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 21, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]22
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 22, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]23
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 23, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]24
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 24, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]25
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 25, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]26
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 26, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]27
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 27, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]28
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 28, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]29
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 29, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]30
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 30, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]31
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 31, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]32
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 32, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]33
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 33, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]34
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 34, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]35
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 35, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]36
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 36, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]37
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 37, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]38
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 38, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "beta[", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "betaexact[", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("abserror["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]39
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "abserror[", 2, ",", 39, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({19.9000000000000056`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1409552\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 15; 
    \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1411336\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 2, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\),
      SequenceForm[ "dorthpoly[", 2, ",", 1, ",", x, "]=", x],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]x\^2\),
      SequenceForm[ "dorthpoly[", 2, ",", 2, ",", x, "]=", 
        Power[ x, 2]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", \(x\^3\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -1.0, 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["2.`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", "x"}], "+", \(x\^4\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 
          Times[ -2.0, x], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["2.85714285714285729`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^2\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ 
          Times[ -2.8571428571428572, 
            Power[ x, 2]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.95238095238095255`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["3.80952380952380984`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 0.95238095238095255, 
          Times[ -3.8095238095238098, 
            Power[ x, 3]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["2.66666666666666163`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["4.66666666666666429`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ 
          Times[ 2.6666666666666616, x], 
          Times[ -4.6666666666666643, 
            Power[ x, 4]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["5.33333333333333747`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["5.60000000000000053`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 
          Times[ 5.3333333333333375, 
            Power[ x, 2]], 
          Times[ -5.6000000000000005, 
            Power[ x, 5]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.820512820512844065`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["8.61538461538471445`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["6.46153846153848654`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ -0.82051282051284413, 
          Times[ 8.6153846153847145, 
            Power[ x, 3]], 
          Times[ -6.4615384615384865, 
            Power[ x, 6]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["3.28205128205103902`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", "x"}], "+", 
          RowBox[{
            StyleBox["12.9230769230765618`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["7.3846153846153113`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 
          Times[ -3.282051282051039, x], 
          Times[ 12.923076923076561, 
            Power[ x, 4]], 
          Times[ -7.3846153846153113, 
            Power[ x, 7]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["7.89743589743602569`",
                StyleBoxAutoDelete->True,
                PrintPrecision->16]}], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["17.7692307692307949`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["8.24999999999999644`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 11, ",", x, "]=", 
        Plus[ 
          Times[ -7.8974358974360257, 
            Power[ x, 2]], 
          Times[ 17.769230769230795, 
            Power[ x, 5]], 
          Times[ -8.2499999999999964, 
            Power[ x, 8]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["0.752136752137224462`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["15.7948717948767436`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["23.6923076923112896`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["9.16666666666721141`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 12, ",", x, "]=", 
        Plus[ 0.75213675213722442, 
          Times[ -15.794871794876745, 
            Power[ x, 3]], 
          Times[ 23.692307692311289, 
            Power[ x, 6]], 
          Times[ -9.1666666666672114, 
            Power[ x, 9]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["3.60233918128012042`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["27.0175438596274153`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["30.105263157883213`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["10.0350877192967513`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 13, ",", x, "]=", 
        Plus[ 
          Times[ 3.6023391812801204, x], 
          Times[ -27.017543859627416, 
            Power[ x, 4]], 
          Times[ 30.105263157883215, 
            Power[ x, 7]], 
          Times[ -10.035087719296751, 
            Power[ x, 10]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["10.8070175438628336`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["43.2280701754382779`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["37.6315789473668171`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["10.9473684210523391`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 14, ",", x, "]=", 
        Plus[ 
          Times[ 10.807017543862834, 
            Power[ x, 2]], 
          Times[ -43.228070175438276, 
            Power[ x, 5]], 
          Times[ 37.631578947366819, 
            Power[ x, 8]], 
          Times[ -10.947368421052339, 
            Power[ x, 11]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["0.654970760242205241`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["24.561403508944819`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["63.8596491230579221`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["45.6140350878141553`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["11.8181818181919972`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 15, ",", x, "]=", 
        Plus[ -0.65497076024220524, 
          Times[ 24.561403508944817, 
            Power[ x, 3]], 
          Times[ -63.85964912305792, 
            Power[ x, 6]], 
          Times[ 45.614035087814159, 
            Power[ x, 9]], 
          Times[ -11.818181818191997, 
            Power[ x, 12]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.68333333333333712`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1418384\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{590, 412},
WindowMargins->{{Automatic, 87}, {Automatic, 66}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000`d26_oQon@3:`8g0dL5N`?P0080001804P000000]P2:001
0000I00000400`<30?l00BL?00400@0000000000000006P801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1279, 21, 628, "Subsection"],

Cell[CellGroupData[{
Cell[3013, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3192, 82, 106, 3, 44, "Subsection"],
Cell[3301, 87, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3394, 93, 133, 4, 44, "Subsection"],
Cell[3530, 99, 71, 1, 27, "Input"],
Cell[3604, 102, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3771, 108, 141, 2, 43, "Input"],
Cell[3915, 112, 298, 6, 22, "Print"],
Cell[4216, 120, 298, 6, 22, "Print"],
Cell[4517, 128, 298, 6, 22, "Print"],
Cell[4818, 136, 298, 6, 22, "Print"],
Cell[5119, 144, 298, 6, 22, "Print"],
Cell[5420, 152, 298, 6, 22, "Print"],
Cell[5721, 160, 326, 7, 38, "Print"],
Cell[6050, 169, 298, 6, 22, "Print"],
Cell[6351, 177, 298, 6, 22, "Print"],
Cell[6652, 185, 326, 7, 38, "Print"],
Cell[6981, 194, 300, 6, 22, "Print"],
Cell[7284, 202, 298, 6, 22, "Print"],
Cell[7585, 210, 298, 6, 22, "Print"],
Cell[7886, 218, 298, 6, 22, "Print"],
Cell[8187, 226, 298, 6, 22, "Print"],
Cell[8488, 234, 298, 6, 22, "Print"],
Cell[8789, 242, 298, 6, 22, "Print"],
Cell[9090, 250, 298, 6, 22, "Print"],
Cell[9391, 258, 326, 7, 38, "Print"],
Cell[9720, 267, 298, 6, 22, "Print"],
Cell[10021, 275, 298, 6, 22, "Print"],
Cell[10322, 283, 328, 7, 38, "Print"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10699, 296, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[10778, 300, 142, 2, 43, "Input"],
Cell[10923, 304, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11135, 312, 46, 1, 27, "Input"],
Cell[11184, 315, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11261, 321, 117, 4, 42, "Input"],
Cell[11381, 327, 38, 1, 22, "Print"],
Cell[11422, 330, 300, 6, 22, "Print"],
Cell[11725, 338, 310, 6, 22, "Print"],
Cell[12038, 346, 37, 1, 22, "Print"],
Cell[12078, 349, 300, 6, 22, "Print"],
Cell[12381, 357, 310, 6, 22, "Print"],
Cell[12694, 365, 37, 1, 22, "Print"],
Cell[12734, 368, 326, 7, 38, "Print"],
Cell[13063, 377, 336, 7, 38, "Print"],
Cell[13402, 386, 37, 1, 22, "Print"],
Cell[13442, 389, 330, 7, 38, "Print"],
Cell[13775, 398, 340, 7, 38, "Print"],
Cell[14118, 407, 37, 1, 22, "Print"],
Cell[14158, 410, 326, 7, 38, "Print"],
Cell[14487, 419, 336, 7, 38, "Print"],
Cell[14826, 428, 37, 1, 22, "Print"],
Cell[14866, 431, 330, 7, 38, "Print"],
Cell[15199, 440, 340, 7, 38, "Print"],
Cell[15542, 449, 37, 1, 22, "Print"],
Cell[15582, 452, 330, 7, 38, "Print"],
Cell[15915, 461, 340, 7, 38, "Print"],
Cell[16258, 470, 37, 1, 22, "Print"],
Cell[16298, 473, 330, 7, 38, "Print"],
Cell[16631, 482, 340, 7, 38, "Print"],
Cell[16974, 491, 37, 1, 22, "Print"],
Cell[17014, 494, 330, 7, 38, "Print"],
Cell[17347, 503, 340, 7, 38, "Print"],
Cell[17690, 512, 37, 1, 22, "Print"],
Cell[17730, 515, 38, 1, 22, "Print"],
Cell[17771, 518, 300, 6, 22, "Print"],
Cell[18074, 526, 310, 6, 22, "Print"],
Cell[18387, 534, 37, 1, 22, "Print"],
Cell[18427, 537, 300, 6, 22, "Print"],
Cell[18730, 545, 310, 6, 22, "Print"],
Cell[19043, 553, 37, 1, 22, "Print"],
Cell[19083, 556, 300, 6, 22, "Print"],
Cell[19386, 564, 310, 6, 22, "Print"],
Cell[19699, 572, 37, 1, 22, "Print"],
Cell[19739, 575, 300, 6, 22, "Print"],
Cell[20042, 583, 310, 6, 22, "Print"],
Cell[20355, 591, 37, 1, 22, "Print"],
Cell[20395, 594, 300, 6, 22, "Print"],
Cell[20698, 602, 310, 6, 22, "Print"],
Cell[21011, 610, 37, 1, 22, "Print"],
Cell[21051, 613, 300, 6, 22, "Print"],
Cell[21354, 621, 310, 6, 22, "Print"],
Cell[21667, 629, 37, 1, 22, "Print"],
Cell[21707, 632, 300, 6, 22, "Print"],
Cell[22010, 640, 310, 6, 22, "Print"],
Cell[22323, 648, 37, 1, 22, "Print"],
Cell[22363, 651, 300, 6, 22, "Print"],
Cell[22666, 659, 310, 6, 22, "Print"],
Cell[22979, 667, 37, 1, 22, "Print"],
Cell[23019, 670, 300, 6, 22, "Print"],
Cell[23322, 678, 310, 6, 22, "Print"],
Cell[23635, 686, 37, 1, 22, "Print"],
Cell[23675, 689, 302, 6, 22, "Print"],
Cell[23980, 697, 312, 6, 22, "Print"],
Cell[24295, 705, 37, 1, 22, "Print"],
Cell[24335, 708, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24442, 714, 46, 1, 27, "Input"],
Cell[24491, 717, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[24580, 724, 53, 0, 28, "Subsection"],
Cell[24636, 726, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[24803, 732, 46, 1, 27, "Input"],
Cell[24852, 735, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24929, 741, 116, 4, 42, "Input"],
Cell[25048, 747, 243, 5, 22, "Print"],
Cell[25294, 754, 253, 5, 22, "Print"],
Cell[25550, 761, 37, 1, 22, "Print"],
Cell[25590, 764, 243, 5, 22, "Print"],
Cell[25836, 771, 253, 5, 22, "Print"],
Cell[26092, 778, 37, 1, 22, "Print"],
Cell[26132, 781, 243, 5, 22, "Print"],
Cell[26378, 788, 253, 5, 22, "Print"],
Cell[26634, 795, 37, 1, 22, "Print"],
Cell[26674, 798, 243, 5, 22, "Print"],
Cell[26920, 805, 253, 5, 22, "Print"],
Cell[27176, 812, 37, 1, 22, "Print"],
Cell[27216, 815, 243, 5, 22, "Print"],
Cell[27462, 822, 253, 5, 22, "Print"],
Cell[27718, 829, 37, 1, 22, "Print"],
Cell[27758, 832, 243, 5, 22, "Print"],
Cell[28004, 839, 253, 5, 22, "Print"],
Cell[28260, 846, 37, 1, 22, "Print"],
Cell[28300, 849, 243, 5, 22, "Print"],
Cell[28546, 856, 253, 5, 22, "Print"],
Cell[28802, 863, 37, 1, 22, "Print"],
Cell[28842, 866, 243, 5, 22, "Print"],
Cell[29088, 873, 253, 5, 22, "Print"],
Cell[29344, 880, 37, 1, 22, "Print"],
Cell[29384, 883, 243, 5, 22, "Print"],
Cell[29630, 890, 253, 5, 22, "Print"],
Cell[29886, 897, 37, 1, 22, "Print"],
Cell[29926, 900, 243, 5, 22, "Print"],
Cell[30172, 907, 253, 5, 22, "Print"],
Cell[30428, 914, 37, 1, 22, "Print"],
Cell[30468, 917, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30575, 923, 46, 1, 27, "Input"],
Cell[30624, 926, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[30713, 933, 60, 0, 28, "Subsection"],
Cell[30776, 935, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[30943, 941, 46, 1, 27, "Input"],
Cell[30992, 944, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31069, 950, 84, 1, 27, "Input"],
Cell[31156, 953, 308, 6, 22, "Print"],
Cell[31467, 961, 308, 6, 22, "Print"],
Cell[31778, 969, 331, 7, 24, "Print"],
Cell[32112, 978, 368, 8, 24, "Print"],
Cell[32483, 988, 393, 9, 24, "Print"],
Cell[32879, 999, 467, 12, 40, "Print"],
Cell[33349, 1013, 501, 13, 40, "Print"],
Cell[33853, 1028, 526, 14, 40, "Print"],
Cell[34382, 1044, 555, 15, 40, "Print"],
Cell[34940, 1061, 608, 16, 40, "Print"],
Cell[35551, 1079, 645, 17, 40, "Print"],
Cell[36199, 1098, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36306, 1104, 46, 1, 27, "Input"],
Cell[36355, 1107, 40, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[36456, 1115, 187, 5, 66, "Section"],

Cell[CellGroupData[{
Cell[36668, 1124, 105, 3, 44, "Subsection"],
Cell[36776, 1129, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36869, 1135, 54, 0, 44, "Subsection"],
Cell[36926, 1137, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[37093, 1143, 46, 1, 27, "Input"],
Cell[37142, 1146, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37219, 1152, 125, 4, 42, "Input"],
Cell[37347, 1158, 38, 1, 22, "Print"],
Cell[37388, 1161, 477, 11, 22, "Print"],
Cell[37868, 1174, 487, 11, 22, "Print"],
Cell[38358, 1187, 498, 11, 22, "Print"],
Cell[38859, 1200, 37, 1, 22, "Print"],
Cell[38899, 1203, 477, 11, 22, "Print"],
Cell[39379, 1216, 487, 11, 22, "Print"],
Cell[39869, 1229, 498, 11, 22, "Print"],
Cell[40370, 1242, 37, 1, 22, "Print"],
Cell[40410, 1245, 511, 11, 22, "Print"],
Cell[40924, 1258, 527, 12, 22, "Print"],
Cell[41454, 1272, 527, 12, 22, "Print"],
Cell[41984, 1286, 37, 1, 22, "Print"],
Cell[42024, 1289, 510, 11, 22, "Print"],
Cell[42537, 1302, 528, 12, 22, "Print"],
Cell[43068, 1316, 526, 12, 22, "Print"],
Cell[43597, 1330, 37, 1, 22, "Print"],
Cell[43637, 1333, 510, 11, 22, "Print"],
Cell[44150, 1346, 527, 12, 22, "Print"],
Cell[44680, 1360, 527, 12, 22, "Print"],
Cell[45210, 1374, 37, 1, 22, "Print"],
Cell[45250, 1377, 511, 11, 22, "Print"],
Cell[45764, 1390, 528, 12, 22, "Print"],
Cell[46295, 1404, 527, 12, 22, "Print"],
Cell[46825, 1418, 37, 1, 22, "Print"],
Cell[46865, 1421, 511, 11, 22, "Print"],
Cell[47379, 1434, 528, 12, 22, "Print"],
Cell[47910, 1448, 527, 12, 22, "Print"],
Cell[48440, 1462, 37, 1, 22, "Print"],
Cell[48480, 1465, 511, 11, 22, "Print"],
Cell[48994, 1478, 528, 12, 22, "Print"],
Cell[49525, 1492, 527, 12, 22, "Print"],
Cell[50055, 1506, 37, 1, 22, "Print"],
Cell[50095, 1509, 511, 11, 22, "Print"],
Cell[50609, 1522, 528, 12, 22, "Print"],
Cell[51140, 1536, 527, 12, 22, "Print"],
Cell[51670, 1550, 37, 1, 22, "Print"],
Cell[51710, 1553, 513, 11, 22, "Print"],
Cell[52226, 1566, 530, 12, 22, "Print"],
Cell[52759, 1580, 529, 12, 22, "Print"],
Cell[53291, 1594, 37, 1, 22, "Print"],
Cell[53331, 1597, 512, 11, 22, "Print"],
Cell[53846, 1610, 530, 12, 22, "Print"],
Cell[54379, 1624, 528, 12, 22, "Print"],
Cell[54910, 1638, 37, 1, 22, "Print"],
Cell[54950, 1641, 512, 11, 22, "Print"],
Cell[55465, 1654, 530, 12, 22, "Print"],
Cell[55998, 1668, 529, 12, 22, "Print"],
Cell[56530, 1682, 37, 1, 22, "Print"],
Cell[56570, 1685, 513, 11, 22, "Print"],
Cell[57086, 1698, 530, 12, 22, "Print"],
Cell[57619, 1712, 529, 12, 22, "Print"],
Cell[58151, 1726, 37, 1, 22, "Print"],
Cell[58191, 1729, 513, 11, 22, "Print"],
Cell[58707, 1742, 530, 12, 22, "Print"],
Cell[59240, 1756, 529, 12, 22, "Print"],
Cell[59772, 1770, 37, 1, 22, "Print"],
Cell[59812, 1773, 513, 11, 22, "Print"],
Cell[60328, 1786, 530, 12, 22, "Print"],
Cell[60861, 1800, 529, 12, 22, "Print"],
Cell[61393, 1814, 37, 1, 22, "Print"],
Cell[61433, 1817, 513, 11, 22, "Print"],
Cell[61949, 1830, 530, 12, 22, "Print"],
Cell[62482, 1844, 528, 12, 22, "Print"],
Cell[63013, 1858, 37, 1, 22, "Print"],
Cell[63053, 1861, 513, 11, 22, "Print"],
Cell[63569, 1874, 530, 12, 22, "Print"],
Cell[64102, 1888, 529, 12, 22, "Print"],
Cell[64634, 1902, 37, 1, 22, "Print"],
Cell[64674, 1905, 512, 11, 22, "Print"],
Cell[65189, 1918, 530, 12, 22, "Print"],
Cell[65722, 1932, 529, 12, 22, "Print"],
Cell[66254, 1946, 37, 1, 22, "Print"],
Cell[66294, 1949, 513, 11, 22, "Print"],
Cell[66810, 1962, 529, 12, 22, "Print"],
Cell[67342, 1976, 529, 12, 22, "Print"],
Cell[67874, 1990, 37, 1, 22, "Print"],
Cell[67914, 1993, 513, 11, 22, "Print"],
Cell[68430, 2006, 530, 12, 22, "Print"],
Cell[68963, 2020, 529, 12, 22, "Print"],
Cell[69495, 2034, 37, 1, 22, "Print"],
Cell[69535, 2037, 513, 11, 22, "Print"],
Cell[70051, 2050, 530, 12, 22, "Print"],
Cell[70584, 2064, 529, 12, 22, "Print"],
Cell[71116, 2078, 37, 1, 22, "Print"],
Cell[71156, 2081, 513, 11, 22, "Print"],
Cell[71672, 2094, 530, 12, 22, "Print"],
Cell[72205, 2108, 528, 12, 22, "Print"],
Cell[72736, 2122, 37, 1, 22, "Print"],
Cell[72776, 2125, 513, 11, 22, "Print"],
Cell[73292, 2138, 529, 12, 22, "Print"],
Cell[73824, 2152, 529, 12, 22, "Print"],
Cell[74356, 2166, 37, 1, 22, "Print"],
Cell[74396, 2169, 513, 11, 22, "Print"],
Cell[74912, 2182, 530, 12, 22, "Print"],
Cell[75445, 2196, 528, 12, 22, "Print"],
Cell[75976, 2210, 37, 1, 22, "Print"],
Cell[76016, 2213, 512, 11, 22, "Print"],
Cell[76531, 2226, 529, 12, 22, "Print"],
Cell[77063, 2240, 529, 12, 22, "Print"],
Cell[77595, 2254, 37, 1, 22, "Print"],
Cell[77635, 2257, 513, 11, 22, "Print"],
Cell[78151, 2270, 513, 12, 22, "Print"],
Cell[78667, 2284, 528, 12, 22, "Print"],
Cell[79198, 2298, 37, 1, 22, "Print"],
Cell[79238, 2301, 513, 11, 22, "Print"],
Cell[79754, 2314, 530, 12, 22, "Print"],
Cell[80287, 2328, 529, 12, 22, "Print"],
Cell[80819, 2342, 37, 1, 22, "Print"],
Cell[80859, 2345, 513, 11, 22, "Print"],
Cell[81375, 2358, 530, 12, 22, "Print"],
Cell[81908, 2372, 529, 12, 22, "Print"],
Cell[82440, 2386, 37, 1, 22, "Print"],
Cell[82480, 2389, 513, 11, 22, "Print"],
Cell[82996, 2402, 530, 12, 22, "Print"],
Cell[83529, 2416, 529, 12, 22, "Print"],
Cell[84061, 2430, 37, 1, 22, "Print"],
Cell[84101, 2433, 513, 11, 22, "Print"],
Cell[84617, 2446, 530, 12, 22, "Print"],
Cell[85150, 2460, 528, 12, 22, "Print"],
Cell[85681, 2474, 37, 1, 22, "Print"],
Cell[85721, 2477, 513, 11, 22, "Print"],
Cell[86237, 2490, 530, 12, 22, "Print"],
Cell[86770, 2504, 529, 12, 22, "Print"],
Cell[87302, 2518, 37, 1, 22, "Print"],
Cell[87342, 2521, 512, 11, 22, "Print"],
Cell[87857, 2534, 530, 12, 22, "Print"],
Cell[88390, 2548, 529, 12, 22, "Print"],
Cell[88922, 2562, 37, 1, 22, "Print"],
Cell[88962, 2565, 513, 11, 22, "Print"],
Cell[89478, 2578, 530, 12, 22, "Print"],
Cell[90011, 2592, 529, 12, 22, "Print"],
Cell[90543, 2606, 37, 1, 22, "Print"],
Cell[90583, 2609, 513, 11, 22, "Print"],
Cell[91099, 2622, 530, 12, 22, "Print"],
Cell[91632, 2636, 530, 12, 22, "Print"],
Cell[92165, 2650, 37, 1, 22, "Print"],
Cell[92205, 2653, 511, 11, 22, "Print"],
Cell[92719, 2666, 530, 12, 22, "Print"],
Cell[93252, 2680, 533, 12, 22, "Print"],
Cell[93788, 2694, 37, 1, 22, "Print"],
Cell[93828, 2697, 513, 11, 22, "Print"],
Cell[94344, 2710, 530, 12, 22, "Print"],
Cell[94877, 2724, 564, 13, 22, "Print"],
Cell[95444, 2739, 37, 1, 22, "Print"],
Cell[95484, 2742, 512, 11, 22, "Print"],
Cell[95999, 2755, 530, 12, 22, "Print"],
Cell[96532, 2769, 531, 12, 22, "Print"],
Cell[97066, 2783, 37, 1, 22, "Print"],
Cell[97106, 2786, 511, 11, 22, "Print"],
Cell[97620, 2799, 529, 12, 22, "Print"],
Cell[98152, 2813, 562, 13, 22, "Print"],
Cell[98717, 2828, 37, 1, 22, "Print"],
Cell[98757, 2831, 541, 12, 22, "Print"],
Cell[99301, 2845, 529, 12, 22, "Print"],
Cell[99833, 2859, 559, 13, 22, "Print"],
Cell[100395, 2874, 37, 1, 22, "Print"],
Cell[100435, 2877, 38, 1, 22, "Print"],
Cell[100476, 2880, 300, 6, 22, "Print"],
Cell[100779, 2888, 310, 6, 22, "Print"],
Cell[101092, 2896, 306, 6, 22, "Print"],
Cell[101401, 2904, 37, 1, 22, "Print"],
Cell[101441, 2907, 300, 6, 22, "Print"],
Cell[101744, 2915, 310, 6, 22, "Print"],
Cell[102057, 2923, 306, 6, 22, "Print"],
Cell[102366, 2931, 37, 1, 22, "Print"],
Cell[102406, 2934, 300, 6, 22, "Print"],
Cell[102709, 2942, 310, 6, 22, "Print"],
Cell[103022, 2950, 306, 6, 22, "Print"],
Cell[103331, 2958, 37, 1, 22, "Print"],
Cell[103371, 2961, 300, 6, 22, "Print"],
Cell[103674, 2969, 310, 6, 22, "Print"],
Cell[103987, 2977, 306, 6, 22, "Print"],
Cell[104296, 2985, 37, 1, 22, "Print"],
Cell[104336, 2988, 300, 6, 22, "Print"],
Cell[104639, 2996, 310, 6, 22, "Print"],
Cell[104952, 3004, 306, 6, 22, "Print"],
Cell[105261, 3012, 37, 1, 22, "Print"],
Cell[105301, 3015, 300, 6, 22, "Print"],
Cell[105604, 3023, 310, 6, 22, "Print"],
Cell[105917, 3031, 306, 6, 22, "Print"],
Cell[106226, 3039, 37, 1, 22, "Print"],
Cell[106266, 3042, 300, 6, 22, "Print"],
Cell[106569, 3050, 310, 6, 22, "Print"],
Cell[106882, 3058, 306, 6, 22, "Print"],
Cell[107191, 3066, 37, 1, 22, "Print"],
Cell[107231, 3069, 300, 6, 22, "Print"],
Cell[107534, 3077, 310, 6, 22, "Print"],
Cell[107847, 3085, 306, 6, 22, "Print"],
Cell[108156, 3093, 37, 1, 22, "Print"],
Cell[108196, 3096, 300, 6, 22, "Print"],
Cell[108499, 3104, 310, 6, 22, "Print"],
Cell[108812, 3112, 306, 6, 22, "Print"],
Cell[109121, 3120, 37, 1, 22, "Print"],
Cell[109161, 3123, 302, 6, 22, "Print"],
Cell[109466, 3131, 312, 6, 22, "Print"],
Cell[109781, 3139, 308, 6, 22, "Print"],
Cell[110092, 3147, 37, 1, 22, "Print"],
Cell[110132, 3150, 302, 6, 22, "Print"],
Cell[110437, 3158, 312, 6, 22, "Print"],
Cell[110752, 3166, 308, 6, 22, "Print"],
Cell[111063, 3174, 37, 1, 22, "Print"],
Cell[111103, 3177, 302, 6, 22, "Print"],
Cell[111408, 3185, 312, 6, 22, "Print"],
Cell[111723, 3193, 308, 6, 22, "Print"],
Cell[112034, 3201, 37, 1, 22, "Print"],
Cell[112074, 3204, 302, 6, 22, "Print"],
Cell[112379, 3212, 312, 6, 22, "Print"],
Cell[112694, 3220, 308, 6, 22, "Print"],
Cell[113005, 3228, 37, 1, 22, "Print"],
Cell[113045, 3231, 302, 6, 22, "Print"],
Cell[113350, 3239, 312, 6, 22, "Print"],
Cell[113665, 3247, 308, 6, 22, "Print"],
Cell[113976, 3255, 37, 1, 22, "Print"],
Cell[114016, 3258, 302, 6, 22, "Print"],
Cell[114321, 3266, 312, 6, 22, "Print"],
Cell[114636, 3274, 308, 6, 22, "Print"],
Cell[114947, 3282, 37, 1, 22, "Print"],
Cell[114987, 3285, 302, 6, 22, "Print"],
Cell[115292, 3293, 312, 6, 22, "Print"],
Cell[115607, 3301, 308, 6, 22, "Print"],
Cell[115918, 3309, 37, 1, 22, "Print"],
Cell[115958, 3312, 302, 6, 22, "Print"],
Cell[116263, 3320, 312, 6, 22, "Print"],
Cell[116578, 3328, 308, 6, 22, "Print"],
Cell[116889, 3336, 37, 1, 22, "Print"],
Cell[116929, 3339, 302, 6, 22, "Print"],
Cell[117234, 3347, 312, 6, 22, "Print"],
Cell[117549, 3355, 308, 6, 22, "Print"],
Cell[117860, 3363, 37, 1, 22, "Print"],
Cell[117900, 3366, 302, 6, 22, "Print"],
Cell[118205, 3374, 312, 6, 22, "Print"],
Cell[118520, 3382, 308, 6, 22, "Print"],
Cell[118831, 3390, 37, 1, 22, "Print"],
Cell[118871, 3393, 302, 6, 22, "Print"],
Cell[119176, 3401, 312, 6, 22, "Print"],
Cell[119491, 3409, 308, 6, 22, "Print"],
Cell[119802, 3417, 37, 1, 22, "Print"],
Cell[119842, 3420, 302, 6, 22, "Print"],
Cell[120147, 3428, 312, 6, 22, "Print"],
Cell[120462, 3436, 308, 6, 22, "Print"],
Cell[120773, 3444, 37, 1, 22, "Print"],
Cell[120813, 3447, 302, 6, 22, "Print"],
Cell[121118, 3455, 312, 6, 22, "Print"],
Cell[121433, 3463, 308, 6, 22, "Print"],
Cell[121744, 3471, 37, 1, 22, "Print"],
Cell[121784, 3474, 302, 6, 22, "Print"],
Cell[122089, 3482, 312, 6, 22, "Print"],
Cell[122404, 3490, 308, 6, 22, "Print"],
Cell[122715, 3498, 37, 1, 22, "Print"],
Cell[122755, 3501, 302, 6, 22, "Print"],
Cell[123060, 3509, 312, 6, 22, "Print"],
Cell[123375, 3517, 308, 6, 22, "Print"],
Cell[123686, 3525, 37, 1, 22, "Print"],
Cell[123726, 3528, 302, 6, 22, "Print"],
Cell[124031, 3536, 312, 6, 22, "Print"],
Cell[124346, 3544, 308, 6, 22, "Print"],
Cell[124657, 3552, 37, 1, 22, "Print"],
Cell[124697, 3555, 302, 6, 22, "Print"],
Cell[125002, 3563, 312, 6, 22, "Print"],
Cell[125317, 3571, 308, 6, 22, "Print"],
Cell[125628, 3579, 37, 1, 22, "Print"],
Cell[125668, 3582, 302, 6, 22, "Print"],
Cell[125973, 3590, 312, 6, 22, "Print"],
Cell[126288, 3598, 308, 6, 22, "Print"],
Cell[126599, 3606, 37, 1, 22, "Print"],
Cell[126639, 3609, 302, 6, 22, "Print"],
Cell[126944, 3617, 312, 6, 22, "Print"],
Cell[127259, 3625, 308, 6, 22, "Print"],
Cell[127570, 3633, 37, 1, 22, "Print"],
Cell[127610, 3636, 302, 6, 22, "Print"],
Cell[127915, 3644, 312, 6, 22, "Print"],
Cell[128230, 3652, 308, 6, 22, "Print"],
Cell[128541, 3660, 37, 1, 22, "Print"],
Cell[128581, 3663, 302, 6, 22, "Print"],
Cell[128886, 3671, 312, 6, 22, "Print"],
Cell[129201, 3679, 308, 6, 22, "Print"],
Cell[129512, 3687, 37, 1, 22, "Print"],
Cell[129552, 3690, 302, 6, 22, "Print"],
Cell[129857, 3698, 312, 6, 22, "Print"],
Cell[130172, 3706, 308, 6, 22, "Print"],
Cell[130483, 3714, 37, 1, 22, "Print"],
Cell[130523, 3717, 302, 6, 22, "Print"],
Cell[130828, 3725, 312, 6, 22, "Print"],
Cell[131143, 3733, 308, 6, 22, "Print"],
Cell[131454, 3741, 37, 1, 22, "Print"],
Cell[131494, 3744, 302, 6, 22, "Print"],
Cell[131799, 3752, 312, 6, 22, "Print"],
Cell[132114, 3760, 308, 6, 22, "Print"],
Cell[132425, 3768, 37, 1, 22, "Print"],
Cell[132465, 3771, 302, 6, 22, "Print"],
Cell[132770, 3779, 312, 6, 22, "Print"],
Cell[133085, 3787, 308, 6, 22, "Print"],
Cell[133396, 3795, 37, 1, 22, "Print"],
Cell[133436, 3798, 302, 6, 22, "Print"],
Cell[133741, 3806, 312, 6, 22, "Print"],
Cell[134056, 3814, 308, 6, 22, "Print"],
Cell[134367, 3822, 37, 1, 22, "Print"],
Cell[134407, 3825, 302, 6, 22, "Print"],
Cell[134712, 3833, 312, 6, 22, "Print"],
Cell[135027, 3841, 308, 6, 22, "Print"],
Cell[135338, 3849, 37, 1, 22, "Print"],
Cell[135378, 3852, 302, 6, 22, "Print"],
Cell[135683, 3860, 312, 6, 22, "Print"],
Cell[135998, 3868, 308, 6, 22, "Print"],
Cell[136309, 3876, 37, 1, 22, "Print"],
Cell[136349, 3879, 302, 6, 22, "Print"],
Cell[136654, 3887, 312, 6, 22, "Print"],
Cell[136969, 3895, 308, 6, 22, "Print"],
Cell[137280, 3903, 37, 1, 22, "Print"],
Cell[137320, 3906, 302, 6, 22, "Print"],
Cell[137625, 3914, 312, 6, 22, "Print"],
Cell[137940, 3922, 308, 6, 22, "Print"],
Cell[138251, 3930, 37, 1, 22, "Print"],
Cell[138291, 3933, 302, 6, 22, "Print"],
Cell[138596, 3941, 312, 6, 22, "Print"],
Cell[138911, 3949, 308, 6, 22, "Print"],
Cell[139222, 3957, 37, 1, 22, "Print"],
Cell[139262, 3960, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139369, 3966, 46, 1, 27, "Input"],
Cell[139418, 3969, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[139508, 3976, 53, 0, 28, "Subsection"],
Cell[139564, 3978, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[139731, 3984, 46, 1, 27, "Input"],
Cell[139780, 3987, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139858, 3993, 124, 4, 42, "Input"],
Cell[139985, 3999, 243, 5, 22, "Print"],
Cell[140231, 4006, 253, 5, 22, "Print"],
Cell[140487, 4013, 251, 5, 22, "Print"],
Cell[140741, 4020, 37, 1, 22, "Print"],
Cell[140781, 4023, 243, 5, 22, "Print"],
Cell[141027, 4030, 253, 5, 22, "Print"],
Cell[141283, 4037, 251, 5, 22, "Print"],
Cell[141537, 4044, 37, 1, 22, "Print"],
Cell[141577, 4047, 243, 5, 22, "Print"],
Cell[141823, 4054, 253, 5, 22, "Print"],
Cell[142079, 4061, 251, 5, 22, "Print"],
Cell[142333, 4068, 37, 1, 22, "Print"],
Cell[142373, 4071, 243, 5, 22, "Print"],
Cell[142619, 4078, 253, 5, 22, "Print"],
Cell[142875, 4085, 251, 5, 22, "Print"],
Cell[143129, 4092, 37, 1, 22, "Print"],
Cell[143169, 4095, 243, 5, 22, "Print"],
Cell[143415, 4102, 253, 5, 22, "Print"],
Cell[143671, 4109, 251, 5, 22, "Print"],
Cell[143925, 4116, 37, 1, 22, "Print"],
Cell[143965, 4119, 243, 5, 22, "Print"],
Cell[144211, 4126, 253, 5, 22, "Print"],
Cell[144467, 4133, 251, 5, 22, "Print"],
Cell[144721, 4140, 37, 1, 22, "Print"],
Cell[144761, 4143, 243, 5, 22, "Print"],
Cell[145007, 4150, 253, 5, 22, "Print"],
Cell[145263, 4157, 251, 5, 22, "Print"],
Cell[145517, 4164, 37, 1, 22, "Print"],
Cell[145557, 4167, 243, 5, 22, "Print"],
Cell[145803, 4174, 253, 5, 22, "Print"],
Cell[146059, 4181, 251, 5, 22, "Print"],
Cell[146313, 4188, 37, 1, 22, "Print"],
Cell[146353, 4191, 243, 5, 22, "Print"],
Cell[146599, 4198, 253, 5, 22, "Print"],
Cell[146855, 4205, 251, 5, 22, "Print"],
Cell[147109, 4212, 37, 1, 22, "Print"],
Cell[147149, 4215, 243, 5, 22, "Print"],
Cell[147395, 4222, 253, 5, 22, "Print"],
Cell[147651, 4229, 251, 5, 22, "Print"],
Cell[147905, 4236, 37, 1, 22, "Print"],
Cell[147945, 4239, 245, 5, 22, "Print"],
Cell[148193, 4246, 255, 5, 22, "Print"],
Cell[148451, 4253, 253, 5, 22, "Print"],
Cell[148707, 4260, 37, 1, 22, "Print"],
Cell[148747, 4263, 245, 5, 22, "Print"],
Cell[148995, 4270, 255, 5, 22, "Print"],
Cell[149253, 4277, 253, 5, 22, "Print"],
Cell[149509, 4284, 37, 1, 22, "Print"],
Cell[149549, 4287, 245, 5, 22, "Print"],
Cell[149797, 4294, 255, 5, 22, "Print"],
Cell[150055, 4301, 253, 5, 22, "Print"],
Cell[150311, 4308, 37, 1, 22, "Print"],
Cell[150351, 4311, 245, 5, 22, "Print"],
Cell[150599, 4318, 255, 5, 22, "Print"],
Cell[150857, 4325, 253, 5, 22, "Print"],
Cell[151113, 4332, 37, 1, 22, "Print"],
Cell[151153, 4335, 245, 5, 22, "Print"],
Cell[151401, 4342, 255, 5, 22, "Print"],
Cell[151659, 4349, 253, 5, 22, "Print"],
Cell[151915, 4356, 37, 1, 22, "Print"],
Cell[151955, 4359, 245, 5, 22, "Print"],
Cell[152203, 4366, 255, 5, 22, "Print"],
Cell[152461, 4373, 253, 5, 22, "Print"],
Cell[152717, 4380, 37, 1, 22, "Print"],
Cell[152757, 4383, 245, 5, 22, "Print"],
Cell[153005, 4390, 255, 5, 22, "Print"],
Cell[153263, 4397, 253, 5, 22, "Print"],
Cell[153519, 4404, 37, 1, 22, "Print"],
Cell[153559, 4407, 245, 5, 22, "Print"],
Cell[153807, 4414, 255, 5, 22, "Print"],
Cell[154065, 4421, 253, 5, 22, "Print"],
Cell[154321, 4428, 37, 1, 22, "Print"],
Cell[154361, 4431, 245, 5, 22, "Print"],
Cell[154609, 4438, 255, 5, 22, "Print"],
Cell[154867, 4445, 253, 5, 22, "Print"],
Cell[155123, 4452, 37, 1, 22, "Print"],
Cell[155163, 4455, 245, 5, 22, "Print"],
Cell[155411, 4462, 255, 5, 22, "Print"],
Cell[155669, 4469, 253, 5, 22, "Print"],
Cell[155925, 4476, 37, 1, 22, "Print"],
Cell[155965, 4479, 245, 5, 22, "Print"],
Cell[156213, 4486, 255, 5, 22, "Print"],
Cell[156471, 4493, 253, 5, 22, "Print"],
Cell[156727, 4500, 37, 1, 22, "Print"],
Cell[156767, 4503, 245, 5, 22, "Print"],
Cell[157015, 4510, 255, 5, 22, "Print"],
Cell[157273, 4517, 253, 5, 22, "Print"],
Cell[157529, 4524, 37, 1, 22, "Print"],
Cell[157569, 4527, 245, 5, 22, "Print"],
Cell[157817, 4534, 255, 5, 22, "Print"],
Cell[158075, 4541, 253, 5, 22, "Print"],
Cell[158331, 4548, 37, 1, 22, "Print"],
Cell[158371, 4551, 245, 5, 22, "Print"],
Cell[158619, 4558, 255, 5, 22, "Print"],
Cell[158877, 4565, 253, 5, 22, "Print"],
Cell[159133, 4572, 37, 1, 22, "Print"],
Cell[159173, 4575, 245, 5, 22, "Print"],
Cell[159421, 4582, 255, 5, 22, "Print"],
Cell[159679, 4589, 253, 5, 22, "Print"],
Cell[159935, 4596, 37, 1, 22, "Print"],
Cell[159975, 4599, 245, 5, 22, "Print"],
Cell[160223, 4606, 255, 5, 22, "Print"],
Cell[160481, 4613, 253, 5, 22, "Print"],
Cell[160737, 4620, 37, 1, 22, "Print"],
Cell[160777, 4623, 245, 5, 22, "Print"],
Cell[161025, 4630, 255, 5, 22, "Print"],
Cell[161283, 4637, 253, 5, 22, "Print"],
Cell[161539, 4644, 37, 1, 22, "Print"],
Cell[161579, 4647, 245, 5, 22, "Print"],
Cell[161827, 4654, 255, 5, 22, "Print"],
Cell[162085, 4661, 253, 5, 22, "Print"],
Cell[162341, 4668, 37, 1, 22, "Print"],
Cell[162381, 4671, 245, 5, 22, "Print"],
Cell[162629, 4678, 255, 5, 22, "Print"],
Cell[162887, 4685, 253, 5, 22, "Print"],
Cell[163143, 4692, 37, 1, 22, "Print"],
Cell[163183, 4695, 245, 5, 22, "Print"],
Cell[163431, 4702, 255, 5, 22, "Print"],
Cell[163689, 4709, 253, 5, 22, "Print"],
Cell[163945, 4716, 37, 1, 22, "Print"],
Cell[163985, 4719, 245, 5, 22, "Print"],
Cell[164233, 4726, 255, 5, 22, "Print"],
Cell[164491, 4733, 253, 5, 22, "Print"],
Cell[164747, 4740, 37, 1, 22, "Print"],
Cell[164787, 4743, 245, 5, 22, "Print"],
Cell[165035, 4750, 255, 5, 22, "Print"],
Cell[165293, 4757, 253, 5, 22, "Print"],
Cell[165549, 4764, 37, 1, 22, "Print"],
Cell[165589, 4767, 245, 5, 22, "Print"],
Cell[165837, 4774, 255, 5, 22, "Print"],
Cell[166095, 4781, 253, 5, 22, "Print"],
Cell[166351, 4788, 37, 1, 22, "Print"],
Cell[166391, 4791, 245, 5, 22, "Print"],
Cell[166639, 4798, 255, 5, 22, "Print"],
Cell[166897, 4805, 253, 5, 22, "Print"],
Cell[167153, 4812, 37, 1, 22, "Print"],
Cell[167193, 4815, 245, 5, 22, "Print"],
Cell[167441, 4822, 255, 5, 22, "Print"],
Cell[167699, 4829, 253, 5, 22, "Print"],
Cell[167955, 4836, 37, 1, 22, "Print"],
Cell[167995, 4839, 245, 5, 22, "Print"],
Cell[168243, 4846, 255, 5, 22, "Print"],
Cell[168501, 4853, 253, 5, 22, "Print"],
Cell[168757, 4860, 37, 1, 22, "Print"],
Cell[168797, 4863, 245, 5, 22, "Print"],
Cell[169045, 4870, 255, 5, 22, "Print"],
Cell[169303, 4877, 253, 5, 22, "Print"],
Cell[169559, 4884, 37, 1, 22, "Print"],
Cell[169599, 4887, 245, 5, 22, "Print"],
Cell[169847, 4894, 255, 5, 22, "Print"],
Cell[170105, 4901, 253, 5, 22, "Print"],
Cell[170361, 4908, 37, 1, 22, "Print"],
Cell[170401, 4911, 245, 5, 22, "Print"],
Cell[170649, 4918, 255, 5, 22, "Print"],
Cell[170907, 4925, 253, 5, 22, "Print"],
Cell[171163, 4932, 37, 1, 22, "Print"],
Cell[171203, 4935, 245, 5, 22, "Print"],
Cell[171451, 4942, 255, 5, 22, "Print"],
Cell[171709, 4949, 253, 5, 22, "Print"],
Cell[171965, 4956, 37, 1, 22, "Print"],
Cell[172005, 4959, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[172112, 4965, 46, 1, 27, "Input"],
Cell[172161, 4968, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[172251, 4975, 60, 0, 28, "Subsection"],
Cell[172314, 4977, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[172479, 4983, 46, 1, 27, "Input"],
Cell[172528, 4986, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[172606, 4992, 93, 1, 27, "Input"],
Cell[172702, 4995, 485, 11, 22, "Print"],
Cell[173190, 5008, 308, 6, 22, "Print"],
Cell[173501, 5016, 331, 7, 24, "Print"],
Cell[173835, 5025, 599, 15, 24, "Print"],
Cell[174437, 5042, 660, 17, 24, "Print"],
Cell[175100, 5061, 721, 18, 24, "Print"],
Cell[175824, 5081, 876, 21, 24, "Print"],
Cell[176703, 5104, 886, 22, 24, "Print"],
Cell[177592, 5128, 915, 23, 24, "Print"],
Cell[178510, 5153, 1090, 27, 39, "Print"],
Cell[179603, 5182, 1151, 29, 41, "Print"],
Cell[180757, 5213, 1182, 30, 41, "Print"],
Cell[181942, 5245, 1338, 33, 41, "Print"],
Cell[183283, 5280, 1348, 34, 41, "Print"],
Cell[184634, 5316, 1378, 35, 41, "Print"],
Cell[186015, 5353, 1551, 39, 41, "Print"],
Cell[187569, 5394, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[187676, 5400, 46, 1, 27, "Input"],
Cell[187725, 5403, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

