(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    143444,       4080]*)
(*NotebookOutlinePosition[    144336,       4109]*)
(*  CellTagsIndexPosition[    144292,       4105]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  " :Author:  Z\[EAcute]lia da ROCHA \n\n:Address: \n            Departamento \
de Matem\[AAcute]tica Aplicada da\n            Faculdade de Ci\[EHat]ncias do \
Porto\n            Rua das Taipas, 135\n            4050 Porto\n            \
Portugal\n  \n            Tel: ++351 02 2080313\n            Fax: ++351 02 \
2004109\n            Email: mrdioh@fc.up.pt\n\n :Summary:\n    The ",
  StyleBox["testchv2",
    FontSize->18],
  " notebook contains the results produced by the package\n    chv.m \
corresponding to the ",
  StyleBox["example 2",
    FontSize->18],
  " of the first paper cited bellow.    \n\n :Date: July 1999.\n\n:Available \
at http://netlib.bell-labs.com/ in the numeralgo library in netlib:     \n\n \
:Notebook Version: 1.0 \n\n :Mathematica Version: 3.0   \n \n :Keywords: \
chebyshev's method, recurrence relations,  orthogonal polynomials of\n \
dimension d, d-dimensional forms.\n\n :Sources:\n \n - Z\[EAcute]lia da \
Rocha, Shohat-Favard and Chebyshev's methods in d-orthogonality, \n Numerical \
Algorithms, 20 (1999) 139 -164.\n   \n - About the example treated here see \
pp. 90, 106 of:\n   K. Douak, P. Maroni, Les polyn\[OHat]mes orthogonaux \
\"classiques\" de dimension deux, \n   Analysis 12,  71-107 (1992)"
}], "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing formal computations\
\>", "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv2.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(\(<< chebyshev`chv`; \)\ \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The moments of the d-dimensional form are given in the package \
datachv2.m\
\>", "Subsection",
  AspectRatioFixed->True],

Cell[BoxData[
    \( (*\ showing\ the\ moments\ given\ *) \)], "Input"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ imax\ *) \nd = 2; imax = \ 5; 
    \ \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<form[\>", d, "\<,\>", r, "\<,\>", i, "\<]=\>", 
        form[d, r, i]], {r, 1, d}, {i, 0, imax}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 1, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]40\/7\),
      SequenceForm[ "form[", 2, ",", 1, ",", 2, "]=", 
        Rational[ 40, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]64\),
      SequenceForm[ "form[", 2, ",", 1, ",", 3, "]=", 64],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]14080\/13\),
      SequenceForm[ "form[", 2, ",", 1, ",", 4, "]=", 
        Rational[ 14080, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]24640\),
      SequenceForm[ "form[", 2, ",", 1, ",", 5, "]=", 24640],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]0\),
      SequenceForm[ "form[", 2, ",", 2, ",", 0, "]=", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "form[", 2, ",", 2, ",", 1, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]80\/7\),
      SequenceForm[ "form[", 2, ",", 2, ",", 2, "]=", 
        Rational[ 80, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]192\),
      SequenceForm[ "form[", 2, ",", 2, ",", 3, "]=", 192],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]56320\/13\),
      SequenceForm[ "form[", 2, ",", 2, ",", 4, "]=", 
        Rational[ 56320, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("form["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]123200\),
      SequenceForm[ "form[", 2, ",", 2, ",", 5, "]=", 123200],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(nmax\)\" is similar to \
existing symbol \"\!\(imax\)\"."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(942168\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]216\/49\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 
        Rational[ 216, 49]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]216\/49\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 1, "]=", 
        Rational[ 216, 49]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]6912\/13\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 
        Rational[ 6912, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]6912\/13\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 2, "]=", 
        Rational[ 6912, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]249480\/3211\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 249480, 3211]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]249480\/3211\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 3, "]=", 
        Rational[ 249480, 3211]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]81900\/19\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 81900, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]81900\/19\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 4, "]=", 
        Rational[ 81900, 19]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]96235776\/287375\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 96235776, 287375]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]96235776\/287375\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 5, "]=", 
        Rational[ 96235776, 287375]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]2232576\/155\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 2232576, 155]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]2232576\/155\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 6, "]=", 
        Rational[ 2232576, 155]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]9137145600\/10275973\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 9137145600, 10275973]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]9137145600\/10275973\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 7, "]=", 
        Rational[ 9137145600, 10275973]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]21312720\/629\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 21312720, 629]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]21312720\/629\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 8, "]=", 
        Rational[ 21312720, 629]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2917810350\/1573499\),
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 2917810350, 1573499]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]2917810350\/1573499\),
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 
        Rational[ 2917810350, 1573499]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]33\/7\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 
        Rational[ 33, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]33\/7\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 1, "]=", 
        Rational[ 33, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3288\/49\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 
        Rational[ 3288, 49]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]3288\/49\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 2, "]=", 
        Rational[ 3288, 49]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]24696\/169\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 
        Rational[ 24696, 169]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]24696\/169\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 3, "]=", 
        Rational[ 24696, 169]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]79035\/247\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 
        Rational[ 79035, 247]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]79035\/247\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 4, "]=", 
        Rational[ 79035, 247]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]5430516\/11495\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 
        Rational[ 5430516, 11495]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]5430516\/11495\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 5, "]=", 
        Rational[ 5430516, 11495]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]5209344\/6875\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 5209344, 6875]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]5209344\/6875\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 6, "]=", 
        Rational[ 5209344, 6875]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]16069440\/16337\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 
        Rational[ 16069440, 16337]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]16069440\/16337\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 7, "]=", 
        Rational[ 16069440, 16337]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]457561632\/331483\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 
        Rational[ 457561632, 331483]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]457561632\/331483\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 8, "]=", 
        Rational[ 457561632, 331483]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]10689705\/6364\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 
        Rational[ 10689705, 6364]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]10689705\/6364\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 9, "]=", 
        Rational[ 10689705, 6364]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gamma["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]93043020\/42527\),
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 
        Rational[ 93043020, 42527]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gammaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]"]="\[InvisibleSpace]93043020\/42527\),
      SequenceForm[ "gammaexact[", 2, ",", 1, ",", 10, "]=", 
        Rational[ 93043020, 42527]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({7.4166666666666714`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1001384\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ nmax = \ 10; 
    \ \ \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1003168\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,Infinity,$MachinePrecision,True,False]]\
\>\
", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "beta[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]73\/7\),
      SequenceForm[ "beta[", 2, ",", 1, "]=", 
        Rational[ 73, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]"]="\[InvisibleSpace]73\/7\),
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 
        Rational[ 73, 7]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1312\/91\),
      SequenceForm[ "beta[", 2, ",", 2, "]=", 
        Rational[ 1312, 91]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]"]="\[InvisibleSpace]1312\/91\),
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 
        Rational[ 1312, 91]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]379\/13\),
      SequenceForm[ "beta[", 2, ",", 3, "]=", 
        Rational[ 379, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]"]="\[InvisibleSpace]379\/13\),
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 
        Rational[ 379, 13]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]305\/11\),
      SequenceForm[ "beta[", 2, ",", 4, "]=", 
        Rational[ 305, 11]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]"]="\[InvisibleSpace]305\/11\),
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 
        Rational[ 305, 11]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]13154\/275\),
      SequenceForm[ "beta[", 2, ",", 5, "]=", 
        Rational[ 13154, 275]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]"]="\[InvisibleSpace]13154\/275\),
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 
        Rational[ 13154, 275]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]31816\/775\),
      SequenceForm[ "beta[", 2, ",", 6, "]=", 
        Rational[ 31816, 775]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]"]="\[InvisibleSpace]31816\/775\),
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 
        Rational[ 31816, 775]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]35048\/527\),
      SequenceForm[ "beta[", 2, ",", 7, "]=", 
        Rational[ 35048, 527]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]"]="\[InvisibleSpace]35048\/527\),
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 
        Rational[ 35048, 527]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]1849\/34\),
      SequenceForm[ "beta[", 2, ",", 8, "]=", 
        Rational[ 1849, 34]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]"]="\[InvisibleSpace]1849\/34\),
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 
        Rational[ 1849, 34]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("beta["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]7325\/86\),
      SequenceForm[ "beta[", 2, ",", 9, "]=", 
        Rational[ 7325, 86]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("betaexact["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]"]="\[InvisibleSpace]7325\/86\),
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 
        Rational[ 7325, 86]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({4.26666666666666571`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1006576\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 10\ \ \ ; \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1008392\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,Infinity]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]0
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]1\),
      SequenceForm[ "dorthpoly[", 2, ",", 0, ",", x, "]=", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]1
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 1\) + x\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 1, ",", x, "]=", 
        Plus[ -1, x]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]2
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(40\/7 - \(80\ x\)\/7 + 
          x\^2\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 2, ",", x, "]=", 
        Plus[ 
          Rational[ 40, 7], 
          Times[ 
            Rational[ -80, 7], x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]3
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 256\/13\) + 
          \(1344\ x\)\/13 - \(336\ x\^2\)\/13 + x\^3\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ 
          Rational[ -256, 13], 
          Times[ 
            Rational[ 1344, 13], x], 
          Times[ 
            Rational[ -336, 13], 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]4
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(3520\/13 - \(24640\ x\)\/13 + 
          \(9240\ x\^2\)\/13 - 55\ x\^3 + x\^4\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 
          Rational[ 3520, 13], 
          Times[ 
            Rational[ -24640, 13], x], 
          Times[ 
            Rational[ 9240, 13], 
            Power[ x, 2]], 
          Times[ -55, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]5
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 31360\/19\) + 
          \(392000\ x\)\/19 - \(254800\ x\^2\)\/19 + \(36400\ x\^3\)\/19 - 
          \(910\ x\^4\)\/11 + x\^5\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ 
          Rational[ -31360, 19], 
          Times[ 
            Rational[ 392000, 19], x], 
          Times[ 
            Rational[ -254800, 19], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 36400, 19], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -910, 11], 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]6
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(3411968\/95 - 
          \(10235904\ x\)\/19 + \(8316672\ x\^2\)\/19 - 
          \(1584128\ x\^3\)\/19 + \(297024\ x\^4\)\/55 - \(3264\ x\^5\)\/25 + 
          x\^6\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 
          Rational[ 3411968, 95], 
          Times[ 
            Rational[ -10235904, 19], x], 
          Times[ 
            Rational[ 8316672, 19], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -1584128, 19], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 297024, 55], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -3264, 25], 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]7
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 9748480\/31\) + 
          \(221777920\ x\)\/31 - \(266133504\ x\^2\)\/31 + 
          \(75246080\ x\^3\)\/31 - \(7524608\ x\^4\)\/31 + 
          \(310080\ x\^5\)\/31 - \(5320\ x\^6\)\/31 + x\^7\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ 
          Rational[ -9748480, 31], 
          Times[ 
            Rational[ 221777920, 31], x], 
          Times[ 
            Rational[ -266133504, 31], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 75246080, 31], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -7524608, 31], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 310080, 31], 
            Power[ x, 5]], 
          Times[ 
            Rational[ -5320, 31], 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]8
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(290160640\/31 - 
          \(7544176640\ x\)\/31 + \(10561847296\ x\^2\)\/31 - 
          \(3583483904\ x\^3\)\/31 + \(447935488\ x\^4\)\/31 - 
          \(24611840\ x\^5\)\/31 + \(10767680\ x\^6\)\/527 - 
          \(4048\ x\^7\)\/17 + x\^8\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 
          Rational[ 290160640, 31], 
          Times[ 
            Rational[ -7544176640, 31], x], 
          Times[ 
            Rational[ 10561847296, 31], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -3583483904, 31], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 447935488, 31], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -24611840, 31], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 10767680, 527], 
            Power[ x, 6]], 
          Times[ 
            Rational[ -4048, 17], 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]9
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(\( - 122592870400\/1147\) + 
          \(4413343334400\ x\)\/1147 - \(8385352335360\ x\^2\)\/1147 + 
          \(3843286487040\ x\^3\)\/1147 - \(655105651200\ x\^4\)\/1147 + 
          \(50392742400\ x\^5\)\/1147 - \(1049848800\ x\^6\)\/629 + 
          \(1184040\ x\^7\)\/37 - \(585\ x\^8\)\/2 + x\^9\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ 
          Rational[ -122592870400, 1147], 
          Times[ 
            Rational[ 4413343334400, 1147], x], 
          Times[ 
            Rational[ -8385352335360, 1147], 
            Power[ x, 2]], 
          Times[ 
            Rational[ 3843286487040, 1147], 
            Power[ x, 3]], 
          Times[ 
            Rational[ -655105651200, 1147], 
            Power[ x, 4]], 
          Times[ 
            Rational[ 50392742400, 1147], 
            Power[ x, 5]], 
          Times[ 
            Rational[ -1049848800, 629], 
            Power[ x, 6]], 
          Times[ 
            Rational[ 1184040, 37], 
            Power[ x, 7]], 
          Times[ 
            Rational[ -585, 2], 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("dorthpoly["\[InvisibleSpace]2\[InvisibleSpace]","\[InvisibleSpace]10
        \[InvisibleSpace]","\[InvisibleSpace]x
        \[InvisibleSpace]"]="\[InvisibleSpace]\(199090821529600\/49321 - 
          \(7963632861184000\ x\)\/49321 + 
          \(17022265240780800\ x\^2\)\/49321 - 
          \(8916424649932800\ x\^3\)\/49321 + 
          \(1773152629248000\ x\^4\)\/49321 - 
          \(163675627315200\ x\^5\)\/49321 + \(4262386128000\ x\^6\)\/27047 - 
          \(6409603200\ x\^7\)\/1591 + \(2375100\ x\^8\)\/43 - 
          \(16240\ x\^9\)\/43 + x\^10\)\),
      SequenceForm[ "dorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 
          Rational[ 199090821529600, 49321], 
          Times[ 
            Rational[ -7963632861184000, 49321], x], 
          Times[ 
            Rational[ 17022265240780800, 49321], 
            Power[ x, 2]], 
          Times[ 
            Rational[ -8916424649932800, 49321], 
            Power[ x, 3]], 
          Times[ 
            Rational[ 1773152629248000, 49321], 
            Power[ x, 4]], 
          Times[ 
            Rational[ -163675627315200, 49321], 
            Power[ x, 5]], 
          Times[ 
            Rational[ 4262386128000, 27047], 
            Power[ x, 6]], 
          Times[ 
            Rational[ -6409603200, 1591], 
            Power[ x, 7]], 
          Times[ 
            Rational[ 2375100, 43], 
            Power[ x, 8]], 
          Times[ 
            Rational[ -16240, 43], 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.25`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1017120\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Computing the recurrence coefficients and the orthogonal \
polynomials performing numerical computations with the machine precision\
\>",
   "Section",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Loading the package chv.m, the package datachv2.m is automatically \
loaded\
\>", "Subsection"],

Cell[BoxData[
    \(\(<< chebyshev`chv`\ ; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the gamma coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 15\ \ ; \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(965208\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printgamma[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.40816326530611579`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 1, "]=", 4.4081632653061158],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.40816326530612201`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 1, "]=", 4.408163265306122],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.2064017431848004`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 1, "]=", 14.2064017431848],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["531.692307692308219`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 2, "]=", 531.69230769230819],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["531.692307692307686`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 2, "]=", 531.69230769230774],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.3422298222232269`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 2, "]=", 14.342229822223228],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["77.6954219869088014`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 3, "]=", 77.695421986908798],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["77.6954219869199658`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 3, "]=", 77.695421986919968],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.9519572545037267`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 3, "]=", 11.951957254503727],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4310.52631579241118`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 4, "]=", 4310.526315792411],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4310.52631578947309`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 4, "]=", 4310.5263157894733],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.5319973042281453`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 4, "]=", 11.531997304228145],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["334.878733368636938`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 5, "]=", 334.87873336863692],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["334.878733362331448`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 5, "]=", 334.87873336233145],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.2002825414805498`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 5, "]=", 10.200282541480549],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14403.7161322623274`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 6, "]=", 14403.716132262331],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14403.7161290322579`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 6, "]=", 14403.716129032258],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.49078776298163262`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 6, "]=", 9.4907877629816326],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["889.175711326174322`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 7, "]=", 889.17571132617434],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["889.175711146769209`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 7, "]=", 889.17571114676923],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.74616520106358663`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 7, "]=", 8.7461652010635866],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["33883.4976192478176`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 8, "]=", 33883.497619247821],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["33883.4976152623212`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 8, "]=", 33883.49761526232],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.39951714614831068`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 8, "]=", 9.3995171461483107],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1854.30869928261472`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 9, "]=", 1854.3086992826147],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1854.34522042911993`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gammaexact[", 2, ",", 0, ",", 9, "]=", 1854.34522042912],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.4374555971537708`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 9, "]=", 4.4374555971537708],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["65815.6444585121125`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 10, "]=", 65815.644458512106],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["65821.9153546150437`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 10, "]=", 65821.915354615048],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.20267039461497748`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 10, "]=", 3.2026703946149775],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3349.36122472558661`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 11, "]=", 3349.3612247255869],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3344.16041510874606`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 11, "]=", 3344.1604151087463],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.2839290439119404`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 11, "]=", 2.2839290439119404],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["112979.062031659927`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 12, "]=", 112979.06203165992],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["113290.984326018806`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 12, "]=", 113290.98432601881],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.50595358333514628`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 12, "]=", 2.5059535833351463],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["17693.7346967187858`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 13, "]=", 17693.734696718784],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5472.39734943273781`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 13, "]=", 5472.3973494327374],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.0871187321559414584`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 13, "]=", -0.087118732155941458],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["590820.535211489783`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 0, ",", 14, "]=", 590820.53521148977],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["179362.711034988979`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 0, ",", 14, "]=", 179362.71103498898],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.614325325171260594`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 0, ",", 14, "]=", -0.61432532517126059],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \("   "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.71428571428571441`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 1, "]=", 4.7142857142857144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4.71428571428571441`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 1, "]=", 4.7142857142857144],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.1020408163265535`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 2, "]=", 67.10204081632655],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.1020408163265358`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 2, "]=", 67.102040816326536],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.8473798005431341`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 2, "]=", 14.847379800543134],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["146.130177514794095`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 3, "]=", 146.1301775147941],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["146.130177514792913`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 3, "]=", 146.1301775147929],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.9231005144812524`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 3, "]=", 13.923100514481252],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["319.979757085024729`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 4, "]=", 319.97975708502474],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["319.979757085020244`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 4, "]=", 319.97975708502025],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.3476927179247306`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 4, "]=", 13.34769271792473],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["472.424184428579074`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 5, "]=", 472.42418442857905],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["472.42418442801215`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 5, "]=", 472.42418442801215],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.2464939901748861`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 5, "]=", 11.246493990174885],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["757.722763637809482`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 6, "]=", 757.72276363780952],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["757.722763636363616`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 6, "]=", 757.72276363636365],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.8398709929035952`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 6, "]=", 10.839870992903595],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["983.622452331090713`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 7, "]=", 983.62245233109081],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["983.622452102589228`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 7, "]=", 983.62245210258925],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.6411108257517597`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 7, "]=", 8.6411108257517597],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1380.34720415765409`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 8, "]=", 1380.347204157654],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1380.34720332566074`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 8, "]=", 1380.3472033256608],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.07988019838361459`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 8, "]=", 9.0798801983836146],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1679.71495059767583`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 9, "]=", 1679.7149505976759],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1679.71480201131351`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 9, "]=", 1679.7148020113136],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.82802104979738544`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 9, "]=", 6.8280210497973854],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2187.85962407664902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 10, "]=", 2187.8596240766492],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2187.85759635055354`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 10, "]=", 2187.8575963505536],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["5.69299070970648379`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 10, "]=", 5.6929907097064838],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2560.4269290095809`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 11, "]=", 2560.4269290095813],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2560.69839350660766`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 11, "]=", 2560.6983935066073],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.56628696074876838`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 11, "]=", 3.5662869607487684],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3179.04031180849511`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 12, "]=", 3179.0403118084955],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3180.25543687082201`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 12, "]=", 3180.2554368708215],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["2.91537902158586561`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 12, "]=", 2.9153790215858657],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3552.32171997622447`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 13, "]=", 3552.3217199762244],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3626.57213486889284`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 13, "]=", 3626.572134868893],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.12930111527548859`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 13, "]=", 1.1293011152754886],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3768.254579047563`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 14, "]=", 3768.2545790475633],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4357.54135428926225`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 14, "]=", 4357.541354289262],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["0.229673305220821521`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 14, "]=", 0.22967330522082152],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gamma["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1697.8937983848148`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "gamma[", 2, ",", 1, ",", 15, "]=", 1697.893798384815],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("gammaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["4877.33551856920133`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ 
      "gammaexact[", 2, ",", 1, ",", 15, "]=", 4877.3355185692008],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.502350868686104234`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ 
      "exactdigits[", 2, ",", 1, ",", 15, "]=", -0.50235086868610423],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({15.8833333333333248`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1056472\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the beta coefficients", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 15\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1058256\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[printbeta[d,nmax,$MachinePrecision,$MachinePrecision,True,\
True]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 0, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 0, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4285714285714292`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 1, "]=", 10.428571428571429],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["10.4285714285714292`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 1, "]=", 10.428571428571429],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        InterpretationBox["\[Infinity]",
          DirectedInfinity[ 1]]}],
      SequenceForm[ "exactdigits[", 2, ",", 1, "]=", 
        DirectedInfinity[ 1]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.4175824175824001`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 2, "]=", 14.4175824175824],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.4175824175824178`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 2, "]=", 14.417582417582418],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["14.7504697875350787`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 2, "]=", 14.750469787535078],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["29.1538461538460236`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 3, "]=", 29.153846153846025],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["29.1538461538461532`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 3, "]=", 29.153846153846153],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["13.8931372911038097`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 3, "]=", 13.893137291103809],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["27.7272727272634256`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 4, "]=", 27.727272727263426],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["27.7272727272727248`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 4, "]=", 27.727272727272727],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.031470149656358`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 4, "]=", 12.031470149656359],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["47.8327272726797403`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 5, "]=", 47.83272727267974],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["47.8327272727272756`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 5, "]=", 47.832727272727276],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["11.3229836784392934`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 5, "]=", 11.322983678439293],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.0529032216278899`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 6, "]=", 41.052903221627886],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["41.0529032258064496`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 6, "]=", 41.052903225806453],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["9.37897264797061502`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 6, "]=", 9.378972647970615],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["66.5047438187835826`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 7, "]=", 66.504743818783581],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["66.504743833017077`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 7, "]=", 66.504743833017073],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.84668851989243165`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 7, "]=", 8.8466885198924317],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["54.3823529087113755`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 8, "]=", 54.382352908711376],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["54.3823529411764727`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 8, "]=", 54.382352941176471],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["8.48858331524881748`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 8, "]=", 8.4885833152488175],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["85.1744124214065756`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 9, "]=", 85.174412421406572],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["85.1744186046511586`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 9, "]=", 85.174418604651166],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["6.20878357355921206`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 9, "]=", 6.2087835735592121],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.7160368511223964`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 10, "]=", 67.716036851122396],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["67.7133364973896512`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 10, "]=", 67.713336497389648],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.56857934172307444`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 10, "]=", 3.5685793417230744],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["103.853496320565907`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 11, "]=", 103.85349632056591],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["103.843014128728405`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 11, "]=", 103.84301412872841],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["3.97954789641706963`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 11, "]=", 3.9795478964170696],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["81.1701898758988704`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 12, "]=", 81.17018987589887],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["81.0450928381962754`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 12, "]=", 81.045092838196283],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.90275297427661982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 12, "]=", 1.9027529742766198],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["124.611168809325945`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 13, "]=", 124.61116880932595],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["122.511023176936117`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 13, "]=", 122.51102317693612],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.6777505885278301`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2]}],
      SequenceForm[ "exactdigits[", 2, ",", 13, "]=", 1.6777505885278301],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("beta["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["12.4605259181905902`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "beta[", 2, ",", 14, "]=", 12.460525918190591],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("betaexact["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["94.3772938585759746`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "betaexact[", 2, ",", 14, "]=", 94.377293858575968],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("exactdigits["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["0.913372808703208427`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ "exactdigits[", 2, ",", 14, "]=", -0.91337280870320847],
      Editable->False]], "Print"],

Cell[BoxData[
    \("  "\)], "Print"],

Cell[BoxData[
    \({8.5166666666666515`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1060896\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Computing the d-orthogonal polynomials", "Subsection"],

Cell[BoxData[
    \(\( (*\ set\ the\ values\ of\ d\ and\ nmax\ *) \nd = 2; \ 
    nmax = \ 15\ \ ; \ \ \  (*\ for\ example\ *) \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1062680\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[printdorthpoly[d,nmax,x,$MachinePrecision]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "0", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        StyleBox["1.`",
          StyleBoxAutoDelete->True,
          PrintPrecision->16]}],
      SequenceForm[ "dorthpoly[", 2, ",", 0, ",", x, "]=", 1.0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "1", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", "x"}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 1, ",", x, "]=", 
        Plus[ -1.0, x]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["5.71428571428571441`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["11.4285714285714279`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", \(x\^2\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 2, ",", x, "]=", 
        Plus[ 5.7142857142857144, 
          Times[ -11.428571428571429, x], 
          Power[ x, 2]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "3", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["19.6923076923075655`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["103.384615384615186`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["25.8461538461538298`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", \(x\^3\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 3, ",", x, "]=", 
        Plus[ -19.692307692307566, 
          Times[ 103.38461538461517, x], 
          Times[ -25.846153846153829, 
            Power[ x, 2]], 
          Power[ x, 3]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "4", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["270.769230769218216`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["1895.38461538458271`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["710.769230769225579`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["54.9999999999998578`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", \(x\^4\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 4, ",", x, "]=", 
        Plus[ 270.76923076921821, 
          Times[ -1895.3846153845827, x], 
          Times[ 710.76923076922549, 
            Power[ x, 2]], 
          Times[ -54.999999999999858, 
            Power[ x, 3]], 
          Power[ x, 4]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "5", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1650.52631578649489`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["20631.5789473493449`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["13410.5263157825627`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1915.78947368368588`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["82.7272727272632835`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", \(x\^5\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 5, ",", x, "]=", 
        Plus[ -1650.5263157864947, 
          Times[ 20631.578947349346, x], 
          Times[ -13410.526315782561, 
            Power[ x, 2]], 
          Times[ 1915.7894736836856, 
            Power[ x, 3]], 
          Times[ -82.727272727263284, 
            Power[ x, 4]], 
          Power[ x, 5]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "6", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{
            StyleBox["35915.4526312677457`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], "\[InvisibleSpace]"}], "-", 
          RowBox[{
            StyleBox["538731.789471031952`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["437719.578946056664`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["83375.1578945856053`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["5400.43636363088808`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["130.559999999943032`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", \(x\^6\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 6, ",", x, "]=", 
        Plus[ 35915.452631267748, 
          Times[ -538731.78947103198, x], 
          Times[ 437719.57894605666, 
            Power[ x, 2]], 
          Times[ -83375.157894585602, 
            Power[ x, 3]], 
          Times[ 5400.4363636308881, 
            Power[ x, 4]], 
          Times[ -130.55999999994302, 
            Power[ x, 5]], 
          Power[ x, 6]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "7", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["314467.096612916563`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["7.15412644924914786`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["8.58495174004026395`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["2.42729290286787158`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["242729.290299532429`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["10002.5806446064757`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["171.612903221570896`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", \(x\^7\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 7, ",", x, "]=", 
        Plus[ -314467.09661291656, 
          Times[ 7154126.4492491484, x], 
          Times[ -8584951.740040265, 
            Power[ x, 2]], 
          Times[ 2427292.9028678718, 
            Power[ x, 3]], 
          Times[ -242729.29029953241, 
            Power[ x, 4]], 
          Times[ 10002.580644606476, 
            Power[ x, 5]], 
          Times[ -171.61290322157089, 
            Power[ x, 6]], 
          Power[ x, 7]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "8", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["9.36002062734741357`*^6",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["2.43360536460877652`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["3.40704751177760423`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.15596254894771477`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["1.44495318646605603`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["793930.322351780493`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["20432.0303570236561`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["238.117647040354452`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", \(x\^8\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 8, ",", x, "]=", 
        Plus[ 9360020.6273474135, 
          Times[ -243360536.46087766, x], 
          Times[ 340704751.17776036, 
            Power[ x, 2]], 
          Times[ -115596254.89477149, 
            Power[ x, 3]], 
          Times[ 14449531.864660561, 
            Power[ x, 4]], 
          Times[ -793930.32235178049, 
            Power[ x, 5]], 
          Times[ 20432.030357023654, 
            Power[ x, 6]], 
          Times[ -238.11764704035448, 
            Power[ x, 7]], 
          Power[ x, 8]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "9", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["1.06881315521019892`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["3.8477273782016601`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["7.31068203846232655`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["3.35072927297304534`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["5.71147035737384545`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["4.39343873934487483`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.66907599242099742`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["32001.0810680065338`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["292.499999949065845`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", \(x\^9\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 9, ",", x, "]=", 
        Plus[ -106881315.52101988, 
          Times[ 3847727378.2016602, x], 
          Times[ -7310682038.462326, 
            Power[ x, 2]], 
          Times[ 3350729272.9730453, 
            Power[ x, 3]], 
          Times[ -571147035.73738456, 
            Power[ x, 4]], 
          Times[ 43934387.393448748, 
            Power[ x, 5]], 
          Times[ -1669075.9924209975, 
            Power[ x, 6]], 
          Times[ 32001.081068006533, 
            Power[ x, 7]], 
          Times[ -292.49999994906585, 
            Power[ x, 8]], 
          Power[ x, 9]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "10", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["4.03663178208727657`*^9",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.61465294943731052`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["3.45132101956027792`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["1.80783494762841527`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["3.59512650759109364`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["3.31857845233957515`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["1.57591812870565339`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["4.02866299512267644`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["55234.8817463319896`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["377.674412370472367`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", \(x\^10\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 10, ",", x, "]=", 
        Plus[ 4036631782.0872765, 
          Times[ -161465294943.73108, x], 
          Times[ 345132101956.02777, 
            Power[ x, 2]], 
          Times[ -180783494762.84152, 
            Power[ x, 3]], 
          Times[ 35951265075.910934, 
            Power[ x, 4]], 
          Times[ -3318578452.3395748, 
            Power[ x, 5]], 
          Times[ 157591812.87056535, 
            Power[ x, 6]], 
          Times[ -4028662.9951226762, 
            Power[ x, 7]], 
          Times[ 55234.881746331994, 
            Power[ x, 8]], 
          Times[ -377.6744123704724, 
            Power[ x, 9]], 
          Power[ x, 10]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "11", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["5.6859759388352602`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["2.97080467896890354`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["8.16946915708518162`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["5.4704997488977316`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["1.39246503922401076`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["1.66022165464570781`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["1.03762547784194336`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["3.6082457513791013`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["7.13085565169298085`*^6",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["78621.6365480602519`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["445.390449221594764`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", \(x\^11\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 11, ",", x, "]=", 
        Plus[ -56859759388.3526, 
          Times[ 2970804678968.9033, x], 
          Times[ -8169469157085.1816, 
            Power[ x, 2]], 
          Times[ 5470499748897.7314, 
            Power[ x, 3]], 
          Times[ -1392465039224.0107, 
            Power[ x, 4]], 
          Times[ 166022165464.5708, 
            Power[ x, 5]], 
          Times[ -10376254778.419434, 
            Power[ x, 6]], 
          Times[ 360824575.13791013, 
            Power[ x, 7]], 
          Times[ -7130855.6516929818, 
            Power[ x, 8]], 
          Times[ 78621.636548060254, 
            Power[ x, 9]], 
          Times[ -445.39044922159479, 
            Power[ x, 10]], 
          Power[ x, 11]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "12", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.60404675666383678`*^12",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["1.48405880378405141`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["4.4887046160406463`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["3.33947472896373076`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["9.56226855817659426`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.30290397742197683`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["9.49981493542592048`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["3.96402230181175863`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["9.79215063680288366`*^8",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["1.43947954022811108`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["122316.564998500765`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["549.243945542160627`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", \(x\^12\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 12, ",", x, "]=", 
        Plus[ 2604046756663.8369, 
          Times[ -148405880378405.12, x], 
          Times[ 448870461604064.62, 
            Power[ x, 2]], 
          Times[ -333947472896373.06, 
            Power[ x, 3]], 
          Times[ 95622685581765.953, 
            Power[ x, 4]], 
          Times[ -13029039774219.77, 
            Power[ x, 5]], 
          Times[ 949981493542.59204, 
            Power[ x, 6]], 
          Times[ -39640223018.117584, 
            Power[ x, 7]], 
          Times[ 979215063.68028831, 
            Power[ x, 8]], 
          Times[ -14394795.402281111, 
            Power[ x, 9]], 
          Times[ 122316.56499850076, 
            Power[ x, 10]], 
          Times[ -549.24394554216065, 
            Power[ x, 11]], 
          Power[ x, 12]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "13", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          RowBox[{"-", 
            StyleBox["4.41316404382358395`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16]}], "+", 
          RowBox[{
            StyleBox["3.14523530084371527`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "-", 
          RowBox[{
            StyleBox["1.17682067817123003`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "+", 
          RowBox[{
            StyleBox["1.07700202451241588`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "-", 
          RowBox[{
            StyleBox["3.78937029875965203`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "+", 
          RowBox[{
            StyleBox["6.36516279279688479`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "-", 
          RowBox[{
            StyleBox["5.76805176648339301`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "+", 
          RowBox[{
            StyleBox["3.03400350041493505`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["9.66390196631410169`*^10",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["1.89896695577388747`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["2.29106893768319208`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["163719.760034537316`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["630.414135418059462`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", \(x\^13\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 13, ",", x, "]=", 
        Plus[ -44131640438235.844, 
          Times[ 3145235300843715.0, x], 
          Times[ -11768206781712300.0, 
            Power[ x, 2]], 
          Times[ 10770020245124158.0, 
            Power[ x, 3]], 
          Times[ -3789370298759652.0, 
            Power[ x, 4]], 
          Times[ 636516279279688.5, 
            Power[ x, 5]], 
          Times[ -57680517664833.922, 
            Power[ x, 6]], 
          Times[ 3034003500414.9346, 
            Power[ x, 7]], 
          Times[ -96639019663.141022, 
            Power[ x, 8]], 
          Times[ 1898966955.7738874, 
            Power[ x, 9]], 
          Times[ -22910689.376831923, 
            Power[ x, 10]], 
          Times[ 163719.76003453732, 
            Power[ x, 11]], 
          Times[ -630.41413541805946, 
            Power[ x, 12]], 
          Power[ x, 13]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "14", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["2.67284572599283754`*^15",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["2.0042887252769681`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["7.98041909612036626`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["7.85596086800676385`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["3.00604733353751862`*^17",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["5.55800953762222249`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["5.62181264220216991`*^15",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["3.35702036868217934`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "+", 
          RowBox[{
            StyleBox["1.24034551369984158`*^13",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "-", 
          RowBox[{
            StyleBox["2.91019165942869584`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "+", 
          RowBox[{
            StyleBox["4.36970674188217778`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "-", 
          RowBox[{
            StyleBox["4.1473887896634789`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "+", 
          RowBox[{
            StyleBox["238724.080562926177`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "-", 
          RowBox[{
            StyleBox["755.025304227385429`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "+", \(x\^14\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 14, ",", x, "]=", 
        Plus[ 2672845725992838.0, 
          Times[ -2.0042887252769677*^+17, x], 
          Times[ 7.9804190961203648*^+17, 
            Power[ x, 2]], 
          Times[ -7.8559608680067635*^+17, 
            Power[ x, 3]], 
          Times[ 3.0060473335375181*^+17, 
            Power[ x, 4]], 
          Times[ -55580095376222224.0, 
            Power[ x, 5]], 
          Times[ 5621812642202170.0, 
            Power[ x, 6]], 
          Times[ -335702036868217.94, 
            Power[ x, 7]], 
          Times[ 12403455136998.416, 
            Power[ x, 8]], 
          Times[ -291019165942.86957, 
            Power[ x, 9]], 
          Times[ 4369706741.8821783, 
            Power[ x, 10]], 
          Times[ -41473887.896634787, 
            Power[ x, 11]], 
          Times[ 238724.08056292616, 
            Power[ x, 12]], 
          Times[ -755.02530422738539, 
            Power[ x, 13]], 
          Power[ x, 14]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("dorthpoly["\), "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        \(","\), "\[InvisibleSpace]", "15", "\[InvisibleSpace]", \(","\), 
        "\[InvisibleSpace]", "x", "\[InvisibleSpace]", \("]="\), 
        "\[InvisibleSpace]", 
        RowBox[{
          StyleBox["8.6918880267943166`*^16",
            StyleBoxAutoDelete->True,
            PrintPrecision->16], "-", 
          RowBox[{
            StyleBox["6.72607104312680803`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", "x"}], "+", 
          RowBox[{
            StyleBox["2.62589534604991481`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^2\)}], "-", 
          RowBox[{
            StyleBox["2.40884178066349852`*^19",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^3\)}], "+", 
          RowBox[{
            StyleBox["8.05610039245049414`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^4\)}], "-", 
          RowBox[{
            StyleBox["1.17486105859128886`*^18",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^5\)}], "+", 
          RowBox[{
            StyleBox["7.49153167872151026`*^16",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^6\)}], "-", 
          RowBox[{
            StyleBox["9.26677420495602`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^7\)}], "-", 
          RowBox[{
            StyleBox["1.43421154265391859`*^14",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^8\)}], "+", 
          RowBox[{
            StyleBox["9.12861376122629586`*^12",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^9\)}], "-", 
          RowBox[{
            StyleBox["2.61298936751698773`*^11",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^10\)}], "+", 
          RowBox[{
            StyleBox["4.27927363817181571`*^9",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^11\)}], "-", 
          RowBox[{
            StyleBox["4.20906482719966401`*^7",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^12\)}], "+", 
          RowBox[{
            StyleBox["244363.838356093676`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^13\)}], "-", 
          RowBox[{
            StyleBox["767.485830145575942`",
              StyleBoxAutoDelete->True,
              PrintPrecision->16], " ", \(x\^14\)}], "+", \(x\^15\)}]}],
      SequenceForm[ "dorthpoly[", 2, ",", 15, ",", x, "]=", 
        Plus[ 86918880267943168.0, 
          Times[ -6.7260710431268076*^+18, x], 
          Times[ 2.6258953460499153*^+19, 
            Power[ x, 2]], 
          Times[ -2.4088417806634992*^+19, 
            Power[ x, 3]], 
          Times[ 8.0561003924504955*^+18, 
            Power[ x, 4]], 
          Times[ -1.1748610585912888*^+18, 
            Power[ x, 5]], 
          Times[ 74915316787215104.0, 
            Power[ x, 6]], 
          Times[ -926677420495602.0, 
            Power[ x, 7]], 
          Times[ -143421154265391.88, 
            Power[ x, 8]], 
          Times[ 9128613761226.2969, 
            Power[ x, 9]], 
          Times[ -261298936751.69879, 
            Power[ x, 10]], 
          Times[ 4279273638.1718159, 
            Power[ x, 11]], 
          Times[ -42090648.271996647, 
            Power[ x, 12]], 
          Times[ 244363.83835609368, 
            Power[ x, 13]], 
          Times[ -767.48583014557596, 
            Power[ x, 14]], 
          Power[ x, 15]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \({2.21666666666666856`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(1074840\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{764, 580},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000003;H8`_n3ohL==`Tf0fL5N`?P0080004/0B`000000]P2:001
0000I00000400`<30?l00BL?00400@2dJ?0000000000060801T1T00000000000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1279, 21, 612, "Subsection"],

Cell[CellGroupData[{
Cell[3013, 74, 154, 4, 68, "Section"],

Cell[CellGroupData[{
Cell[3192, 82, 105, 3, 44, "Subsection"],
Cell[3300, 87, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3399, 93, 131, 4, 44, "Subsection"],
Cell[3533, 99, 71, 1, 27, "Input"],
Cell[3607, 102, 141, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[3773, 108, 141, 2, 27, "Input"],
Cell[3917, 112, 298, 6, 22, "Print"],
Cell[4218, 120, 298, 6, 22, "Print"],
Cell[4519, 128, 326, 7, 38, "Print"],
Cell[4848, 137, 300, 6, 22, "Print"],
Cell[5151, 145, 334, 7, 38, "Print"],
Cell[5488, 154, 306, 6, 22, "Print"],
Cell[5797, 162, 298, 6, 22, "Print"],
Cell[6098, 170, 298, 6, 22, "Print"],
Cell[6399, 178, 326, 7, 38, "Print"],
Cell[6728, 187, 302, 6, 22, "Print"],
Cell[7033, 195, 334, 7, 38, "Print"],
Cell[7370, 204, 308, 6, 22, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[7727, 216, 54, 0, 28, "Subsection"],

Cell[CellGroupData[{
Cell[7806, 220, 142, 2, 43, "Input"],
Cell[7951, 224, 175, 3, 37, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8163, 232, 46, 1, 27, "Input"],
Cell[8212, 235, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8289, 241, 117, 4, 27, "Input"],
Cell[8409, 247, 38, 1, 22, "Print"],
Cell[8450, 250, 332, 7, 38, "Print"],
Cell[8785, 259, 342, 7, 38, "Print"],
Cell[9130, 268, 37, 1, 22, "Print"],
Cell[9170, 271, 334, 7, 38, "Print"],
Cell[9507, 280, 344, 7, 38, "Print"],
Cell[9854, 289, 37, 1, 22, "Print"],
Cell[9894, 292, 342, 7, 38, "Print"],
Cell[10239, 301, 352, 7, 38, "Print"],
Cell[10594, 310, 37, 1, 22, "Print"],
Cell[10634, 313, 336, 7, 38, "Print"],
Cell[10973, 322, 346, 7, 38, "Print"],
Cell[11322, 331, 37, 1, 22, "Print"],
Cell[11362, 334, 350, 7, 38, "Print"],
Cell[11715, 343, 360, 7, 38, "Print"],
Cell[12078, 352, 37, 1, 22, "Print"],
Cell[12118, 355, 342, 7, 38, "Print"],
Cell[12463, 364, 352, 7, 38, "Print"],
Cell[12818, 373, 37, 1, 22, "Print"],
Cell[12858, 376, 358, 7, 38, "Print"],
Cell[13219, 385, 368, 7, 38, "Print"],
Cell[13590, 394, 37, 1, 22, "Print"],
Cell[13630, 397, 344, 7, 38, "Print"],
Cell[13977, 406, 354, 7, 38, "Print"],
Cell[14334, 415, 37, 1, 22, "Print"],
Cell[14374, 418, 356, 7, 38, "Print"],
Cell[14733, 427, 366, 7, 38, "Print"],
Cell[15102, 436, 37, 1, 22, "Print"],
Cell[15142, 439, 38, 1, 22, "Print"],
Cell[15183, 442, 328, 7, 38, "Print"],
Cell[15514, 451, 338, 7, 38, "Print"],
Cell[15855, 460, 37, 1, 22, "Print"],
Cell[15895, 463, 334, 7, 38, "Print"],
Cell[16232, 472, 344, 7, 38, "Print"],
Cell[16579, 481, 37, 1, 22, "Print"],
Cell[16619, 484, 338, 7, 38, "Print"],
Cell[16960, 493, 348, 7, 38, "Print"],
Cell[17311, 502, 37, 1, 22, "Print"],
Cell[17351, 505, 338, 7, 38, "Print"],
Cell[17692, 514, 348, 7, 38, "Print"],
Cell[18043, 523, 37, 1, 22, "Print"],
Cell[18083, 526, 346, 7, 38, "Print"],
Cell[18432, 535, 356, 7, 38, "Print"],
Cell[18791, 544, 37, 1, 22, "Print"],
Cell[18831, 547, 344, 7, 38, "Print"],
Cell[19178, 556, 354, 7, 38, "Print"],
Cell[19535, 565, 37, 1, 22, "Print"],
Cell[19575, 568, 348, 7, 38, "Print"],
Cell[19926, 577, 358, 7, 38, "Print"],
Cell[20287, 586, 37, 1, 22, "Print"],
Cell[20327, 589, 352, 7, 38, "Print"],
Cell[20682, 598, 362, 7, 38, "Print"],
Cell[21047, 607, 37, 1, 22, "Print"],
Cell[21087, 610, 346, 7, 38, "Print"],
Cell[21436, 619, 356, 7, 38, "Print"],
Cell[21795, 628, 37, 1, 22, "Print"],
Cell[21835, 631, 350, 7, 38, "Print"],
Cell[22188, 640, 360, 7, 38, "Print"],
Cell[22551, 649, 37, 1, 22, "Print"],
Cell[22591, 652, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22697, 658, 46, 1, 27, "Input"],
Cell[22746, 661, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[22836, 668, 53, 0, 28, "Subsection"],
Cell[22892, 670, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[23059, 676, 46, 1, 27, "Input"],
Cell[23108, 679, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23186, 685, 116, 4, 27, "Input"],
Cell[23305, 691, 243, 5, 22, "Print"],
Cell[23551, 698, 253, 5, 22, "Print"],
Cell[23807, 705, 37, 1, 22, "Print"],
Cell[23847, 708, 271, 6, 38, "Print"],
Cell[24121, 716, 281, 6, 38, "Print"],
Cell[24405, 724, 37, 1, 22, "Print"],
Cell[24445, 727, 277, 6, 38, "Print"],
Cell[24725, 735, 287, 6, 38, "Print"],
Cell[25015, 743, 37, 1, 22, "Print"],
Cell[25055, 746, 275, 6, 38, "Print"],
Cell[25333, 754, 285, 6, 38, "Print"],
Cell[25621, 762, 37, 1, 22, "Print"],
Cell[25661, 765, 275, 6, 38, "Print"],
Cell[25939, 773, 285, 6, 38, "Print"],
Cell[26227, 781, 37, 1, 22, "Print"],
Cell[26267, 784, 281, 6, 38, "Print"],
Cell[26551, 792, 291, 6, 38, "Print"],
Cell[26845, 800, 37, 1, 22, "Print"],
Cell[26885, 803, 281, 6, 38, "Print"],
Cell[27169, 811, 291, 6, 38, "Print"],
Cell[27463, 819, 37, 1, 22, "Print"],
Cell[27503, 822, 281, 6, 38, "Print"],
Cell[27787, 830, 291, 6, 38, "Print"],
Cell[28081, 838, 37, 1, 22, "Print"],
Cell[28121, 841, 277, 6, 38, "Print"],
Cell[28401, 849, 287, 6, 38, "Print"],
Cell[28691, 857, 37, 1, 22, "Print"],
Cell[28731, 860, 277, 6, 38, "Print"],
Cell[29011, 868, 287, 6, 38, "Print"],
Cell[29301, 876, 37, 1, 22, "Print"],
Cell[29341, 879, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29448, 885, 46, 1, 27, "Input"],
Cell[29497, 888, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[29587, 895, 60, 0, 28, "Subsection"],
Cell[29650, 897, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[29817, 903, 46, 1, 27, "Input"],
Cell[29866, 906, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29944, 912, 84, 1, 27, "Input"],
Cell[30031, 915, 308, 6, 22, "Print"],
Cell[30342, 923, 343, 7, 22, "Print"],
Cell[30688, 932, 470, 12, 38, "Print"],
Cell[31161, 946, 587, 15, 40, "Print"],
Cell[31751, 963, 647, 17, 40, "Print"],
Cell[32401, 982, 815, 22, 40, "Print"],
Cell[33219, 1006, 940, 26, 40, "Print"],
Cell[34162, 1034, 1063, 29, 58, "Print"],
Cell[35228, 1065, 1200, 33, 77, "Print"],
Cell[36431, 1100, 1373, 36, 77, "Print"],
Cell[37807, 1138, 1590, 42, 114, "Print"],
Cell[39400, 1182, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39492, 1188, 46, 1, 27, "Input"],
Cell[39541, 1191, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39643, 1199, 187, 5, 48, "Section"],

Cell[CellGroupData[{
Cell[39855, 1208, 105, 3, 44, "Subsection"],
Cell[39963, 1213, 58, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40058, 1219, 54, 0, 44, "Subsection"],
Cell[40115, 1221, 140, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[40280, 1227, 46, 1, 27, "Input"],
Cell[40329, 1230, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40406, 1236, 125, 4, 27, "Input"],
Cell[40534, 1242, 38, 1, 22, "Print"],
Cell[40575, 1245, 509, 11, 22, "Print"],
Cell[41087, 1258, 525, 12, 22, "Print"],
Cell[41615, 1272, 525, 12, 22, "Print"],
Cell[42143, 1286, 37, 1, 22, "Print"],
Cell[42183, 1289, 509, 11, 22, "Print"],
Cell[42695, 1302, 526, 12, 22, "Print"],
Cell[43224, 1316, 527, 12, 22, "Print"],
Cell[43754, 1330, 37, 1, 22, "Print"],
Cell[43794, 1333, 509, 11, 22, "Print"],
Cell[44306, 1346, 526, 12, 22, "Print"],
Cell[44835, 1360, 527, 12, 22, "Print"],
Cell[45365, 1374, 37, 1, 22, "Print"],
Cell[45405, 1377, 508, 11, 22, "Print"],
Cell[45916, 1390, 526, 12, 22, "Print"],
Cell[46445, 1404, 527, 12, 22, "Print"],
Cell[46975, 1418, 37, 1, 22, "Print"],
Cell[47015, 1421, 509, 11, 22, "Print"],
Cell[47527, 1434, 526, 12, 22, "Print"],
Cell[48056, 1448, 527, 12, 22, "Print"],
Cell[48586, 1462, 37, 1, 22, "Print"],
Cell[48626, 1465, 509, 11, 22, "Print"],
Cell[49138, 1478, 526, 12, 22, "Print"],
Cell[49667, 1492, 527, 12, 22, "Print"],
Cell[50197, 1506, 37, 1, 22, "Print"],
Cell[50237, 1509, 509, 11, 22, "Print"],
Cell[50749, 1522, 526, 12, 22, "Print"],
Cell[51278, 1536, 527, 12, 22, "Print"],
Cell[51808, 1550, 37, 1, 22, "Print"],
Cell[51848, 1553, 509, 11, 22, "Print"],
Cell[52360, 1566, 525, 12, 22, "Print"],
Cell[52888, 1580, 527, 12, 22, "Print"],
Cell[53418, 1594, 37, 1, 22, "Print"],
Cell[53458, 1597, 509, 11, 22, "Print"],
Cell[53970, 1610, 524, 12, 22, "Print"],
Cell[54497, 1624, 526, 12, 22, "Print"],
Cell[55026, 1638, 37, 1, 22, "Print"],
Cell[55066, 1641, 511, 11, 22, "Print"],
Cell[55580, 1654, 528, 12, 22, "Print"],
Cell[56111, 1668, 529, 12, 22, "Print"],
Cell[56643, 1682, 37, 1, 22, "Print"],
Cell[56683, 1685, 511, 11, 22, "Print"],
Cell[57197, 1698, 528, 12, 22, "Print"],
Cell[57728, 1712, 528, 12, 22, "Print"],
Cell[58259, 1726, 37, 1, 22, "Print"],
Cell[58299, 1729, 511, 11, 22, "Print"],
Cell[58813, 1742, 528, 12, 22, "Print"],
Cell[59344, 1756, 529, 12, 22, "Print"],
Cell[59876, 1770, 37, 1, 22, "Print"],
Cell[59916, 1773, 511, 11, 22, "Print"],
Cell[60430, 1786, 528, 12, 22, "Print"],
Cell[60961, 1800, 564, 13, 22, "Print"],
Cell[61528, 1815, 37, 1, 22, "Print"],
Cell[61568, 1818, 511, 11, 22, "Print"],
Cell[62082, 1831, 528, 12, 22, "Print"],
Cell[62613, 1845, 562, 13, 22, "Print"],
Cell[63178, 1860, 37, 1, 22, "Print"],
Cell[63218, 1863, 38, 1, 22, "Print"],
Cell[63259, 1866, 509, 11, 22, "Print"],
Cell[63771, 1879, 526, 12, 22, "Print"],
Cell[64300, 1893, 498, 11, 22, "Print"],
Cell[64801, 1906, 37, 1, 22, "Print"],
Cell[64841, 1909, 508, 11, 22, "Print"],
Cell[65352, 1922, 526, 12, 22, "Print"],
Cell[65881, 1936, 527, 12, 22, "Print"],
Cell[66411, 1950, 37, 1, 22, "Print"],
Cell[66451, 1953, 508, 11, 22, "Print"],
Cell[66962, 1966, 525, 12, 22, "Print"],
Cell[67490, 1980, 527, 12, 22, "Print"],
Cell[68020, 1994, 37, 1, 22, "Print"],
Cell[68060, 1997, 509, 11, 22, "Print"],
Cell[68572, 2010, 526, 12, 22, "Print"],
Cell[69101, 2024, 526, 12, 22, "Print"],
Cell[69630, 2038, 37, 1, 22, "Print"],
Cell[69670, 2041, 509, 11, 22, "Print"],
Cell[70182, 2054, 525, 12, 22, "Print"],
Cell[70710, 2068, 527, 12, 22, "Print"],
Cell[71240, 2082, 37, 1, 22, "Print"],
Cell[71280, 2085, 509, 11, 22, "Print"],
Cell[71792, 2098, 526, 12, 22, "Print"],
Cell[72321, 2112, 527, 12, 22, "Print"],
Cell[72851, 2126, 37, 1, 22, "Print"],
Cell[72891, 2129, 509, 11, 22, "Print"],
Cell[73403, 2142, 526, 12, 22, "Print"],
Cell[73932, 2156, 526, 12, 22, "Print"],
Cell[74461, 2170, 37, 1, 22, "Print"],
Cell[74501, 2173, 508, 11, 22, "Print"],
Cell[75012, 2186, 526, 12, 22, "Print"],
Cell[75541, 2200, 527, 12, 22, "Print"],
Cell[76071, 2214, 37, 1, 22, "Print"],
Cell[76111, 2217, 509, 11, 22, "Print"],
Cell[76623, 2230, 526, 12, 22, "Print"],
Cell[77152, 2244, 527, 12, 22, "Print"],
Cell[77682, 2258, 37, 1, 22, "Print"],
Cell[77722, 2261, 511, 11, 22, "Print"],
Cell[78236, 2274, 528, 12, 22, "Print"],
Cell[78767, 2288, 529, 12, 22, "Print"],
Cell[79299, 2302, 37, 1, 22, "Print"],
Cell[79339, 2305, 510, 11, 22, "Print"],
Cell[79852, 2318, 528, 12, 22, "Print"],
Cell[80383, 2332, 529, 12, 22, "Print"],
Cell[80915, 2346, 37, 1, 22, "Print"],
Cell[80955, 2349, 511, 11, 22, "Print"],
Cell[81469, 2362, 528, 12, 22, "Print"],
Cell[82000, 2376, 529, 12, 22, "Print"],
Cell[82532, 2390, 37, 1, 22, "Print"],
Cell[82572, 2393, 511, 11, 22, "Print"],
Cell[83086, 2406, 527, 12, 22, "Print"],
Cell[83616, 2420, 529, 12, 22, "Print"],
Cell[84148, 2434, 37, 1, 22, "Print"],
Cell[84188, 2437, 509, 11, 22, "Print"],
Cell[84700, 2450, 527, 12, 22, "Print"],
Cell[85230, 2464, 531, 12, 22, "Print"],
Cell[85764, 2478, 37, 1, 22, "Print"],
Cell[85804, 2481, 509, 11, 22, "Print"],
Cell[86316, 2494, 528, 12, 22, "Print"],
Cell[86847, 2508, 562, 13, 22, "Print"],
Cell[87412, 2523, 37, 1, 22, "Print"],
Cell[87452, 2526, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87559, 2532, 46, 1, 27, "Input"],
Cell[87608, 2535, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[87698, 2542, 53, 0, 28, "Subsection"],
Cell[87754, 2544, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[87921, 2550, 46, 1, 27, "Input"],
Cell[87970, 2553, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88048, 2559, 124, 4, 27, "Input"],
Cell[88175, 2565, 402, 10, 22, "Print"],
Cell[88580, 2577, 412, 10, 22, "Print"],
Cell[88995, 2589, 425, 10, 22, "Print"],
Cell[89423, 2601, 37, 1, 22, "Print"],
Cell[89463, 2604, 434, 10, 22, "Print"],
Cell[89900, 2616, 444, 10, 22, "Print"],
Cell[90347, 2628, 425, 10, 22, "Print"],
Cell[90775, 2640, 37, 1, 22, "Print"],
Cell[90815, 2643, 432, 10, 22, "Print"],
Cell[91250, 2655, 444, 10, 22, "Print"],
Cell[91697, 2667, 447, 10, 22, "Print"],
Cell[92147, 2679, 37, 1, 22, "Print"],
Cell[92187, 2682, 434, 10, 22, "Print"],
Cell[92624, 2694, 444, 10, 22, "Print"],
Cell[93071, 2706, 447, 10, 22, "Print"],
Cell[93521, 2718, 37, 1, 22, "Print"],
Cell[93561, 2721, 434, 10, 22, "Print"],
Cell[93998, 2733, 444, 10, 22, "Print"],
Cell[94445, 2745, 446, 10, 22, "Print"],
Cell[94894, 2757, 37, 1, 22, "Print"],
Cell[94934, 2760, 433, 10, 22, "Print"],
Cell[95370, 2772, 444, 10, 22, "Print"],
Cell[95817, 2784, 447, 10, 22, "Print"],
Cell[96267, 2796, 37, 1, 22, "Print"],
Cell[96307, 2799, 434, 10, 22, "Print"],
Cell[96744, 2811, 444, 10, 22, "Print"],
Cell[97191, 2823, 446, 10, 22, "Print"],
Cell[97640, 2835, 37, 1, 22, "Print"],
Cell[97680, 2838, 434, 10, 22, "Print"],
Cell[98117, 2850, 443, 10, 22, "Print"],
Cell[98563, 2862, 447, 10, 22, "Print"],
Cell[99013, 2874, 37, 1, 22, "Print"],
Cell[99053, 2877, 434, 10, 22, "Print"],
Cell[99490, 2889, 444, 10, 22, "Print"],
Cell[99937, 2901, 447, 10, 22, "Print"],
Cell[100387, 2913, 37, 1, 22, "Print"],
Cell[100427, 2916, 434, 10, 22, "Print"],
Cell[100864, 2928, 444, 10, 22, "Print"],
Cell[101311, 2940, 447, 10, 22, "Print"],
Cell[101761, 2952, 37, 1, 22, "Print"],
Cell[101801, 2955, 436, 10, 22, "Print"],
Cell[102240, 2967, 446, 10, 22, "Print"],
Cell[102689, 2979, 449, 10, 22, "Print"],
Cell[103141, 2991, 37, 1, 22, "Print"],
Cell[103181, 2994, 436, 10, 22, "Print"],
Cell[103620, 3006, 446, 10, 22, "Print"],
Cell[104069, 3018, 449, 10, 22, "Print"],
Cell[104521, 3030, 37, 1, 22, "Print"],
Cell[104561, 3033, 435, 10, 22, "Print"],
Cell[104999, 3045, 446, 10, 22, "Print"],
Cell[105448, 3057, 449, 10, 22, "Print"],
Cell[105900, 3069, 37, 1, 22, "Print"],
Cell[105940, 3072, 436, 10, 22, "Print"],
Cell[106379, 3084, 446, 10, 22, "Print"],
Cell[106828, 3096, 448, 10, 22, "Print"],
Cell[107279, 3108, 37, 1, 22, "Print"],
Cell[107319, 3111, 436, 10, 22, "Print"],
Cell[107758, 3123, 446, 10, 22, "Print"],
Cell[108207, 3135, 482, 11, 22, "Print"],
Cell[108692, 3148, 37, 1, 22, "Print"],
Cell[108732, 3151, 69, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108838, 3157, 46, 1, 27, "Input"],
Cell[108887, 3160, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[108977, 3167, 60, 0, 28, "Subsection"],
Cell[109040, 3169, 142, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[109207, 3175, 46, 1, 27, "Input"],
Cell[109256, 3178, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[109334, 3184, 93, 1, 27, "Input"],
Cell[109430, 3187, 485, 11, 22, "Print"],
Cell[109918, 3200, 572, 14, 22, "Print"],
Cell[110493, 3216, 846, 20, 24, "Print"],
Cell[111342, 3238, 1059, 26, 24, "Print"],
Cell[112404, 3266, 1303, 32, 39, "Print"],
Cell[113710, 3300, 1516, 38, 41, "Print"],
Cell[115229, 3340, 1760, 44, 41, "Print"],
Cell[116992, 3386, 1981, 50, 41, "Print"],
Cell[118976, 3438, 2184, 55, 58, "Print"],
Cell[121163, 3495, 2449, 62, 58, "Print"],
Cell[123615, 3559, 2657, 67, 75, "Print"],
Cell[126275, 3628, 2921, 74, 75, "Print"],
Cell[129199, 3704, 3127, 79, 75, "Print"],
Cell[132329, 3785, 3397, 86, 92, "Print"],
Cell[135729, 3873, 3617, 91, 92, "Print"],
Cell[139349, 3966, 3855, 97, 92, "Print"],
Cell[143207, 4065, 70, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[143314, 4071, 46, 1, 27, "Input"],
Cell[143363, 4074, 41, 1, 26, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

