(* :Title: datachv1.m   *)

(* :Context: chebyshev`datachv1` *)

(* :Autor:  Zlia da ROCHA *)

(* :Address: 
            Departamento de Matemtica Aplicada da
            Faculdade de Cincias do Porto
            Rua das Taipas, 135
            4050 Porto
            Portugal
  
            Tel: ++351 02 2080313
            Fax: ++351 02 2004109
            Email: mrdioh@fc.up.pt
*)
(* :Summary:
    The datachv1 package contains the definition form
    that the package chv needs, corresponding to the
    example 1 of the first paper cited bellow.    
*)
(* :Date: July 1999. *)

(* :Available at http://netlib.bell-labs.com/ in the 
    numeralgo library in netlib:       *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 3.0 *)  
 
(* :Keywords: chebyshev's method, recurrence relations, 
              orthogonal polynomials of dimension d,
              d-dimensional forms.
*)
(* :Sources:

 - Z. da Rocha, Shohat-Favard and Chebyshev's
   methods in d-orthogonality, Numerical Algorithms,
   20 (1999) 139-164.
   
 - About the example treated here see p.239 of:
   A. Prudnikov, Orthogonal polynomials with 
   ultra-exponential weight functions, 
   J.Comput.Appl.Math.,48 (1993) 239-241.
*)

(* :Warnings: How to load this package.

This package must be putted in a directory named 
chebyshev. 
Note that the directory containing the chebyshev
directory must be on the file search path $Path.

This package contains the definitions needed in the
package chv.m. 
The context corresponding to this package
(chebyshev`datachv1`) must be written in the 
BeginPackage command of the package chv.m.
Then, when you load the package chv.m doing 
<<chebyshev`chv` or Needs["chebyshev`chv`"] in any
notebook, this package is automatically loaded. 
*)


BeginPackage["chebyshev`datachv1`"]

datachv1::usage="is a package that contains
the definition of:

- the moments of the form with respect to which
  the polynomials are orthogonal (form);
  
corresponding to the example 1 of the paper

Z. da Rocha, Shohat-Favard and Chebyshev's
methods in d-orthogonality, Numerical Algorithms,
20 (1999) 139-164.

The definition form is used in the package chv.m."

form::usage="
form[d, alpha, n] is the moment of order n (n>=0)
of the form of order alpha (1<=alpha<=d), with
respect to which the polynomials are orthogonal
of dimension d.
form is used in the package chv.m."


Begin["`Private`"]

(*___________________________________________

                Error Messages
 __________________________________________*)
   
form::badarg2=
   "wrong value to the second argument
    alpha=`1` in form;
    alpha must be an integer and verify
    1<=alpha<=`2`;
    try again"

form::badarg3=
   "wrong value to the third argument n=`1` in form;
    n must be an integer;
    try again" 

(*___________________________________________

             Exported definition
___________________________________________*)
(*___________________________________________

   the moments of the d-dimensional form
___________________________________________*)

form[d_,alpha_,n_]:=form[d,alpha,n]=

 Block[{},
 (*_________ checking the arguments _________*)
   If[Or[alpha<1,alpha>d,Not[IntegerQ[alpha]]],
    
 	  Return[Message[form::badarg2,alpha,d]]
 	 ];	 
   
   If[Not[IntegerQ[n]],
   
      Return[Message[form::badarg3,n]]
     ];
(*_________________________________________*)
		
 Which[n<0,Return[0],
       n===0,Return[1],
       n>=1, Return[ n*n*form[1,1,n-1] ]
			     ];  (*end of Which *)
			
			
			];(*end of Block*)
(*_____________________________________________*)
   
End[]

EndPackage[]