%/*****************************************************************/
%/*      scalapack_test.m                                         */
%/*      Susan Blackford                                          */
%/*---------------------------------------------------------------*/
%/*****************************************************************/

fprintf(2, '---------------------------------------------------\n')
fprintf(2, 'Testing the NetSolve MATLAB ScaLAPACK interfaces...\n')
fprintf(2, '---------------------------------------------------\n')
fprintf(2, ' \n')
fprintf(2, '---------------------------------------------------\n')
fprintf(2, 'Testing Simple Driver routines for Linear Equations\n')
fprintf(2, '---------------------------------------------------\n')
fprintf(2, '\n** Sending a blocking request for "pdgesv"\n\n')
count = 0;
failcount = 0;
n=50;
a=rand(50);
b=rand(50,1);
[x,z,info]=netsolve('pdgesv',a,b);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r=norm(a*z-b)/(norm(a)*norm(z)*n*eps);
  if ( info~= 0 | r > 50.0 )
    fprintf(2, '** PDGESV Failure **')
    r
    failcount = failcount + 1;
  else
    fprintf(2, '** PDGESV Passed Tests **\n')
  end
end

clear info e
fprintf(2, '\n** Sending a blocking request for "pdposv"\n\n') 
N=20;
C=rand(N);
B=rand(N,5);
A=C*C';
[A1,X,info]=netsolve('pdposv','U',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r1=norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  if ( info~= 0 | r1 > 50.0 )
    fprintf(2, '** PDPOSV(U) Failure **')
    failcount = failcount + 1;
    r
  else
    fprintf(2, '** PDPOSV(U) Passed Tests **\n')
  end
end

clear N C B A A1 X info e
N=20;
C=rand(N);
B=rand(N,5);
A=C*C';
[A1,X,info]=netsolve('pdposv','L',A,B);
[e] = netsolve_err;
count = count + 1;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
  failcount = failcount + 1;
else
  r2=norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  if ( info~= 0 | r2 > 50.0 )
    fprintf(2, '** PDPOSV(L) Failure **')
    failcount = failcount + 1;
    r
  else
    fprintf(2, '** PDPOSV(L) Passed Tests **\n')
  end
end

if (failcount ~= 0)
   fprintf(2, '\n ** %d tests of %d failed **\n\n', failcount, count)
else
   fprintf(2, '\n ** All tests passed **\n')
end
