fprintf(2, '\n** Sending a blocking request for "dsbevx"\n\n')
clear
N=20;
C1=rand(N);
KL=4;
KU=3;
B=rand(N,5);
for i=1:N
  for j=max(1,i-KL):min(N,i+KU)
        C2(i,j)=C1(i,j);
  end
end
KD=KL+KU;
A=C2+C2';
for j=1:N
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[AB1,Q,m,W,Z,ifail,info]=netsolve('dsbevx','V','A','U',KD,AB1,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  rr=max(r1);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVX(V,A,U) Failure **')
    rr
  else
    fprintf(2, '** DSBEVX(V,A,U) Passed Tests **\n')
  end
end

clear Q m W Z ifail info
for j=1:N
  for i=j:min(N,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
[AB2,Q,m,W,Z,ifail,info]=netsolve('dsbevx','V','A','L',KD,AB2,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  clear rr
  rr=max(r2);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVX(V,A,L) Failure **')
    rr
  else
    fprintf(2, '** DSBEVX(V,A,L) Passed Tests **\n')
  end
end
