fprintf(2, '\n** Sending a blocking request for "dgtsv"\n\n')
clear
B=rand(5,1);
C=rand(5);
DL=diag(C,-1);
D=diag(C);
DU=diag(C,1);
A=diag(D)+diag(DL,-1)+diag(DU,1);
[DL,D,DU,X,info]=netsolve('dgtsv',DL,D,DU,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r=norm(A*X-B)/(norm(A)*norm(X)*5*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGTSV Failure **')
    r
  else
    fprintf(2, '** DGTSV Passed Tests **\n')
  end
end
