%/*****************************************************************/
%/*      blas_test.m                                              */
%/*      Victor Eijkhout                                          */
%/*---------------------------------------------------------------*/
%/*****************************************************************/

test_dgemm=1;
test_zgemm=1;
test_dmatmul=1;
test_zmatmul=1;
test_daxpy=1;
test_zaxpy=1;
test_ddot=1;

testsizes = [1,5,12,37];
%
% dgemm
%
if test_dgemm==1,
 alpha = rand; beta = rand;  
 for size=testsizes,
  fprintf('Testing DGEMM for size %d\n',size);
  A = rand(size); B = rand(size); C = rand(size);
  for transa=['n','t'],
   if transa=='t', opA = A'; else, opA = A; end;
   for transb=['n','t'],
    if transb=='t', opB = B'; else, opB = B; end;
    fprintf('..case %s %s:\n',transa,transb);
    [Cn] = netsolve('dgemm',transa,transb,alpha,A,B,beta,C);
    [e] = netsolve_err;
    if (e ~= 0)
      fprintf(2,'%s\n',netsolve_errmsg(e))
    else
      Cm = alpha*opA*opB+beta*C;
      error = norm(Cn-Cm);
      if(error>15.0)
        fprintf(' residual is %e\n',error);
      else
        fprintf(' Test passed.\n');
      end;
    end;
   end;
  end;
 end;
end;

% 
% zgemm
%
if test_zgemm==1,
 clear i
 alpha = rand+i*rand; beta = rand+i*rand;
 for size=testsizes,
  fprintf('Testing ZGEMM for size %d\n',size);
  A = rand(size)+i*rand(size); B = rand(size)+i*rand(size);
  C = rand(size)+i*rand(size);
  for transa=['n','t','c'],
   if transa=='t', opA = conj(A'); elseif transa=='c', opA = A';
     else, opA = A; end;
   for transb=['n','t','c'],
    if transb=='t', opB = conj(B'); elseif transb=='c', opB = B';
     else, opB = B; end;
    fprintf('..case %s %s:\n',transa,transb);
    [Cn] = netsolve('zgemm',transa,transb,alpha,A,B,beta,C);
    [e] = netsolve_err;
    if (e ~= 0)
      fprintf(2,'%s\n',netsolve_errmsg(e))
    else
      Cm = alpha*opA*opB+beta*C;
      error = norm(Cn-Cm);
      if(error>15.0)
        fprintf(' residual is %e\n',error);
      else
        fprintf(' Test passed.\n');
      end;
    end;
   end;
  end;
 end;
end;

%
% dmatmul
%
if test_dmatmul==1,
 for size=testsizes,
  fprintf('Testing DMATMUL for size %d:\n',size);
  A = rand(size); B = rand(size);
  [Cn] = netsolve('dmatmul',A,B);
  [e] = netsolve_err;
  if (e ~= 0)
    fprintf(2,'%s\n',netsolve_errmsg(e))
  else
    Cm = A*B;
    error = norm(Cn-Cm);
    if(error>15.0)
      fprintf(' residual is %e\n',error);
    else
      fprintf(' Test passed.\n');
    end;
  end;
 end;
end;

%
% zmatmul
%
if test_zmatmul==1,
 for size=testsizes,
  fprintf('Testing ZMATMUL for size %d:\n',size);
  clear i
  A = rand(size)+i*rand(size); B = rand(size)+i*rand(size);
  [Cn] = netsolve('zmatmul',A,B);
  [e] = netsolve_err;
  if (e ~= 0)
    fprintf(2,'%s\n',netsolve_errmsg(e))
  else
    Cm = A*B;
    error = norm(Cn-Cm);
    if(error>15.0)
      fprintf(' residual is %e\n',error);
    else
      fprintf(' Test passed.\n');
    end;
  end;
 end;
end;

%
% daxpy
%
if test_daxpy==1,
 for size=testsizes,
  fprintf('Testing DAXPY for size %d\n',size);
  if size==1, xrange=1; yrange=1;
   else, xrange = 1:3:size/2; yrange = 1:5:2*size/3; end;
%xrange=1; yrange=1;
  for incx=xrange;
   for incy=yrange,
    nx = 1+floor((size-1)/incx); ny = 1+floor((size-1)/incy);
    n = min(nx,ny); %len = 1+max(n*incx,n*incy);
    x = rand(size,1); y = rand(size,1); alpha = rand; alpha=1;
    zn = netsolve('daxpy',n,alpha,x,incx,y,incy);
    [e] = netsolve_err;
    if (e ~= 0)
      fprintf(2,'%s\n',netsolve_errmsg(e))
    else
      zm = y; zm(1+incy*(0:n-1)) = y(1+incy*(0:n-1)) + alpha*x(1+incx*(0:n-1));
      err = norm(zn-zm);
      if err>15.0, fprintf('incx=%d incy=%d, residual norm=%e\n',incx,incy,err);
       else,
         fprintf(' Test passed.\n');
       end;
    end;
   end;
  end;
 end;
end;

%
% zaxpy
%
if test_zaxpy==1,
 for size=testsizes,
  fprintf('Testing ZAXPY for size %d\n',size);
  if size==1, xrange=1; yrange=1;
   else, xrange = 1:3:size/2; yrange = 1:5:2*size/3; end;
xrange=1; yrange=1;
  for incx=xrange;
   for incy=yrange,
    nx = round(size/incx); ny = round(size/incy);
    n = min(nx,ny); len = max(n*incx,n*incy);
    clear i
    x = rand(len,1)+i*rand(len,1); y = rand(len,1)+i*rand(len,1);
    alpha = rand+i*rand;
    zn = netsolve('zaxpy',n,alpha,x,incx,y,incy);
    [e] = netsolve_err;
    if (e ~= 0)
      fprintf(2,'%s\n',netsolve_errmsg(e))
    else
      zm = y; zm(1+incy*(0:n-1)) = y(1+incy*(0:n-1)) + alpha*x(1+incx*(0:n-1));
      err = norm(zn-zm);
      if (err>15.0)
        fprintf('incx=%d incy=%d, residual norm=%e\n',incx,incy,err);
      else
        fprintf(' Test passed.\n');
      end;
    end;
   end;
  end;
 end;
end;

%
% ddot
%
if test_ddot==1,
 for size=testsizes,
  fprintf('Testing DDOT for size %d\n',size);
  if size==1, xrange=1; yrange=1;
   else, xrange = 1:3:size/2; yrange = 1:5:2*size/3; end;
%xrange=1; yrange=1;
  for incx=xrange;
   for incy=yrange,
    nx = round(size/incx); ny = round(size/incy);
    n = min(nx,ny); len = max(n*incx,n*incy);
    x = rand(len,1); y = rand(len,1);
    zn = netsolve('ddot',n,x,incx,y,incy);
    [e] = netsolve_err;
    if (e ~= 0)
      fprintf(2,'%s\n',netsolve_errmsg(e))
    else
      zm = y; zm(1+incy*(0:n-1)) = y(1+incy*(0:n-1))'*x(1+incx*(0:n-1));
      err = norm(zn-zm);
      if (err>15.0)
        fprintf('incx=%d incy=%d, residual norm=%e\n',incx,incy,err);
      else
        fprintf(' Test passed.\n');
      end;
    end;
   end;
  end;
 end;
end;
