function cmd_display_click

global iter_max iter_min iter;
global steps_max steps_min steps;

global guiwin;
global mandelwin;
global cframe;

global stxt_iter slider_iter txt_iter;
global stxt_steps slider_steps txt_steps;

global stxt_zoom pop_zoom;
global stxt_blocks pop_blocks;
global stxt_requests pop_requests;

global zoom_choices blocks_choices requests_choices;

global cmd_display cmd_reset cmd_quit;

global xmax xmin ymax ymin;

global x y;

xwidth = xmax - xmin;
ywidth = ymax - ymin;

zoom = get(pop_zoom,'value');
switch (zoom)
case 1
zoom_factor = 16;
case 2
zoom_factor = 8;
case 3
zoom_factor = 4;
case 4
zoom_factor = 2;
case 5
zoom_factor = 1;
case 6
zoom_factor = 1/2;
case 7
zoom_factor = 1/4;
case 8
zoom_factor = 1/8;
case 9
zoom_factor = 1/16;
end

block_factor = get(pop_blocks,'value');

request_factor = get(pop_requests,'value');

xmax = x + ((xwidth/zoom_factor) / 2);
xmin = x - ((xwidth/zoom_factor) / 2);
ymax = y + ((ywidth/zoom_factor) / 2);
ymin = y - ((ywidth/zoom_factor) / 2);

xstep = (xmax - xmin) / steps;
ystep = (ymax - ymin) / steps;

set(guiwin,'pointer','watch');
set(mandelwin,'pointer','watch');
NSmandelbrot(xmin,xstep,xmax,ymin,ystep,ymax,iter,block_factor,request_factor);
set(mandelwin,'pointer','arrow');
set(guiwin,'pointer','arrow');




