#
# Makefile for the Netsolve Win32 C Test applications
#
# C_test.exe is a standalone application
# C_testdll.exe requires netsolve.dll and uses implicit linkage
# C_testdlle.exe requires netsolve.dll and uses explicit linkage
#
# libnetsolve.lib is used for static linkage in C_test.exe
# netsolve.lib is used as an import library for netsolve.dll in C_testdll.exe

# Root directory for Microsoft Visual C++ files
MSDIR = c:\progra~1\devstudio\vc
MSINC = $(MSDIR)\include
MSLIB = $(MSDIR)\lib

# Link libraries
LIBS =  $(MSLIB)\kernel32.lib \
	$(MSLIB)\libc.lib \
	$(MSLIB)\oldnames.lib \
	$(MSLIB)\user32.lib \
	$(MSLIB)\gdi32.lib \
	$(MSLIB)\winspool.lib \
	$(MSLIB)\comdlg32.lib \
	$(MSLIB)\advapi32.lib \
	$(MSLIB)\shell32.lib \
	$(MSLIB)\ole32.lib \
	$(MSLIB)\oleaut32.lib \
	$(MSLIB)\uuid.lib \
	$(MSLIB)\odbc32.lib \
	$(MSLIB)\odbccp32.lib \
	$(MSLIB)\wsock32.lib
 
# Build everything by default
all: C_test.exe C_testdll.exe C_testdlle.exe

# Build C_test.exe - standalone exe
C_test.exe: testing\C_test.obj libnetsolve.lib
	$(CC) /nologo testing\C_test.obj libnetsolve.lib $(LIBS) /Fe$@

# Build C_testdll.exe - netsolve.dll must be present for this exe to work
C_testdll.exe: testing\C_test.obj netsolve.lib
	$(CC) /nologo testing\C_test.obj netsolve.lib $(LIBS) /Fe$@
	
# Build C_testdlle.exe - use explicit linkage
C_testdlle.exe: testing\C_testdlle.obj
	$(CC) /nologo testing\C_testdlle.obj $(LIBS) /Fe$@
	
# Rule to compile C_test.c
testing\C_test.obj: testing\C_test.c
	$(CC) /nologo /c /I $(MSINC) /I includes /DWIN32 /Fo$(@R).obj  $*.c

# Rule to compile C_testdlle.c
testing\C_testdlle.obj: testing\C_testdlle.c
	$(CC) /nologo /c /I $(MSINC) /I includes /DWIN32DLL /DWIN32 /Fo$(@R).obj $*.c

# Clean up object files
clean:
	del testing\C_test.obj
	del testing\C_testdlle.obj
