#
# Makefile for the Netsolve Win32 MatLab Client
#

# Root directories for MatLab and Microsoft Visual C++ files
MLDIR = c:\matlab
MSDIR = c:\progra~1\devstudio\vc
MSINC = $(MSDIR)\include
MSLIB = $(MSDIR)\lib

# Define MatLab Mex compiler
MEX = $(MLDIR)\bin\mex

# MatLab client object files
MATLAB_OBJS = matlab\mxdisplaylistofproblems.obj \
	matlab\mxdisplaylistofserversagents.obj \
	matlab\mxdisplayobject.obj \
	matlab\mxdisplayproblemdesc.obj \
	matlab\mxdisplayrequeststatus.obj \
	matlab\mxfillinoutputobjects.obj \
	matlab\mxinitializeinputobjects.obj \
	matlab\mxinitializeoutputobjects.obj \
	matlab\mxrequestdesc.obj \
	matlab\mxsendnonblockingrequest.obj \
	matlab\mxseterrno.obj \
	matlab\mxstrdup.obj \
	matlab\mxwaitprobenonblockingrequest.obj

# Client core object files
CLIENT_CORE_OBJS = clientcore\clientutil.obj \
	clientcore\major.obj \
	clientcore\netsolveblocking.obj \
	clientcore\netsolvesendrequest.obj \
	clientcore\netsolvewaitproberequest.obj \
	clientcore\win_util.obj
					
# Netsolve core object files
CORE_OBJS = core\agentdesc.obj \
	core\communicator.obj \
	core\expressions.obj \
	core\general.obj \
	core\historydesc.obj \
	core\hostdesc.obj \
	core\linkedlist.obj \
	core\mnemonics.obj \
	core\netsolveerror.obj \
	core\netsolveutil.obj \
	core\problemdesc.obj \
	core\requestdesc.obj \
	core\restrictiondesc.obj \
	core\serverdesc.obj \
	core\socketutil.obj
	
# XDR object files
XDR_OBJS = xdr\xdr.obj \
	xdr\xdr_array.obj \
	xdr\xdr_float.obj \
	xdr\xdr_memory.obj \
	xdr\xdr_rec.obj \
	xdr\xdr_reference.obj \
	xdr\xdr_socket.obj \
	xdr\xdr_stdio.obj
	
# Object files MatLab clients
M_OBJS = $(MATLAB_OBJS) $(CLIENT_CORE_OBJS) $(CORE_OBJS) $(XDR_OBJS)

# Link libraries
LIBS = $(MSLIB)\kernel32.lib \
	$(MSLIB)\libc.lib \
	$(MSLIB)\oldnames.lib \
	$(MSLIB)\user32.lib \
	$(MSLIB)\gdi32.lib \
	$(MSLIB)\winspool.lib \
	$(MSLIB)\comdlg32.lib \
	$(MSLIB)\advapi32.lib \
	$(MSLIB)\shell32.lib \
	$(MSLIB)\ole32.lib  \
	$(MSLIB)\oleaut32.lib \
	$(MSLIB)\uuid.lib \
	$(MSLIB)\odbc32.lib \
	$(MSLIB)\odbccp32.lib \
	$(MSLIB)\wsock32.lib
 
# Build everything by default
all: netsolve.dll netsolve_nb.dll netsolve_err.dll netsolve_errmsg.dll

# Build netsolve.dll
netsolve.dll: matlab\mxnetsolve.obj $(M_OBJS)
	$(MEX) -g matlab\mxnetsolve.obj $(M_OBJS) $(LIBS) -output matlab\netsolve

# Build netsolve_errmsg.dll
netsolve_errmsg.dll: matlab\mxnetsolve_errmsg.obj $(M_OBJS)
	$(MEX) -g matlab\mxnetsolve_errmsg.obj $(M_OBJS) $(LIBS) -output matlab\netsolve_errmsg

# Build netsolve_err.dll
netsolve_err.dll: matlab\mxnetsolve_err.obj $(M_OBJS)
	$(MEX) -g matlab\mxnetsolve_err.obj $(M_OBJS) $(LIBS) -output matlab\netsolve_err

# Build netsolve_nb.dll
netsolve_nb.dll: matlab\mxnetsolve_nb.obj $(M_OBJS)
	$(MEX) -g matlab\mxnetsolve_nb.obj $(M_OBJS) $(LIBS) -output matlab\netsolve_nb

# Rule to compile all .c files
.c.obj:
	$(MEX) -g -c -I$(MSINC) -I$(MLDIR)\extern\include -Iincludes -DMATLAB -DWIN32 -DVIEW $*.c
	copy $(@B).obj $*.obj
	del $(@B).obj

# Clean up object files
clean:
	del $(M_OBJS)
