#
# Makefile for the Netsolve Win32 C Client (DLL Version)
#
# Note: libnetsolve.lib is used for static linkage
#       netsolve.dll is used for dynamic linkage
#       netsolve.lib is an import library for netsolve.dll

# Root directory for Microsoft Visual C++ files
MSDIR = c:\progra~1\devstudio\vc
MSINC = $(MSDIR)\include
MSLIB = $(MSDIR)\lib

# C client object files
CLIENT_OBJS = client\callingsequence.obj \
	client\netsl.obj \
	client\netslerr.obj \
	client\netslmajor.obj \
	client\netslnb.obj \
	client\netslnbX.obj \
	client\netslpr.obj \
	client\netslwt.obj \
	client\netslX.obj \
	client\netsolvedll.obj
					
# Client core object files
CLIENT_CORE_OBJS = clientcore\clientutil.obj \
	clientcore\major.obj \
	clientcore\netsolveblocking.obj \
	clientcore\netsolvesendrequest.obj \
	clientcore\netsolvewaitproberequest.obj \
	clientcore\win_util.obj
					
# Netsolve core object files
CORE_OBJS = core\agentdesc.obj \
	core\communicator.obj \
	core\expressions.obj \
	core\general.obj \
	core\historydesc.obj \
	core\hostdesc.obj \
	core\linkedlist.obj \
	core\mnemonics.obj \
	core\netsolveerror.obj \
	core\netsolveutil.obj \
	core\problemdesc.obj \
	core\requestdesc.obj \
	core\restrictiondesc.obj \
	core\serverdesc.obj \
	core\socketutil.obj
	
# Farming object files
FARMING_OBJS = farming\constructiteratorarray.obj \
	farming\generatearrayfromiterators.obj \
	farming\iterator.obj \
	farming\netsl_farm.obj \
	farming\netsl_farmX.obj \
	farming\pollfarmedrequest.obj \
	farming\sendfarmedrequest.obj
	
# XDR object files
XDR_OBJS = xdr\xdr.obj \
	xdr\xdr_array.obj \
	xdr\xdr_float.obj \
	xdr\xdr_memory.obj \
	xdr\xdr_rec.obj \
	xdr\xdr_reference.obj \
	xdr\xdr_socket.obj \
	xdr\xdr_stdio.obj
	
# Object files for C and MatLab clients
C_OBJS = $(CLIENT_OBJS) $(CLIENT_CORE_OBJS) $(CORE_OBJS) $(FARMING_OBJS) $(XDR_OBJS)

# Link libraries
LIBS = $(MSLIB)\kernel32.lib \
	$(MSLIB)\libc.lib \
	$(MSLIB)\oldnames.lib \
	$(MSLIB)\user32.lib \
	$(MSLIB)\gdi32.lib \
	$(MSLIB)\winspool.lib \
	$(MSLIB)\comdlg32.lib \
	$(MSLIB)\advapi32.lib \
	$(MSLIB)\shell32.lib \
	$(MSLIB)\ole32.lib \
	$(MSLIB)\oleaut32.lib  \
	$(MSLIB)\uuid.lib \
	$(MSLIB)\odbc32.lib \
	$(MSLIB)\odbccp32.lib \
	$(MSLIB)\wsock32.lib
 
# Build everything by default
all: libnetsolve.lib netsolve.dll

# Build libnetsolve.lib
libnetsolve.lib: $(C_OBJS)
	lib /nologo $(C_OBJS) /out:$@
	
# Build netsolve.dll - this also generates the import library netsolve.lib
netsolve.dll: $(C_OBJS)
	link /nologo /dll /def:client\netsolvedll.def $(C_OBJS) $(LIBS) /out:$@
	
# Rule to compile all .c files
.c.obj:
	$(CC) /nologo /c /I $(MSINC) /I includes /DWIN32 /DVIEW /Fo$(@R).obj  $*.c

# Clean up object files
clean:
	del $(C_OBJS)
