/*****************************************************************/
/*      netsolvekillserver.c                                     */
/*      Henri Casanova, Dorian Arnold           			   	 */
/*****************************************************************/

#include <netdb.h>
#include <unistd.h>
#include <sys/types.h>
#include "core.h"
#include "client.h"

/*
 * Kill a server
 */
int main(int argc, char **argv)
{
  int sock;
  NS_Communicator *comm;
  char *username;
  char *hostname;
  NS_IPaddr_type IPaddr;
  int status;
  struct hostent *hp;

  if (argc != 3)
  {
    fprintf(stderr,"Usage: %s <agent hostname> <server hostname>\n",argv[0]);
    exit(-1);
  }

  username = getUserName();
  if (username == NULL)
  {
    exit(-1);
  }

  hostname = getHostName();
  if (hostname == NULL)
  {
    exit(-1);
  }

  /* determining the IPaddr */
  hp = gethostbyname(argv[2]);
  if (hp == NULL)
  {
    fprintf(stderr,"Cannot resolve hostname '%s'\n",argv[2]);
    free(username);
    exit(-1);
  }

  BCOPY(hp->h_addr_list[0],
        (void*)&IPaddr,sizeof(NS_IPaddr_type));

  sock = connectToSocket(argv[1],0,AGENT_PORT);
  if (sock == -1)
  {
    netsolvePerror("connectToSocket()");
    free(username);
    exit(-1);
  }

  comm = initTransaction(sock,DATA_XDR);
  if (comm == NULL)
  {
    netsolvePerror("initTransaction()");
    free(username);
    exit(-1);
  }

  if (sendInt(comm,NS_PROT_KILL_SERVER) == -1)
  {
    netsolvePerror("sendInt()");
    free(username);
    exit(-1);
  }
  if (sendIPaddr(comm,&IPaddr) == -1)
  {
    netsolvePerror("sendIPaddr()");
    free(username);
    exit(-1);
  }

  if (sendString(comm,username) == -1)
  {
    netsolvePerror("sendString()");
    free(username);
    exit(-1);
  }

  if (sendString(comm,hostname) == -1)
  {
    netsolvePerror("sendString()");
    free(username);
    exit(-1);
  }

  if (recvInt(comm,&status) == -1)
  {
    netsolvePerror("recvInt()");
    free(username);
    exit(-1);
  }

  endTransaction(comm);

  free(username);
 
  switch(status)
  {
    case NS_PROT_KILLED:
      fprintf(stderr,"Server on %s: killed\n",argv[2]);
      break;
    case NS_PROT_NOT_ALLOWED:
      fprintf(stderr,"Server on %s: no permission to kill\n",argv[2]);
      break;
    default:
      fprintf(stderr,"Server on %s: failure\n",argv[2]);
      break;
  }

  exit(0);
}
