/*****************************************************************/
/*      netsolveconfig.c                                         */
/*      Henri Casanova          			   	 */
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "proxyjobdesc.h"
#include "proxy.h"

/*
 * Displays the list of available servers and agents
 */
int main(int argc, char **argv)
{
  NS_ServerDesc **server_list;
  NS_AgentDesc **agent_list;
  int nb_servers;
  int nb_agents;
  int i;
  int proxy_pid=0;

  if (argc != 2)
  {
    fprintf(stderr,"Usage: %s <agent hostname>\n",argv[0]);
    exit(-1);
  }

  /* Starting the proxy */
  if (startProxy("NetSolve",argv[1],&proxy_pid,&proxy_port) == -1)
  {
    fprintf(stderr,"Error while starting the proxy\n");
    exit(-1);
  }

  nb_agents = getAllAgents(&agent_list);

  /* Error */
  if (nb_agents == -1)
  {
    netsolvePerror("getAllAgents()");
    exit(-1);
  }

  /* sorting the list */
  qsort(agent_list,nb_agents,sizeof(NS_AgentDesc *),agentOrder);

  /* Printing the list */
  for (i=0;i<nb_agents;i++)
  {
    fprintf(stdout,"AGENT: %s (%u.%u.%u.%u)\n",agent_list[i]->host_desc->hostname,
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),0), 
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),1), 
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),2), 
                                  BYTE(&(agent_list[i]->host_desc->IPaddr),3));
  }

  for (i=0;i<nb_agents;i++)
    freeAgentDesc(agent_list[i]);
  free(agent_list);

  nb_servers = getAllServers(&server_list);

  /* Error */
  if (nb_servers == -1)
  {
    netsolvePerror("getAllServers()");
    exit(-1);
  }

  /* sorting the list */
  qsort(server_list,nb_servers,sizeof(NS_ServerDesc *),serverOrder);

  /* Printing the list */
  for (i=0;i<nb_servers;i++)
  {
    fprintf(stdout,"SERVER: %s (%u.%u.%u.%u) (%d failures)\n",
                                  server_list[i]->host_desc->hostname,
                                  BYTE(&(server_list[i]->host_desc->IPaddr),0),
                                  BYTE(&(server_list[i]->host_desc->IPaddr),1),
                                  BYTE(&(server_list[i]->host_desc->IPaddr),2),
                                  BYTE(&(server_list[i]->host_desc->IPaddr),3),
                                  server_list[i]->nb_failures);
  }
  for (i=0;i<nb_servers;i++)
    freeServerDesc(server_list[i]);
  free(server_list);

  exit(0);
}
