
(****************** NSblastest.m *********************)

NSTestPause[] := Module[{s},
   s = InputString["Type 'q' to exit from this test or hit Enter to continue: "];
   Return[s == "q"]
]

NSnorm[V_]:= Module[{},
   If[(MatrixQ[V]||VectorQ[V]),Return[Max[SingularValues[V][[2]]]],NULL];
   
] 



(* ************* dgemm *************** *)
NSTestdgemm[]:= Module[{},
Print["----------------"];
Print["Testing dgemm..."];
Print["----------------"];
alpha = Random[];
beta = Random[];
For[i=1,i<5,i++,size=TestSize[[i]];
    Print["**************************"];
    Print["Testing dgemm for size ",size];
    Print["**************************"];
     A = Table[Random[],{xx,size},{yy,size}];
     B = Table[Random[],{xx,size},{yy,size}];
     CC= Table[Random[],{xx,size},{yy,size}];
     For[j=1,j<4,j++,
        transa=NTC[[j]];
        Switch[transa,t,opA=Transpose[A],c,opA=Transpose[A],n,opA=A];
          For[k=1,k<4,k++,    
             transb=NTC[[k]];
           Switch[transb,t,opB=Transpose[B],c,opB=Transpose[B],n,opB=B];
             Print["...case ",transa," ",transb];
             Cn=NetSolve[dgemm[ToString[transa],ToString[transb],alpha,A,B,beta,CC]];
             Cm=alpha*opA.opB+beta*CC;
             Print["Residual is ",NSnorm[Cn-Cm]]
             ];      
         ]; 
     ];
Return[NSTestPause[]]
     ]    


(* ************** zgemm ****************** *)

 NSTestzgemm[]:= Module[{},
 Print["----------------"];
 Print["Testing zgemm..."];
 Print["----------------"];
 ClearAll[size,i,j,k,alpha,beta,xx,yy,A,B,CC,NTC,transa,transb,opA,opB,Cn,Cm];
 alpha = Random[] + Random[] I;
 beta = Random[] + Random[] I;
NTC = {n,t,c};
For[i=1,i<5,i++,size=TestSize[[i]];
     Print["**************************"];
     Print["Testing zgemm for size ",size];
     Print["**************************"];
     A = Table[Random[],{xx,size},{yy,size}] + Table[Random[],{xx,size},{yy,size}]I;
     B = Table[Random[],{xx,size},{yy,size}] + Table[Random[],{xx,size},{yy,size}]I;
     CC = Table[Random[],{xx,size},{yy,size}] + Table[Random[],{xx,size},{yy,size}]I;
     For[j=1,j<4,j++,
          transa=NTC[[j]];
          Switch[transa,c,opA=Conjugate[Transpose[A]],t,opA=Transpose[A],n,opA=A];
          For[k=1,k<4,k++,
             transb=NTC[[k]];
             Switch[transb,c,opB=Conjugate[Transpose[B]],t,opB=Transpose[B],n,opB=B];
             Print["...case ",transa," ",transb];
             Cn=NetSolve[zgemm[ToString[transa],ToString[transb],alpha,A,B,beta,CC]];
             Cm=alpha*opA.opB+beta*CC;
             Print["Residual is ",NSnorm[Cn-Cm]]
             ];
         ];
     ];
Return[NSTestPause[]]
]


(* *************** dmatmul *************** *)
NSTestdmatmul := Module[{},
  Print["------------------"];
  Print["Testing dmatmul..."];
  Print["------------------"];
  ClearAll[size,i,xx,yy,A,B,Cn,Cm];
  For[i=1,i<5,i++,size=TestSize[[i]];
  Print["**************************"];
  Print["Testing dmatmul for size ",size];
  Print["**************************"];
  A = Table[Random[],{xx,size},{yy,size}];
  B = Table[Random[],{xx,size},{yy,size}];
  Cn= NetSolve[dmatmul[A,B]];
  Cm= A.B;
  Print["Residule is ",NSnorm[Cn-Cm],"\n"]
     ];  
Return[NSTestPause[]]
]

(* *************** zmatmul *************** *)
NSTestzmatmul := Module[{},
  Print["------------------"];
  Print["Testing zmatmul..."];
  Print["------------------"];
  ClearAll[size,i,xx,yy,A,B,Cn,Cm];
  For[i=1,i<5,i++,size=TestSize[[i]];
  Print["**************************"];
  Print["Testing zmatmul for size ",size];
  Print["**************************"];
  A = Table[Random[],{xx,size},{yy,size}] + Table[Random[],{xx,size},{yy,size}] I;
  B = Table[Random[],{xx,size},{yy,size}] + Table[Random[],{xx,size},{yy,size}] I;
  Cn= NetSolve[zmatmul[A,B]];
  Cm= A.B;
  Print["Residual is ",NSnorm[Cn-Cm],"\n"]
     ];
Return[NSTestPause[]]
]


(* ************* daxpy ***************** *)
NSTestdaxpy := Module[{},
 Print["-----------------"];
 Print["Testing daxpy ..."];
 Print["-----------------"];
 ClearAll[size,i,j,k,ii,xx,a,b,xrange,yrange,incx,incy,n,x,y,alpha,zn,zm,err];
 ClearAll[nm,llen,s,jj];
 Print["**************************"];
 Print["Testing daxpy for size 1..."];
 Print["**************************"];
 xrange=1;
 yrange=1;
 incx=1;
 incy=1;
 n=1;
 x = Table[Random[],{xx,1}];
 y = Table[Random[],{xx,1}];
 alpha=Random[];
 zn=NetSolve[daxpy[n,alpha,x,1,y,1]];
 zm=y+alpha*x;
 err=zn-zm;
 Print["incx= ",incx,", incy= ",incy,", err norm= ",err];
  
 For[i=2,i<5,i++,size=TestSize[[i]];
     Print["\n**************************"];
     Print["Testing daxpy for size ",size];
     Print["**************************"];
       xrange=Range[1,size/2,3];
       yrange=Range[1,2*size/3,5];
       a=Length[xrange]; 
       b=Length[yrange];
       For[j=1,j<a+1,j++,
          incx=xrange[[j]];
          For[k=1,k<b+1,k++,
            incy=yrange[[k]];
            nx = 1 + Floor[(size-1)/incx];
            ny = 1 + Floor[(size-1)/incy];
             n = Min[nx,ny];
             x = Table[Random[],{xx,size}];
             y = Table[Random[],{xx,size}];
         alpha = Random[];
            zn = NetSolve[daxpy[n,alpha,x,incx,y,incy]];
            zm = y;
          For[ii=0,ii<n,ii++,
             zm[[1+incy*ii]] = y[[1+incy*ii]] + alpha*x[[1+incx*ii]]
             ];
          nm=zn-zm;
          llen=Length[nm];
          For[jj=1;s=0,jj<llen+1,jj++,
              s=s+nm[[jj]]^2;
             ];
          err=Sqrt[s];
          Print["incx= ",incx,", incy= ",incy,", err norm= ",err]
              ];
            ];
           
    ];
Return[NSTestPause[]]

] 



(* ************* zaxpy ***************** *)
NSTestzaxpy := Module[{},
 Print["-----------------"];
 Print["Testing zaxpy ..."];
 Print["-----------------"];
 ClearAll[size,i,j,k,ii,xx,yy,len,a,b,xrange,yrange,incx,incy,n,x,y,alpha,zn,zm,err];
 ClearAll[nm,llen,s,jj];
 Print["\n**************************"];
 Print["Testing zaxpy for size 1..."];
 Print["**************************"];
 xrange=1;
 yrange=1;
 incx=1;
 incy=1;
 n=1;
 x = Table[Random[],{xx,1}]+Table[Random[],{yy,1}]I;
 y = Table[Random[],{xx,1}]+Table[Random[],{yy,1}]I;
 alpha=Random[]+Random[]I;
 zn=NetSolve[zaxpy[n,alpha,x,1,y,1]];
 zm=y+alpha*x;
 err=zn-zm;
 err=Sqrt[err[[1]]*Conjugate[err[[1]]]];
 Print["incx= ",incx,", incy= ",incy,", err norm= ",err];

 For[i=2,i<5,i++,size=TestSize[[i]];
     Print["Testing zaxpy for size ",size];
       xrange=Range[1,size/2,3];
       yrange=Range[1,2*size/3,5];
       a=Length[xrange];
       b=Length[yrange];
       For[j=1,j<a+1,j++,
          incx=xrange[[j]];
          For[k=1,k<b+1,k++,
            incy=yrange[[k]];
            nx = Round[size/incx];
            ny = Round[size/incy];
             n = Min[nx,ny];
           len = Max[n*incx,n*incy];
             x = Table[Random[],{xx,len}]+Table[Random[],{xx,len}]I;
             y = Table[Random[],{xx,len}]+Table[Random[],{xx,len}]I;
         alpha = Random[]+Random[]I;
            zn = NetSolve[zaxpy[n,alpha,x,incx,y,incy]];
            zm = y;
          For[ii=0,ii<n,ii++,
             zm[[1+incy*ii]] = y [[1+incy*ii]] + alpha*x[[1+incx*ii]]
             ];
           nm=zn-zm;
          llen=Length[nm];
          For[jj=1;s=0,jj<llen+1,jj++,
              s=s+Re[nm[[jj]]*Conjugate[nm[[jj]]]];
             ];
          err=Sqrt[s];
          Print["incx= ",incx,", incy= ",incy,", err norm= ",err]
              ];
            ];

    ];
Return[NSTestPause[]]

] 


(* ************ ddot **************** *)

NSTestddot[] := Module[{},
 Print["----------------"];
 Print["Testing ddot ..."];
 Print["----------------"];
 ClearAll[size,i,j,k,ii,jj,nm,s,llen,xx,len,a,b,xrange,yrange,incx,incy,n,x,y,zn,zm,err];
 Print["**************************"];
 Print["Testing ddot for size 1..."];
 Print["**************************"];
 size=1;
 xrange=1;
 yrange=1;
 incx=xrange;
 incy=yrange;
 n = 1;
 x = Table[Random[],{xx,1}];
 y = Table[Random[],{xx,1}];
 zn = NetSolve[ddot[n,x,incx,y,incy]];
 zm = y*x;
 err =zn-zm;
 Print["incx= ",incx,", incy= ",incy,", err norm= ",err,"\n"];

 For[i=2,i<5,i++,size=TestSize[[i]];
    Print["**************************"];
    Print["Testing ddot for size ",size];
    Print["**************************"];
    xrange=Range[1,size/2,3];
    yrange=Range[1,2*size/3,5];
       a=Length[xrange];
       b=Length[yrange];
       For[j=1,j<a+1,j++,
          incx=xrange[[j]];
          For[k=1,k<b+1,k++,
           incy=yrange[[k]];
            nx = Round[size/incx];
            ny = Round[size/incy];
             n = Min[nx,ny];
           len = Max[n*incx,n*incy];
             x = Table[Random[],{xx,len}];
             y = Table[Random[],{xx,len}];
            zn = NetSolve[ddot[n,x,incx,y,incy]];
            zm = y;
          For[ii=0,ii<n,ii++,
             zm[[1+incy*ii]] = y [[1+incy*ii]] * x[[1+incx*ii]] 
             ];
          nm=zn-zm;
          llen=Length[nm];
          For[jj=1;s=0,jj<llen+1,jj++,
              s=s+nm[[jj]]^2;
             ]; 
          err=Sqrt[s];

           
          Print["incx= ",incx,", incy= ",incy,", err norm= ",err,"\n"]
              ];
            ];

    ];
Return[NSTestPause[]]

]






NSTestBlas[] := Module[{},
   Print["\nThis test file written in Mathematica test"] ;
   Print["the NetSolve Mathematica Blas interface."];
  If[ StringQ[NetSolveGetAgent[] == False ],
       (Print["NetSolve is not installed. Please follow the debscribed"];
       Print["above procedure and run the test again"];
       Return[]),
       If[ NetSolveGetAgent[] == "",
           (Print["You have not setup an agent. Please run NetSolveSetAgent"];
            Print["to set up your agent and run this demo again.\n"];
            Return[]),
           Null
         ]
     ];

   Print["Now you are ready to run the test.\n"]; 
   Print["---------------------------------------------------"];
   Print["Testing the NetSolve MATHEMATICA BLAS  interfaces..."];
   Print["---------------------------------------------------"];
   
TestSize = {1,5,12,37};
NTC = {n,t,c};

   If[NSTestdgemm[],Return[],Null];  
   If[NSTestzgemm[],Return[],Null]; 
   If[NSTestdmatmul[],Return[],Null]; 
   If[NSTestzmatmul[],Return[],Null];  
   If[NSTestdaxpy[],Return[],Null]; 
   If[NSTestzaxpy[],Return[],Null];  
  (* If[NSTestddot[],Return[],Null]; *)
 
   
   
   Print["--------------------"];
   Print["** End of testing **"];
   Print["--------------------\n\n"]; 
   Pause[1];

]

NSTestBlas[]
ClearAll["NSTest*"]
