#include "storagetools.h"
#include "general.h"
#include "netsolveutil.h"
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>

/*
 * getPathForDisk()
 *
 */
char *getPathForDisk(char *diskname)
{
  char configfilename[256];
  FILE *f;
  char line[256];
  int linecount=0;
  /* char *token1; */
  char *token2;
  char *path = NULL;

  sprintf(configfilename,"%s/server_config",getNetSolveRoot());

  f = fopen(configfilename,"r");
  if (f == NULL)
  {
    fprintf(stderr,"Impossible to open file '%s'\n",configfilename);
    return NULL;
  }
  while(readLine(f,line,&linecount))
  {
    if (strncmp(line,"@DISK",5))
      continue;
    /* token1 = (char *)strtok(line," \t\n"); */
    token2 = (char*)strtok(NULL," \t\n");

    if (strncmp(token2,diskname,strlen(diskname)))
      continue;
    path = &(token2[strlen(diskname)+1]);
    break;
  }
  fclose(f);

  if (path == NULL)
  {
    fprintf(stderr,"Unknown disk: '%s'\n",diskname);
    return NULL;
  }

  return strdup(path);
}
