#include "core.h"
#include "storagetools.h"
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>

/*
 * getDiskSpace()
 *
 */
int getDiskSpace(char *diskname)
{
  char configfilename[256];
  FILE *f;
  char line[256];
  int linecount=0;
  char *token1,*token2,*token3;
  int total_space=-1;
  int used;
  FILE *stream;
  char command[256];
  char *path = 0;
  char *ptr;

  sprintf(configfilename,"%s/server_config",getNetSolveRoot());

  f = fopen(configfilename,"r");
  if (f == NULL)
  {
    fprintf(stderr,"Impossible to open file '%s'\n",configfilename);
    return -1;
  }
  while(readLine(f,line,&linecount))
  {
    if (strncmp(line,"@DISK",5))
      continue;
    token1 = (char *)strtok(line," \t\n");
    token2 = (char*)strtok(NULL," \t\n");
    token3 = (char*)strtok(NULL," \t\n");
    
    if (strncmp(token1,diskname,strlen(diskname)))
      continue;
    total_space = atoi(token3);
    path = strdup(&(token2[strlen(diskname)+1]));
    break;
  }
  fclose(f);

  if (total_space == -1)
  {
    fprintf(stderr,"Warning: Unknown disk '%s'\n",diskname);
    if(path) free(path);
    return -1;
  }
  /* since total_space != -1, we know that path != 0 */

  sprintf(command,"du -k -s %s",path);
  free(path);
  stream = popen(command,"r");
  if (stream == NULL)
  {
    perror("popen");
    ns_errno = NetSolveSystemError;
    return -1;
  }
  if (fgets(line,256,stream) == NULL)
  {
    perror("fgets");
    ns_errno = NetSolveSystemError;
    pclose(stream);
    return -1;
  }

  pclose(stream);
  
  ptr = strtok(line," \t\n");
  if (ptr == NULL)
    return -1;

  used = atoi(ptr);

  return (total_space - used);
}
