/*****************************************************************/
/*      server_terminates.c                                      */
/*      Henri Casanova                                           */
/*      modified by Karine Heydeman                              */
/*      modified by Susan Blackford and Patrick Geoffray         */
/*---------------------------------------------------------------*/
/*  Abort()                                                      */
/*****************************************************************/

#include <signal.h>
#include "core.h"
#include "serverglobal.h"
#include "abort.h"

#ifdef NWS
#include "nws_api.h"
#include "nwsutils.h"
#endif

/*
 *  Abort()
 *
 *  Terminates the server
 */
int Abort()
{
#ifdef NWS
  char what[1024];
#endif
  /* Kill the workload manager */
  (void)kill(global.workload_manager_pid,SIGTERM);
#ifdef HBM
  (void)kill(global.hbmlm_pid,SIGTERM);
#endif
#ifdef NWS
  (void) AdminNWSSensor(global.my_self->host_desc->hostname,what,"test");
  if (strncmp(what,"healthy",strlen("healthy")) ==0)
    processKillNWSHost(global.my_self->host_desc->hostname,NWS_DEFAULT_SENSOR_PORT);
  if (strncmp(what,"dead",strlen("dead")) !=0)
    AdminNWSSensor(global.my_self->host_desc->hostname,what,"kill");
#endif

  fprintf(stderr,"\nServer Terminating\n");
  return 0;
}
