/* This function is needed by kflops(), but is
   separated since, under advice, it should not
   be compiled with optimization */

/*----------------------*/ 
#include "kflops.h"

#ifdef __STDC__
REAL epslon(REAL x)
#else
REAL epslon (x)
REAL x;
#endif
/*
     estimate unit roundoff in quantities of size x.
*/

{
  REAL a,b,c,eps;
/*
     this program should function properly on all systems
     satisfying the following two assumptions,
        1.  the base used in representing dfloating point
            numbers is not a power of three.
        2.  the quantity  a  in statement 10 is represented to 
            the accuracy used in dfloating point variables
            that are stored in memory.
     the statement number 10 and the go to 10 are intended to
     force optimizing compilers to generate code satisfying 
     assumption 2.
     under these assumptions, it should be true that,
            a  is not exactly equal to four-thirds,
            b  has a zero for its last bit or digit,
            c  is not exactly equal to one,
            eps  measures the separation of 1.0 from
                 the next larger dfloating point number.
     the developers of eispack would appreciate being informed
     about any systems where these assumptions do not hold.

     *****************************************************************
     this routine is one of the auxiliary routines used by eispack iii
     to avoid machine dependencies.
     *****************************************************************

     this version dated 4/6/83.
*/

  a = 4.0e0/3.0e0;
  eps = ZERO;
  while (eps == ZERO) {
    b = a - ONE;
    c = b + b + b;
    eps = fabs((double)(c-ONE));
  }
  return(eps*fabs((double)x));
}
