/*****************************************************************/
/*      forkiterativesolverservice.c                             */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "serverglobal.h"
#include "scalapackservice.h"
#include "serviceutil.h"
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>

/*
 * forkiterativeSolverService()
 */
void forkiterativeSolverService(NS_Socket_type listening_socket, int ID,int client_major,
                          int lifelink_pid,
                         char *agent_name,
                         char *wd, char *serverhost,
                         int serverport, int restriction_index, 
                         char *xpath,char *xname,
                         NS_ProblemDesc *pd,NS_IPaddr_type proxy_IPaddr,
                         int proxy_port)
{
  time_t date1,date2;
  char machinefile[256];
  FILE *f;
  char verdict[20];
  int rows_proc,cols_proc,row_block,col_block;
  char stdoutfile[256];
  char **newargs;
  char mpi_path[256];
  char tmpstr[256];
  int pid;
  int status;
  int elapsed;
  int count;
  NS_Communicator *comm;
  NS_Socket_type sock;

  /***
   ***  FOR NOW, HARDCODED VALUES
   ***  Should put in server_config or problem_description
   ***/
  rows_proc = 1;
  cols_proc = 1;
  row_block = 64;
  col_block = 64;

  /* MPI */
  if (global.MPInodefile != NULL)
    sprintf(machinefile,"%s/%s",global.netsolve_root_path,
                                global.MPInodefile);

  /* Creating the MPI virtual machine */
#ifdef VIEW
  fprintf(stderr,"Starting up MPI....\n");
#endif
  /* Replacing with a fork and exec 
  sprintf(command,"%s/mpirun -machinefile %s -np %d %s/%s %s %d %d %d %d %d",
                        global.MPI_path,
                        machinefile, rows_proc*cols_proc,xpath,xname,
                        wd,client_major,row_block,col_block,
                        rows_proc,cols_proc);
                        
  system(command);
  */
  newargs=(char **)malloc(sizeof(char *)*13);
  count=0;
  sprintf(mpi_path,"%s/bin/mpirun", global.MPI_path);
  newargs[count++]=strdup(mpi_path);
  if (global.MPInodefile != NULL)
  {
    newargs[count++]=strdup("-machinefile");
    newargs[count++]=strdup(machinefile);
  }
  newargs[count++]=strdup("-np"); 
  sprintf(tmpstr,"%d",(rows_proc*cols_proc));
  newargs[count++]=strdup(tmpstr);
  sprintf(tmpstr,"%s/%s",xpath,xname);
  newargs[count++]=strdup(tmpstr);
  newargs[count++]=strdup(wd);
  sprintf(tmpstr,"%d",client_major);
  newargs[count++]=strdup(tmpstr);
  sprintf(tmpstr,"%d",row_block);
  newargs[count++]=strdup(tmpstr);
  sprintf(tmpstr,"%d",col_block);
  newargs[count++]=strdup(tmpstr);
  sprintf(tmpstr,"%d",rows_proc);
  newargs[count++]=strdup(tmpstr);
  sprintf(tmpstr,"%d",cols_proc);
  newargs[count++]=strdup(tmpstr);
  newargs[count++]='\0';

  time(&date1);
  pid=fork();

  /* child */
  if(pid == 0)
  {
    execvp(mpi_path,newargs);

    /* only get here if execvp fails */
    perror("execvp");
    exit(-1);
  }

  /* father */
  waitpid(pid,&status,0);

  time(&date2);

  /* waiting for the done file */
  /* replace with checking the status  
  while((f = fopen("./done","r")) == NULL)
    sleep(3); */
  
  if((f = fopen("./done","r")) == NULL) {
#ifdef VIEW
    fprintf(stderr,"Error computation not done. \n");
#endif
    netsolvePerror("");
    notifyServiceFinished(serverhost,serverport,restriction_index);
    kill(lifelink_pid,SIGKILL);
    notifyProxy(proxy_IPaddr,proxy_port,NetSolveInternalError,ID);
    cleanUp(wd);
    exit(0);
  }

  /* Getting the verdict */
  fscanf(f,"%s",verdict);
  fclose(f);

  /* Error ? */
  if (!strcmp(verdict,"ERROR"))
  {
#ifdef VIEW
    fprintf(stderr,"NS: Iterative Service ERROR\n");
#endif
    notifyProxy(proxy_IPaddr,proxy_port,NetSolveServerError,ID);
    notifyServiceFinished(serverhost,serverport,restriction_index);
    cleanUp(wd);
    exit(-1);
  }

 /* Notifying the proxy of completion */
  kill(lifelink_pid,SIGKILL);
  if (notifyProxy(proxy_IPaddr,proxy_port,NetSolveOK,ID) == -1)
  {
    cleanUp(wd);
    notifyServiceFinished(serverhost,serverport,restriction_index);
    exit(0);
  }
  /* Listening on the socket */
  if ((sock = acceptConnection(listening_socket)) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while accepting the connection.\n");
#endif
    notifyServiceFinished(serverhost,serverport,restriction_index);
    cleanUp(wd);
    exit(0);
  }
  comm = acceptTransaction(sock);
  if (comm == NULL)
  {
#ifdef VIEW
    fprintf(stderr,"Error while accepting the transaction.\n");
#endif
    notifyServiceFinished(serverhost,serverport,restriction_index);
    cleanUp(wd);
    exit(0);
  }

/* Sending back the elapsed time */
  elapsed = (int)(date2-date1);
  if (sendInt(comm,elapsed) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while sending the elapsed time.\n");
#endif
    netsolvePerror("sendInt()");
    notifyServiceFinished(serverhost,serverport,restriction_index);
    endTransaction(comm);
    cleanUp(wd);
    exit(0);
  }

  /* sending back whatever stdout has been generated */
  sprintf(stdoutfile,"%s/netsolve-stdout",wd);
  if (sendFileAsString(comm,stdoutfile) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while sending the stdout.\n");
#endif
    notifyServiceFinished(serverhost,serverport,restriction_index);
    endTransaction(comm);
    cleanUp(wd);
    exit(0);
  }

  /* SUCCESS !! */
  sendInt(comm,NS_PROT_SOLVED);

  /* Sending back the output */
  if (sendOutputObjectsFromFiles(comm,pd) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while sending the output objects from files.\n");
#endif
    netsolvePerror("sendOutputObjectsFromFiles()");
    notifyServiceFinished(serverhost,serverport,restriction_index);
    endTransaction(comm);
    cleanUp(wd);
    exit(0);
  }

  /* Terminating the transaction */
  endTransaction(comm);
  notifyServiceFinished(serverhost,serverport,restriction_index);

#ifdef VIEW
  fprintf(stderr,"Completed\n");
#endif

  /* Cleaning up */
  cleanUp(wd);
  exit(0);
}
