/*****************************************************************/
/*      initNWSServer.c                                          */
/*      Karine Heydeman                                          */
/*      modified by Susan Blackford and Patrick Geoffray         */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>

#include "nwsutils.h"

int hostcompose( const char * machineName, int machinePort, char * name)
{
char port[8];

 if ( strncat(name,machineName,strlen(machineName)) == NULL)
   { printf(" merde ");  return (-1);}
 if ( strncat(name,":",1) == NULL)
  {
    printf(" can't append : %s", machineName);
    return(-1);
  }
 sprintf(port,"%i",machinePort);
 if (strncat(name,port,strlen(port)) != NULL ) 
     return 0;
else
     return -1;

}



int startNWSSensor(int Sport,char * servername, char *NSname, int NSport,char *Memname, int Memport)
{
int pid;
char S_Port[8], NScomp[70], Mcomp[70];

 sprintf(S_Port, "%d", NWS_DEFAULT_SENSOR_PORT);

 if (hostcompose(NSname,NSport,NScomp)== -1)
   {   printf(" startsensor, composition de NS ...."); return -1;}

 if (hostcompose(Memname,Memport,Mcomp)== -1)
   {   printf(" startsensor, composition de Mem ...."); return -1;}

 pid=fork();
 if (pid !=0) /* I am the father */ 
   { 
     return(0);
   }
 if (execlp("nws_sensor",
        "nws_sensor",
        "-e",
        NWS_SENSOR_ERR,
        "-l",
        NWS_SENSOR_LOG,
        "-M",
        Mcomp,
        "-N",
	 NScomp, 
        "-p",
        S_Port,
        NULL) < 0 )

  {
    fprintf(stderr,"ERROR: Unable to start NWS_sensor\n");
    exit(-1);
  }
 return 0;
}
