/*****************************************************************/
/*      forkstandardservice.c                                    */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "serverglobal.h"
#include "standardservice.h"
#include <fcntl.h>
#include <unistd.h>

/*
 * forkStandardFileService()
 */
void forkStandardFileService(NS_Socket_type listening_socket,int ID,
                         int client_major, int lifelink_pid,
                         char *agent_name, 
                         char *wd, char *serverhost,
                         int serverport, int restriction_index, 
                         char *xpath,char *xname,
                         NS_ProblemDesc *pd,NS_IPaddr_type proxy_IPaddr,
                         int proxy_port)
{
  forkStandardService(listening_socket,ID,client_major,
                      lifelink_pid,agent_name,
                      wd,serverhost,
                      serverport,restriction_index, 
                      xpath,xname,pd,proxy_IPaddr, proxy_port, FILES, -1);
}

/*
 * forkStandardFileService()
 */
void forkStandardFileService_sequence(NS_Socket_type listening_socket,int ID,
                         int client_major, int lifelink_pid,
                         char *agent_name, 
                         char *wd, char *serverhost,
                         int serverport, int restriction_index, 
                         char *xpath,char *xname,
                         NS_ProblemDesc *pd,NS_IPaddr_type proxy_IPaddr,
                         int proxy_port, int node_nr)
{

  forkStandardService(listening_socket,ID,client_major,
                      lifelink_pid,agent_name,
                      wd,serverhost,
                      serverport,restriction_index, 
                      xpath,xname,pd,proxy_IPaddr, proxy_port, FILES, node_nr);
}



/*
 * forkStandardNoFileService()
 */
void forkStandardNoFileService(NS_Socket_type listening_socket,
                               char *agent_name,
                               char *wd, 
                               char *serverhost,
                               int serverport, 
                               int restriction_index, 
                               char *xpath,
                               char *xname,
                               NS_ProblemDesc *pd,
                               NS_IPaddr_type proxy_IPaddr,
                               int proxy_port)
{
  /* Pass a bogus client major and ID and lifelink pid*/
#ifdef KERBEROS5
  if(global.require_auth)
    forkStandardService(listening_socket,-1,-1,-1,agent_name,
                      wd,serverhost,
                      serverport,restriction_index,
                      xpath,xname,pd,proxy_IPaddr, proxy_port,NOFILES,-2);
  else
    forkStandardService(listening_socket,-1,-1,-1,agent_name,
                      wd,serverhost,
                      serverport,restriction_index, 
                      xpath,xname,pd,proxy_IPaddr, proxy_port,NOFILES,-1);
#else
  forkStandardService(listening_socket,-1,-1,-1,agent_name,
                      wd,serverhost,
                      serverport,restriction_index,
                      xpath,xname,pd,proxy_IPaddr, proxy_port,NOFILES,-1);
#endif
}

/*
 * forkStandardService()
 */
void forkStandardService(NS_Socket_type listening_socket, int ID,
                         int client_major,int lifelink_pid,
                         char *agent_name,
                         char *wd, char *serverhost,
                         int serverport, int restriction_index, 
                         char *xpath,char *xname,
                         NS_ProblemDesc *pd, NS_IPaddr_type proxy_IPaddr, 
                         int proxy_port,int filemode, int node_nr)
{
  char fullpath[256];
  char buffer[10];
  char **args;


  /* Construct the arguments to the service process */
  /* So far, the arguments are:                     */
  /*     - xname : executable name                  */
  /*     - sock:   listening socket                 */
  /*     - serverhost: server host                  */
  /*     - serverport: server port                  */
  /*     - restriction: restriction_index           */
  /*     - wdir: working directory                  */
  /*     - filemode: files or no files major        */
  /*     - client_major: expected major             */
  /*     - agent_name: agent that gave access       */
  /*     - proxy_IPAddr: IP address of the proxy    */
  /*     - proxy_port: port of the client proxy     */
  /*     - ID: request_id                           */

  
  args=(char**)calloc(15,sizeof(char*));
  args[0] = strdup(xname);
  sprintf(buffer,"%d",listening_socket);
  args[1] = strdup(buffer);
  args[2] = strdup(serverhost);
  sprintf(buffer,"%d",serverport);
  args[3] = strdup(buffer);
  sprintf(buffer,"%d",restriction_index);
  args[4] = strdup(buffer);
  args[5] = strdup(wd);
  sprintf(buffer,"%d",filemode);
  args[6] = strdup(buffer);
  sprintf(buffer,"%d",client_major);
  args[7] = strdup(buffer);
  args[8] = strdup(agent_name);
  sprintf(buffer,"%u.%u.%u.%u",
            BYTE(&proxy_IPaddr,0),
            BYTE(&proxy_IPaddr,1),
            BYTE(&proxy_IPaddr,2),
            BYTE(&proxy_IPaddr,3));
  args[9] = strdup(buffer);
  sprintf(buffer,"%d",proxy_port);
  args[10] = strdup(buffer);
  sprintf(buffer,"%d",ID);
  args[11] = strdup(buffer);
  sprintf(buffer,"%d",lifelink_pid);
  args[12] = strdup(buffer);
  sprintf(buffer,"%d",node_nr);
  args[13] = strdup(buffer);
  args[14] = NULL;

#if defined(DEBUG)
  ns_printinfo();
  fprintf(stderr, "About to Exec the service: %s/%s\n", xpath, xname);
#endif
  /* execv */
  sprintf(fullpath,"%s/%s",xpath,xname);
  execv(fullpath,args);
}
