#ifdef DEBUG
ierr = vec_print(comm,"rhs",first,local_size,rhs_vector);
ierr = vec_print(comm,"solution",first,local_size,sol_vector);
#endif

ierr = distr_matmult(comm, values,indices,pointers,
		     first,local_size,total_size,
		     sol_vector,tmp_vector);

#ifdef DEBUG
ierr = vec_print(comm,"AX (s/b==1)",first,local_size,tmp_vector);
#endif

ierr = vec_diff_norm(comm, tmp_vector,rhs_vector,local_size,&tmp);
ERR_ABORT(ierr);
if (mytid==0) printf("Residual norm: %e\n",tmp);

destruct_crs_system(values,indices,pointers,
		    sol_vector,rhs_vector,tmp_vector);

#if LINK_PETSC==1
  /* again, only for gdb */
  ierr = PetscFinalize(); ERR_RETURN(ierr);
#endif

ierr = MPI_Finalize();  ERR_ABORT(ierr);
