#ifdef HINV
domain_size = HINV;
#else
if (mytid==0) {
#ifdef HAS_PETSC
#ifdef petsc210
  ierr = PetscOptionsGetInt(PETSC_NULL,"-size",&domain_size,&flg); CHKERRQ(ierr);
#else
  ierr = OptionsGetInt(PETSC_NULL,"-size",&domain_size,&flg); CHKERRQ(ierr);
#endif
  if (!flg) {
    printf("Give domain size h^{-1} ( <0 for HB matrix ): ");
    scanf("%d",&domain_size); printf("\n");}
#else
  printf("Give domain size h^{-1} ( <0 for HB matrix ): ");
  scanf("%d",&domain_size); printf("\n");
#endif
}
ierr = MPI_Bcast(&domain_size,1,MPI_INT,0,comm); ERR_ABORT(ierr);
#endif
if (domain_size>0) {
  total_size = domain_size * domain_size;

  ierr = divide(comm,total_size,&first,&last); ERR_ABORT(ierr);
  if (ierr) printf("Error in vector divide routine\n");
  local_size = last-first;
  
  construct_crs_system
    (&values,&indices,&pointers,&nnzeros,
     first,local_size,domain_size,total_size);
  construct_crs_vectors
    (first,local_size,domain_size,total_size,
     &sol_vector,&rhs_vector,&tmp_vector);
  /*{
    double nrm;
    ierr = vec_norm(comm,rhs_vector,local_size,&nrm); ERR_RETURN(ierr);
    if (mytid==0) printf("Rhs norm: %e\n",nrm);
    }*/
} else {
#if 0
#include "../test/iohb.h"
  char name[20]; int M,N,i;
  if (ntids>1)
    ERR_REPORT("Sorry, can only handle HB matrices on single processor");
  printf("Give matrix name: "); scanf("%s",&name); printf("\n");
  readHB_newmat_double(name, &M, &N, &nnzeros,&pointers,&indices,&values);

  /* &colptr, &rowind, &cval); */
  if (M!=N) ERR_REPORTii("Matrix not square",M,N);
  total_size = domain_size = M;

  sol_vector = (double*) malloc(total_size*sizeof(double));
  if (!sol_vector) ERR_REPORT("Could not allocate sol");
  rhs_vector = (double*) malloc(total_size*sizeof(double));
  if (!rhs_vector) ERR_REPORT("Could not allocate rhs");
  for (i=0; i<total_size; i++) rhs_vector[i] = 1.;
  tmp_vector = (double*) malloc(total_size*sizeof(double));
  if (!tmp_vector) ERR_REPORT("Could not allocate tmp");
#endif
  }

#ifdef DEBUG
  ierr = print_crs_matrix(values,indices,pointers,0,first,local_size);
  if (ierr) {
    printf("error in print_crs_matrix\n"); return 1;}
#endif

#ifdef PACKAGE_TYPE_iterative
  if (mytid==0) {
#ifdef HAS_PETSC
#ifdef petsc210
    ierr = PetscOptionsGetDouble(PETSC_NULL,"-rtol",&rtol,&flg); CHKERRQ(ierr);
#else
    ierr = OptionsGetDouble(PETSC_NULL,"-rtol",&rtol,&flg); CHKERRQ(ierr);
#endif
    if (!flg) {
      printf("Relative tolerance : "); scanf("%lf",&rtol); printf("\n");}
#ifdef petsc210
    ierr = PetscOptionsGetInt(PETSC_NULL,"-maxit",&maxit,&flg); CHKERRQ(ierr);
#else
    ierr = OptionsGetInt(PETSC_NULL,"-maxit",&maxit,&flg); CHKERRQ(ierr);
#endif
    if (!flg) {
      printf("Maximum #iterations : "); scanf("%d",&maxit); printf("\n");}
#else
    printf("Relative tolerance : "); scanf("%lf",&rtol); printf("\n");
    printf("Maximum #iterations : "); scanf("%d",&maxit); printf("\n");
#endif
  }
  MPI_Bcast(&rtol,1,MPI_DOUBLE,0,comm);
  MPI_Bcast(&maxit,1,MPI_INT,0,comm);
#endif
