/*
 * tester for the superlu direct solver
 */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "./netsolve_superlu.h"

int main(int Argc,char **Args)
{
#include "../test/declarations.c"
  direct_info_block info; int perm;

#include "../test/setup.c"
  if (mytid==0) {
    printf("Permutation (0=nat, 1=md(At*A), 2=md(At+A)) : ");
    scanf("%d",&perm); printf("\n");}
  MPI_Bcast(&perm,1,MPI_INT,0,comm);

  ierr = superlu_params(&info,perm); ERR_ABORT(ierr);

  ierr = superlu_driver
    (MPI_COMM_WORLD,
     values,indices,pointers,local_size,
     info,
     rhs_vector,sol_vector); ERR_ABORT(ierr);

#include "../test/unset.c"

  return 0;
}
